/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.mzdb;

import com.almworks.sqlite4java.SQLiteException;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.db.model.Run;
import fr.profi.mzdb.db.model.Sample;
import fr.profi.mzdb.db.model.params.ScanList;
import fr.profi.mzdb.db.model.params.ScanParamTree;
import fr.profi.mzdb.db.model.params.param.CVParam;
import fr.profi.mzdb.model.DataEncoding;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.proline.mzscope.model.QCMetrics;
import fr.proline.mzscope.mzdb.MzdbRawFile;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MzdbMetricsCollector {
    private static final Logger logger = LoggerFactory.getLogger(MzdbMetricsCollector.class);

    public static Map<String, Object> getFileFormatData(MzDbReader reader) throws SQLiteException {
        LinkedHashMap<String, Object> metrics = new LinkedHashMap<String, Object>();
        metrics.put("Filename", reader.getFirstSourceFileName());
        List<Run> runs = reader.getRuns();
        if (runs != null && !runs.isEmpty()) {
            metrics.put("Acquisition date", runs.get(0).getStartTimestamp());
        }
        metrics.put("Format", "mzdb");
        metrics.put("Format version", reader.getModelVersion());
        metrics.put("PWIZ version", reader.getPwizMzDbVersion());
        metrics.put("Source file", reader.getFirstSourceFileName());
        metrics.put("Acquisition mode", reader.getAcquisitionMode().name());
        List<Sample> samples = reader.getSamples();
        if (samples != null && !samples.isEmpty()) {
            metrics.put("Samples", samples.stream().map(Sample::getName).collect(Collectors.joining(",")));
        }
        SpectrumHeader firstHeader = reader.getMs1SpectrumHeaders()[0];
        DataEncoding encoding = reader.getSpectrumDataEncoding(firstHeader.getId());
        metrics.put("MS1 encoding", encoding.getMode().name());
        firstHeader = reader.getMs2SpectrumHeaders()[0];
        encoding = reader.getSpectrumDataEncoding(firstHeader.getId());
        metrics.put("MS2 encoding", encoding.getMode().name());
        return metrics;
    }

    public static QCMetrics getMSMetrics(MzdbRawFile rawFile) throws SQLiteException {
        QCMetrics metrics = new QCMetrics(rawFile);
        MzDbReader reader = rawFile.getMzDbReader();
        metrics.addMetric("Cycles count", reader.getCyclesCount());
        int maxMsLevel = reader.getMaxMsLevel();
        DescriptiveStatistics[] TICStatistics = new DescriptiveStatistics[maxMsLevel];
        DescriptiveStatistics[] SumTICStatistics = new DescriptiveStatistics[maxMsLevel];
        DescriptiveStatistics[] RTStatistics = new DescriptiveStatistics[maxMsLevel];
        DescriptiveStatistics[] PeaksCountStatistics = new DescriptiveStatistics[maxMsLevel];
        DescriptiveStatistics[] InjectionTimeStatistics = new DescriptiveStatistics[maxMsLevel];
        DescriptiveStatistics AllRTStatistics = new DescriptiveStatistics();
        metrics.addMetric("Max MS level", maxMsLevel);
        for (int msLevel = 1; msLevel <= maxMsLevel; ++msLevel) {
            StringBuilder labelBuilder = new StringBuilder();
            labelBuilder.append("MS").append(msLevel).append(" Spectra count");
            metrics.addMetric(labelBuilder.toString(), reader.getSpectraCount(msLevel));
            int[] range = reader.getMzRange(msLevel);
            labelBuilder = new StringBuilder();
            labelBuilder.append("MS").append(msLevel).append(" min m/z");
            metrics.addMetric(labelBuilder.toString(), range[0]);
            labelBuilder = new StringBuilder();
            labelBuilder.append("MS").append(msLevel).append(" max m/z");
            metrics.addMetric(labelBuilder.toString(), range[1]);
            SumTICStatistics[msLevel - 1] = new DescriptiveStatistics();
            TICStatistics[msLevel - 1] = new DescriptiveStatistics();
            RTStatistics[msLevel - 1] = new DescriptiveStatistics();
            PeaksCountStatistics[msLevel - 1] = new DescriptiveStatistics();
            InjectionTimeStatistics[msLevel - 1] = new DescriptiveStatistics();
        }
        SpectrumHeader[] headers = reader.getSpectrumHeaders();
        SpectrumHeader.loadScanLists(headers, reader.getConnection());
        metrics.addMetric("RT start", (int)Math.round((double)headers[0].getTime() / 60.0));
        metrics.addMetric("RT end", (int)Math.round((double)headers[headers.length - 1].getTime() / 60.0));
        float duration = (headers[headers.length - 1].getTime() - headers[0].getTime()) / 60.0f;
        double ticSum = 0.0;
        metrics.addMetric("RT duration", Math.round(duration));
        TreeMap<Integer, Integer> chargeStates = new TreeMap<Integer, Integer>();
        for (SpectrumHeader header : headers) {
            List<ScanParamTree> scans;
            ScanList sl = header.getScanList();
            if (sl == null) {
                header.loadScanList(reader.getConnection());
            }
            if (sl != null && (scans = sl.getScans()) != null && !scans.isEmpty()) {
                ScanParamTree spt = scans.get(0);
                for (CVParam cvParam : spt.getCVParams()) {
                    if (!cvParam.getAccession().equals("MS:1000927")) continue;
                    InjectionTimeStatistics[header.getMsLevel() - 1].addValue(Double.valueOf(cvParam.getValue()).doubleValue());
                    break;
                }
            }
            SumTICStatistics[header.getMsLevel() - 1].addValue(ticSum += (double)header.getTIC());
            TICStatistics[header.getMsLevel() - 1].addValue((double)header.getTIC());
            RTStatistics[header.getMsLevel() - 1].addValue((double)header.getTime() / 60.0);
            AllRTStatistics.addValue((double)header.getTime() / 60.0);
            PeaksCountStatistics[header.getMsLevel() - 1].addValue((double)header.getPeaksCount());
            if (header.getMsLevel() != 2 || header.getPrecursorCharge() <= 0) continue;
            if (!chargeStates.containsKey(header.getPrecursorCharge())) {
                chargeStates.put(header.getPrecursorCharge(), 1);
                continue;
            }
            chargeStates.put(header.getPrecursorCharge(), (Integer)chargeStates.get(header.getPrecursorCharge()) + 1);
        }
        metrics.addMetric("MS  Sum TIC ", SumTICStatistics);
        metrics.addMetric("MS TIC", TICStatistics);
        metrics.addMetric("RT events ", AllRTStatistics);
        metrics.addMetric("RT MS events ", RTStatistics);
        metrics.addMetric("MS peaks count", PeaksCountStatistics);
        metrics.addMetric("MS injection time", InjectionTimeStatistics);
        for (Map.Entry entry : chargeStates.entrySet()) {
            String label = "MS2 precursor " + entry.getKey() + "+";
            metrics.addMetric(label, entry.getValue());
        }
        return metrics;
    }
}

