/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui;

import fr.proline.mzscope.model.IChromatogram;
import fr.proline.mzscope.model.IPeakel;
import fr.proline.mzscope.model.IRawFile;
import fr.proline.mzscope.model.MsnExtractionRequest;
import fr.proline.mzscope.ui.AbstractRawFilePanel;
import fr.proline.mzscope.ui.model.MzScopePreferences;
import fr.proline.mzscope.utils.Display;
import fr.proline.mzscope.utils.MzScopeCallback;
import fr.proline.studio.graphics.marker.IntervalMarker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiRawFilePanel
extends AbstractRawFilePanel {
    private static final Logger logger = LoggerFactory.getLogger(MultiRawFilePanel.class);
    private final List<IRawFile> rawfiles;
    private final Map<IRawFile, IChromatogram> chromatogramByRawFile;
    private final Map<String, Color> colorByRawFilename;
    private IRawFile currentRawFile;

    public MultiRawFilePanel(List<IRawFile> rawfiles) {
        this.rawfiles = rawfiles;
        this.chromatogramByRawFile = new HashMap<IRawFile, IChromatogram>();
        this.colorByRawFilename = new HashMap<String, Color>();
        this.currentRawFile = this.rawfiles.get(0);
        for (IRawFile rawFile : rawfiles) {
            this.chromatogramByRawFile.put(rawFile, null);
            this.colorByRawFilename.put(rawFile.getName(), null);
        }
        this.displayTIC(-1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MultiRawFilePanel.this.updateToolbar();
            }
        });
    }

    @Override
    public IRawFile getCurrentRawfile() {
        return this.currentRawFile;
    }

    @Override
    public void extractAndDisplayChromatogram(final MsnExtractionRequest params, Display display, MzScopeCallback callback) {
        SwingWorker<Integer, IChromatogram> worker = new SwingWorker<Integer, IChromatogram>(){
            Display display = new Display(Display.Mode.SERIES);

            @Override
            protected Integer doInBackground() throws Exception {
                int count = 0;
                for (IRawFile rawFile : MultiRawFilePanel.this.rawfiles) {
                    IChromatogram c = rawFile.getXIC(params);
                    ++count;
                    this.publish(c);
                }
                return count;
            }

            @Override
            protected void process(List<IChromatogram> chunks) {
                for (int k = 0; k < chunks.size(); ++k) {
                    logger.info("display chromato number {}", (Object)k);
                    MultiRawFilePanel.this.displayChromatogram(chunks.get(k), this.display);
                }
            }

            @Override
            protected void done() {
                try {
                    MultiRawFilePanel.this.chromatogramPanel.setCurrentChromatogram((IChromatogram)MultiRawFilePanel.this.chromatogramByRawFile.get(MultiRawFilePanel.this.currentRawFile));
                    logger.info("{} TIC chromatogram extracted", this.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.error("Error while reading chromatogram");
                }
            }
        };
        worker.execute();
    }

    @Override
    public IChromatogram getCurrentChromatogram() {
        return this.chromatogramByRawFile.get(this.currentRawFile);
    }

    @Override
    public Color displayChromatogram(IChromatogram chromato, Display display) {
        this.setMsMsEventButtonEnabled(true);
        Color plotColor = super.displayChromatogram(chromato, display);
        this.colorByRawFilename.put(chromato.getRawFilename(), plotColor);
        return plotColor;
    }

    @Override
    public void displayChromatograms(Map<IRawFile, IChromatogram> chromatogramByRawFile, Display display) {
        super.displayChromatograms(chromatogramByRawFile, display);
    }

    @Override
    protected void displayTIC(final int msLevel) {
        final ArrayList<IRawFile> rawFiles = new ArrayList<IRawFile>(this.rawfiles);
        if (this.rawFileLoading != null) {
            this.rawFileLoading.setWaitingState(true);
        }
        logger.info("Display {} TIC chromatograms", (Object)rawFiles.size());
        SwingWorker<Integer, IChromatogram> worker = new SwingWorker<Integer, IChromatogram>(){
            Display display = new Display(Display.Mode.SERIES);

            @Override
            protected Integer doInBackground() throws Exception {
                int count = 0;
                for (IRawFile rawFile : rawFiles) {
                    IChromatogram c = rawFile.getTIC(msLevel);
                    MultiRawFilePanel.this.chromatogramByRawFile.put(rawFile, c);
                    this.publish(c);
                }
                return count;
            }

            @Override
            protected void process(List<IChromatogram> chunks) {
                for (int k = 0; k < chunks.size(); ++k) {
                    logger.info("diplay TIC number {}", (Object)k);
                    MultiRawFilePanel.this.displayChromatogram(chunks.get(k), this.display);
                }
                MultiRawFilePanel.this.setMsMsEventButtonEnabled(false);
            }

            @Override
            protected void done() {
                try {
                    MultiRawFilePanel.this.chromatogramPanel.setCurrentChromatogram((IChromatogram)MultiRawFilePanel.this.chromatogramByRawFile.get(MultiRawFilePanel.this.currentRawFile));
                    logger.info("{} TIC chromatogram extracted", this.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.error("Error while reading chromatogram");
                }
                finally {
                    if (MultiRawFilePanel.this.rawFileLoading != null) {
                        MultiRawFilePanel.this.rawFileLoading.setWaitingState(false);
                    }
                }
            }
        };
        worker.execute();
    }

    @Override
    public void displayPeakel(final IPeakel f) {
        double ppm = MzScopePreferences.getInstance().getMzPPMTolerance();
        final double maxMz = f.getMz() + f.getMz() * ppm / 1000000.0;
        final double minMz = f.getMz() - f.getMz() * ppm / 1000000.0;
        final ArrayList<IRawFile> rawFiles = new ArrayList<IRawFile>(this.rawfiles);
        SwingWorker<Integer, IChromatogram> worker = new SwingWorker<Integer, IChromatogram>(){
            int count = 0;
            boolean isFirstProcessCall = true;

            @Override
            protected Integer doInBackground() throws Exception {
                for (IRawFile rawFile : rawFiles) {
                    MsnExtractionRequest params = ((MsnExtractionRequest.Builder)((MsnExtractionRequest.Builder)MsnExtractionRequest.builder().setMaxMz(maxMz)).setMinMz(minMz)).build();
                    IChromatogram c = rawFile.getXIC(params);
                    ++this.count;
                    this.publish(c);
                }
                return this.count;
            }

            @Override
            protected void process(List<IChromatogram> chunks) {
                int k = 0;
                Display display = new Display(Collections.singletonList(new IntervalMarker(null, Color.ORANGE, Color.RED, (double)f.getFirstElutionTime(), (double)f.getLastElutionTime())));
                if (this.isFirstProcessCall) {
                    logger.info("display first chromato");
                    this.isFirstProcessCall = false;
                    MultiRawFilePanel.this.displayChromatogram(chunks.get(0), new Display(Display.Mode.REPLACE));
                    k = 1;
                    MultiRawFilePanel.this.displayScan(MultiRawFilePanel.this.getCurrentRawfile().getSpectrumId(f.getElutionTime()));
                    MultiRawFilePanel.this.chromatogramPanel.displayFeature(f, display);
                }
                while (k < chunks.size()) {
                    logger.info("add additionnal chromato");
                    MultiRawFilePanel.this.displayChromatogram(chunks.get(k), new Display(Display.Mode.OVERLAY));
                    MultiRawFilePanel.this.displayScan(MultiRawFilePanel.this.getCurrentRawfile().getSpectrumId(f.getElutionTime()));
                    MultiRawFilePanel.this.chromatogramPanel.displayFeature(f, display);
                    ++k;
                }
            }

            @Override
            protected void done() {
                try {
                    MultiRawFilePanel.this.chromatogramPanel.setCurrentChromatogram((IChromatogram)MultiRawFilePanel.this.chromatogramByRawFile.get(MultiRawFilePanel.this.currentRawFile));
                    logger.info("{} Display Feature", this.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.error("Error while displaying feature");
                }
            }
        };
        worker.execute();
    }

    @Override
    protected void displayBPI() {
        final ArrayList<IRawFile> rawFiles = new ArrayList<IRawFile>(this.rawfiles);
        logger.info("Display {} BPI chromatogram", (Object)rawFiles.size());
        SwingWorker<Integer, IChromatogram> worker = new SwingWorker<Integer, IChromatogram>(){
            Display display = new Display(Display.Mode.SERIES);

            @Override
            protected Integer doInBackground() throws Exception {
                int count = 0;
                for (IRawFile rawFile : rawFiles) {
                    IChromatogram c = rawFile.getBPI();
                    ++count;
                    this.publish(c);
                }
                return count;
            }

            @Override
            protected void process(List<IChromatogram> chunks) {
                for (int k = 0; k < chunks.size(); ++k) {
                    logger.info("display BPI chromato number {}", (Object)k);
                    MultiRawFilePanel.this.displayChromatogram(chunks.get(k), this.display);
                }
                MultiRawFilePanel.this.setMsMsEventButtonEnabled(false);
            }

            @Override
            protected void done() {
                try {
                    logger.info("{} BPI chromatogram extracted", this.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.error("Error while reading chromatogram");
                }
            }
        };
        worker.execute();
    }

    private IRawFile getRawFile(String fileName) {
        for (IRawFile rawFile : this.rawfiles) {
            if (!rawFile.getName().equals(fileName)) continue;
            return rawFile;
        }
        return null;
    }

    protected JToolBar updateToolbar() {
        final JPopupMenu popupMenu = new JPopupMenu();
        ButtonGroup bg = new ButtonGroup();
        ActionListener changeCurrentChromatogramAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton aButton = (AbstractButton)actionEvent.getSource();
                logger.debug("Selected: " + aButton.getText());
                IRawFile rawFile = MultiRawFilePanel.this.getRawFile(aButton.getText());
                if (rawFile != null) {
                    MultiRawFilePanel.this.chromatogramPanel.setCurrentChromatogram((IChromatogram)MultiRawFilePanel.this.chromatogramByRawFile.get(rawFile));
                    MultiRawFilePanel.this.currentRawFile = rawFile;
                    if (MultiRawFilePanel.this.chromatogramPanel.getCurrentScanTime() != null) {
                        int scanIdx = rawFile.getSpectrumId(MultiRawFilePanel.this.chromatogramPanel.getCurrentScanTime().floatValue());
                        MultiRawFilePanel.this.currentScan = null;
                        MultiRawFilePanel.this.displayScan(scanIdx);
                    }
                    if (MultiRawFilePanel.this.getShowMS2Button().isSelected()) {
                        MultiRawFilePanel.this.showMSMSEvents();
                    }
                }
            }
        };
        for (final IRawFile rawFile : this.rawfiles) {
            JRadioButtonMenuItem mi = new JRadioButtonMenuItem(rawFile.getName());
            mi.setIcon(new Icon(){

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    Color previousColor = g.getColor();
                    g.setColor(MultiRawFilePanel.this.getPlotColor(rawFile.getName()));
                    g.fillRect(x, y, 10, 10);
                    g.setColor(previousColor);
                }

                @Override
                public int getIconWidth() {
                    return 10;
                }

                @Override
                public int getIconHeight() {
                    return 10;
                }
            });
            mi.addActionListener(changeCurrentChromatogramAction);
            popupMenu.add(mi);
            bg.add(mi);
        }
        ((JRadioButtonMenuItem)popupMenu.getComponent(0)).setSelected(true);
        final JButton currentChromatoBtn = new JButton("Chr");
        this.setToolTipText("Display TIC IChromatogram");
        currentChromatoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                popupMenu.show(currentChromatoBtn, 0, currentChromatoBtn.getHeight());
            }
        });
        this.chromatogramToolbar.addSeparator();
        this.chromatogramToolbar.add(currentChromatoBtn);
        return this.chromatogramToolbar;
    }

    @Override
    public Color getPlotColor(String rawFilename) {
        return this.colorByRawFilename.get(rawFilename);
    }
}

