/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui;

import fr.proline.mzscope.model.Signal;
import fr.proline.mzscope.processing.DotProductScorer;
import fr.proline.mzscope.processing.SpectrumUtils;
import fr.proline.mzscope.ui.SignalWrapper;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.PlotLinear;
import fr.proline.studio.graphics.PlotPanel;
import fr.proline.studio.graphics.PlotXYAbstract;
import fr.proline.studio.graphics.marker.AbstractMarker;
import fr.proline.studio.graphics.marker.LabelMarker;
import fr.proline.studio.graphics.marker.coordinates.AbstractCoordinates;
import fr.proline.studio.graphics.marker.coordinates.PixelCoordinates;
import fr.proline.studio.utils.CyclicColorPalette;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalMultipleEditorPanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(SignalMultipleEditorPanel.class);
    private final PlotPanel m_plotPanel;
    private final List<PlotLinear> m_plots;
    private final List<Signal> m_signals;

    public SignalMultipleEditorPanel(List<Signal> signals) {
        this.m_signals = signals;
        this.m_plotPanel = new PlotPanel(false);
        this.m_plots = new ArrayList<PlotLinear>();
        BasePlotPanel basePlot = this.m_plotPanel.getBasePlotPanel();
        basePlot.setPlotTitle("2d signal");
        basePlot.setDrawCursor(true);
        for (Signal s : this.m_signals) {
            SignalWrapper wrappedSignal = new SignalWrapper(s, "original signal", CyclicColorPalette.getColor((int)1));
            PlotLinear linear = new PlotLinear(basePlot, (ExtendedTableModelInterface)wrappedSignal, null, 0, 1);
            linear.setPlotInformation(wrappedSignal.getPlotInformation());
            linear.setStrokeFixed(true);
            linear.setAntiAliasing(true);
            basePlot.addPlot((PlotXYAbstract)linear, true);
            this.m_plots.add(linear);
        }
        this.setLayout(new BorderLayout());
        JToolBar toolbar = new JToolBar();
        JButton button = new JButton("Normalize");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        toolbar.add(button);
        button = new JButton("Correlation");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double value = SpectrumUtils.correlation(((Signal)SignalMultipleEditorPanel.this.m_signals.get(0)).getXSeries(), ((Signal)SignalMultipleEditorPanel.this.m_signals.get(0)).getYSeries(), ((Signal)SignalMultipleEditorPanel.this.m_signals.get(1)).getXSeries(), ((Signal)SignalMultipleEditorPanel.this.m_signals.get(1)).getYSeries());
                ((PlotLinear)SignalMultipleEditorPanel.this.m_plots.get(0)).addMarker((AbstractMarker)new LabelMarker(SignalMultipleEditorPanel.this.m_plotPanel.getBasePlotPanel(), (AbstractCoordinates)new PixelCoordinates(10, 10), "Pearson Corr = " + value));
                Pair<double[], double[]> values = SpectrumUtils.zipValues(((Signal)SignalMultipleEditorPanel.this.m_signals.get(0)).getXSeries(), ((Signal)SignalMultipleEditorPanel.this.m_signals.get(0)).getYSeries(), ((Signal)SignalMultipleEditorPanel.this.m_signals.get(1)).getXSeries(), ((Signal)SignalMultipleEditorPanel.this.m_signals.get(1)).getYSeries());
                double cosineCorr = DotProductScorer.dotProduct((double[])values.getLeft(), (double[])values.getRight());
                ((PlotLinear)SignalMultipleEditorPanel.this.m_plots.get(0)).addMarker((AbstractMarker)new LabelMarker(SignalMultipleEditorPanel.this.m_plotPanel.getBasePlotPanel(), (AbstractCoordinates)new PixelCoordinates(10, 60), "Cosine Corr = " + cosineCorr));
                SignalMultipleEditorPanel.this.m_plotPanel.getBasePlotPanel().repaintUpdateDoubleBuffer();
            }
        });
        toolbar.add(button);
        this.add((Component)this.m_plotPanel, "Center");
        this.add((Component)toolbar, "North");
        this.setPreferredSize(new Dimension(300, 500));
    }
}

