/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui;

import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.algo.signal.filtering.PartialSavitzkyGolaySmoother;
import fr.profi.mzdb.algo.signal.filtering.SavitzkyGolaySmoother;
import fr.profi.mzdb.algo.signal.filtering.SavitzkyGolaySmoothingConfig;
import fr.profi.mzdb.util.math.DerivativeAnalysis;
import fr.proline.mzscope.model.MsnExtractionRequest;
import fr.proline.mzscope.model.Signal;
import fr.proline.mzscope.model.Spectrum;
import fr.proline.mzscope.processing.IsotopicPatternUtils;
import fr.proline.mzscope.processing.SpectrumUtils;
import fr.proline.mzscope.ui.IRawFileViewer;
import fr.proline.mzscope.ui.ScanHeaderPanel;
import fr.proline.mzscope.ui.SignalViewerBuilder;
import fr.proline.mzscope.ui.dialog.SmoothingParamDialog;
import fr.proline.mzscope.ui.event.ScanHeaderListener;
import fr.proline.mzscope.ui.model.MzScopePreferences;
import fr.proline.mzscope.ui.model.ScanTableModel;
import fr.proline.mzscope.utils.Display;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.PlotBaseAbstract;
import fr.proline.studio.graphics.PlotLinear;
import fr.proline.studio.graphics.PlotPanel;
import fr.proline.studio.graphics.PlotPanelListener;
import fr.proline.studio.graphics.PlotStick;
import fr.proline.studio.graphics.PlotXYAbstract;
import fr.proline.studio.graphics.marker.AbstractMarker;
import fr.proline.studio.graphics.marker.IntervalMarker;
import fr.proline.studio.graphics.marker.LabelMarker;
import fr.proline.studio.graphics.marker.LineMarker;
import fr.proline.studio.graphics.marker.PointMarker;
import fr.proline.studio.graphics.marker.coordinates.AbstractCoordinates;
import fr.proline.studio.graphics.marker.coordinates.DataCoordinates;
import fr.proline.studio.graphics.measurement.AbstractMeasurement;
import fr.proline.studio.graphics.measurement.IntegralMeasurement;
import fr.proline.studio.graphics.measurement.WidthMeasurement;
import fr.proline.studio.utils.CyclicColorPalette;
import fr.proline.studio.utils.IconManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractSpinnerModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.openide.windows.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SpectrumPanel
extends JPanel
implements ScanHeaderListener,
PlotPanelListener {
    private static final Logger logger = LoggerFactory.getLogger(SpectrumPanel.class);
    private static final int OVERLAY_KEY = 2;
    private final IRawFileViewer rawFilePanel;
    private ScanHeaderPanel headerSpectrumPanel;
    protected BasePlotPanel spectrumPlotPanel;
    protected JToolBar spectrumToolbar;
    protected PlotXYAbstract scanPlot;
    protected LineMarker positionMarker;
    protected Spectrum currentScan;
    protected Spectrum referenceSpectrum;
    private boolean keepSameMsLevel = true;
    private boolean autoZoom = false;
    private List<AbstractMarker> ipMarkers = new ArrayList<AbstractMarker>();
    private ScansSpinnerModel spinnerModel;
    private JButton m_editSignalBtn;
    private JButton m_showCentroidBtn;
    private JToggleButton m_freezeSpectrumBtn;

    public SpectrumPanel(IRawFileViewer rawFilePanel) {
        this.rawFilePanel = rawFilePanel;
    }

    public void initComponents() {
        PlotPanel plotPanel = new PlotPanel(false);
        this.spectrumPlotPanel = plotPanel.getBasePlotPanel();
        this.spectrumPlotPanel.addListener((PlotPanelListener)this);
        this.spectrumPlotPanel.setDrawCursor(true);
        this.positionMarker = new LineMarker(this.spectrumPlotPanel, 0.0, 1, Color.BLUE, false);
        this.spectrumPlotPanel.repaint();
        this.removeAll();
        this.add((Component)plotPanel, "Center");
        this.add((Component)this.getSpectrumToolbar(), "North");
    }

    private JToolBar getSpectrumToolbar() {
        this.spectrumToolbar = new JToolBar(0);
        this.spectrumToolbar.setFloatable(false);
        ExportButton exportImageButton = new ExportButton("Graphic", (JPanel)this.spectrumPlotPanel);
        this.spectrumToolbar.add((Component)exportImageButton);
        JButton displayIPBtn = new JButton();
        displayIPBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ISOTOPES_PREDICTION));
        displayIPBtn.setToolTipText("Display Isotopic Patterns");
        displayIPBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpectrumPanel.this.displayIsotopicPatterns();
            }
        });
        this.spectrumToolbar.add(displayIPBtn);
        this.m_freezeSpectrumBtn = new JToggleButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.PIN));
        this.m_freezeSpectrumBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JToggleButton tBtn = (JToggleButton)e.getSource();
                if (tBtn.isSelected()) {
                    SpectrumPanel.this._displayReferenceSpectrum(SpectrumPanel.this.currentScan);
                } else {
                    SpectrumPanel.this.clearReferenceSpectrumData();
                }
            }
        });
        this.spectrumToolbar.add(this.m_freezeSpectrumBtn);
        JToggleButton autoZoomBtn = new JToggleButton();
        autoZoomBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.AUTO_ZOOM));
        autoZoomBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpectrumPanel.this.autoZoom = ((JToggleButton)e.getSource()).isSelected();
            }
        });
        this.spectrumToolbar.add(autoZoomBtn);
        this.spectrumToolbar.addSeparator();
        this.m_showCentroidBtn = new JButton();
        this.m_showCentroidBtn.setEnabled(false);
        this.m_showCentroidBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.CENTROID_SPECTRA));
        this.m_showCentroidBtn.setToolTipText("Compute and show centroid peaks");
        this.m_showCentroidBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpectrumPanel.this.showCentroid();
            }
        });
        this.spectrumToolbar.add(this.m_showCentroidBtn);
        this.m_editSignalBtn = new JButton();
        this.m_editSignalBtn.setEnabled(false);
        this.m_editSignalBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.SIGNAL));
        this.m_editSignalBtn.setToolTipText("Spectrum signal processing dialog");
        this.m_editSignalBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpectrumPanel.this.editSignal();
            }
        });
        this.spectrumToolbar.add(this.m_editSignalBtn);
        this.spectrumToolbar.addSeparator();
        this.spinnerModel = new ScansSpinnerModel();
        this.headerSpectrumPanel = new ScanHeaderPanel(null, this.spinnerModel);
        this.headerSpectrumPanel.addScanHeaderListener(this);
        this.spectrumToolbar.add(this.headerSpectrumPanel);
        return this.spectrumToolbar;
    }

    protected void updateToolbar() {
        this.m_editSignalBtn.setEnabled(true);
        this.m_showCentroidBtn.setEnabled(true);
    }

    private void showCentroid() {
        Signal signal = this.getSignal();
        this.scanPlot.clearMarkers();
        SmoothingParamDialog dialog = new SmoothingParamDialog(WindowManager.getDefault().getMainWindow());
        dialog.pack();
        dialog.setVisible(true);
        if (dialog.getButtonClicked() == 0) {
            SavitzkyGolaySmoother smoother;
            String smoothMethod;
            long start = System.currentTimeMillis();
            int nbrPoints = dialog.getNbrPoint();
            switch (smoothMethod = dialog.getMethod()) {
                case "Savitzky-Golay Smoother": {
                    smoother = new SavitzkyGolaySmoother(new SavitzkyGolaySmoothingConfig(nbrPoints, 2, 1));
                    break;
                }
                case "Partial Savitzky-Golay Smoother": {
                    smoother = new PartialSavitzkyGolaySmoother(new SavitzkyGolaySmoothingConfig(nbrPoints, 4, 1));
                    break;
                }
                case "All Smoothers": {
                    JOptionPane.showMessageDialog(this, "Can't use all smoothing methods, Savitzky-Golay will be used.", "Smoothing Error", 2);
                    smoother = new SavitzkyGolaySmoother(new SavitzkyGolaySmoothingConfig(nbrPoints, 2, 1));
                    break;
                }
                default: {
                    smoother = new SavitzkyGolaySmoother(new SavitzkyGolaySmoothingConfig(nbrPoints, 2, 1));
                }
            }
            List<Tuple2> input = signal.toScalaArrayTuple(false);
            Tuple2[] param = input.toArray(new Tuple2[input.size()]);
            long step1a = System.currentTimeMillis();
            Tuple2[] result = smoother.smoothTimeIntensityPairs(param);
            long step1 = System.currentTimeMillis();
            int resultLenght = result.length;
            logger.debug("Smooting: signal length after smoothing = " + resultLenght + " vs before " + input.size() + ". TIME: " + (step1 - start) + " which " + (step1a - start) + " for arrays");
            double[] x = new double[resultLenght];
            double[] y = new double[resultLenght];
            for (int k = 0; k < resultLenght; ++k) {
                x[k] = (Double)result[k]._1;
                y[k] = (Double)result[k]._2;
            }
            Signal newSignal = new Signal(x, y);
            long step2 = System.currentTimeMillis();
            logger.debug("Created new Signal. TIME: " + (step2 - step1));
            DerivativeAnalysis.ILocalDerivativeChange[] mm = DerivativeAnalysis.findMiniMaxi((double[])newSignal.getYSeries());
            long step3 = System.currentTimeMillis();
            logger.debug("DerivativeAnalysis Done, number min/max points = " + mm.length + ". TIME: " + (step3 - step2));
            int realLenght = 0;
            double[] newSpMasses = new double[mm.length];
            float[] newSpIntensities = new float[mm.length];
            double[] centroidSignalX = new double[mm.length];
            double[] centroidSignalY = new double[mm.length];
            for (int k = 0; k < mm.length; ++k) {
                if (!mm[k].isMaximum()) continue;
                double massIdx = newSignal.getXSeries()[mm[k].index()];
                double intensityIdx = signal.getYSeries()[mm[k].index()];
                centroidSignalY[realLenght] = centroidSignalX[realLenght] = massIdx;
                centroidSignalY[realLenght] = intensityIdx;
                newSpMasses[realLenght] = massIdx;
                newSpIntensities[realLenght] = (float)intensityIdx;
                ++realLenght;
            }
            Spectrum newSpectrum = new Spectrum(-1, this.currentScan.getRetentionTime(), Arrays.copyOfRange(newSpMasses, 0, realLenght), Arrays.copyOfRange(newSpIntensities, 0, realLenght), this.currentScan.getMsLevel(), Spectrum.ScanType.CENTROID);
            long step4 = System.currentTimeMillis();
            logger.debug("Create CentroidSignal values + display markers.Nbr real points = " + realLenght + ". TIME: " + (step4 - step3) + "TOTAL == " + (step4 - start));
            this.referenceSpectrum = newSpectrum;
            this._displayReferenceSpectrum(newSpectrum);
            this.m_freezeSpectrumBtn.setSelected(true);
        }
    }

    private void editSignal() {
        Signal signal = this.getSignal();
        ArrayList<Signal> signals = new ArrayList<Signal>();
        signals.add(signal);
        JDialog dialog = new JDialog((JFrame)this.getTopLevelAncestor(), "Spectra editor", true);
        dialog.setContentPane(SignalViewerBuilder.buildEditor(signals));
        dialog.pack();
        dialog.setVisible(true);
    }

    private Signal getSignal() {
        double min = this.spectrumPlotPanel.getXAxis().getMinValue();
        double max = this.spectrumPlotPanel.getXAxis().getMaxValue();
        int minIdx = SpectrumUtils.getNearestPeakIndex(this.currentScan.getMasses(), min);
        int maxIdx = Math.min(SpectrumUtils.getNearestPeakIndex(this.currentScan.getMasses(), max) + 1, this.currentScan.getMasses().length);
        Signal currentSignal = new Signal(Arrays.copyOfRange(this.currentScan.getMasses(), minIdx, maxIdx), Arrays.copyOfRange(this.currentScan.getIntensities(), minIdx, maxIdx));
        if (this.currentScan.getDataType().equals((Object)Spectrum.ScanType.CENTROID)) {
            currentSignal.setSignalType(1);
        }
        return currentSignal;
    }

    private void displayIsotopicPatterns() {
        this.ipMarkers.stream().forEach(m -> this.scanPlot.removeMarker(m));
        this.ipMarkers = new ArrayList<AbstractMarker>();
        float ppmTol = MzScopePreferences.getInstance().getMzPPMTolerance();
        TheoreticalIsotopePattern pattern = IsotopicPatternUtils.predictIsotopicPattern(this.currentScan.getSpectrumData(), this.positionMarker.getValue(), ppmTol);
        int referenceMzIdx = 0;
        int idx = SpectrumUtils.getNearestPeakIndex(this.currentScan.getSpectrumData().getMzList(), this.positionMarker.getValue());
        for (Tuple2 t : pattern.mzAbundancePairs()) {
            if (1000000.0 * (Math.abs(this.currentScan.getSpectrumData().getMzList()[idx] - (Double)t._1) / this.currentScan.getSpectrumData().getMzList()[idx]) < (double)ppmTol) break;
            ++referenceMzIdx;
        }
        if (referenceMzIdx < pattern.isotopeCount()) {
            float abundance = this.currentScan.getSpectrumData().getIntensityList()[idx];
            float normAbundance = ((Float)pattern.mzAbundancePairs()[referenceMzIdx]._2).floatValue();
            for (Tuple2 t : pattern.mzAbundancePairs()) {
                Double mz = (Double)t._1;
                Float ab = (Float)t._2;
                PointMarker m2 = new PointMarker(this.spectrumPlotPanel, (AbstractCoordinates)new DataCoordinates(mz.doubleValue(), (double)(ab.floatValue() * abundance / normAbundance)), CyclicColorPalette.getColor((int)0));
                this.ipMarkers.add((AbstractMarker)m2);
                this.scanPlot.addMarker((AbstractMarker)m2);
                int peakIdx = SpectrumUtils.getPeakIndex(this.currentScan.getSpectrumData().getMzList(), mz, ppmTol);
                if (peakIdx == -1 || !((double)this.currentScan.getSpectrumData().getIntensityList()[peakIdx] < 2.0 * (double)ab.floatValue() * (double)abundance / (double)normAbundance)) continue;
                logger.info("Peak found mz= " + mz + " expected= " + ab.floatValue() * abundance / normAbundance + " observed= " + this.currentScan.getSpectrumData().getIntensityList()[peakIdx]);
                PointMarker pm = new PointMarker(this.spectrumPlotPanel, (AbstractCoordinates)new DataCoordinates(this.currentScan.getSpectrumData().getMzList()[peakIdx], (double)this.currentScan.getSpectrumData().getIntensityList()[peakIdx]), CyclicColorPalette.getColor((int)5));
                this.ipMarkers.add((AbstractMarker)pm);
                this.scanPlot.addMarker((AbstractMarker)pm);
            }
            Double mz = 0.1 + ((Double)pattern.mzAbundancePairs()[0]._1 + (Double)pattern.mzAbundancePairs()[1]._1) / 2.0;
            Float ab = Float.valueOf(((Float)pattern.mzAbundancePairs()[0]._2).floatValue() * 0.75f);
            LabelMarker label = new LabelMarker(this.spectrumPlotPanel, (AbstractCoordinates)new DataCoordinates(mz.doubleValue(), (double)(ab.floatValue() * abundance / normAbundance)), "charge " + pattern.charge() + "+", 2, 2, CyclicColorPalette.getColor((int)0));
            this.ipMarkers.add((AbstractMarker)label);
            this.scanPlot.addMarker((AbstractMarker)label);
        }
        this.spectrumPlotPanel.repaintUpdateDoubleBuffer();
    }

    public void plotPanelMouseClicked(MouseEvent e, double xValue, double yValue) {
        if (e.getClickCount() == 2) {
            if ((e.getModifiers() & 2) == 0 && this.rawFilePanel.getChromatogramDisplayMode() != Display.Mode.OVERLAY) {
                this.scanPlot.clearMarkers();
                this.scanPlot.addMarker((AbstractMarker)this.positionMarker);
            }
            this.positionMarker.setValue(xValue);
            this.positionMarker.setVisible(true);
            double mz = xValue;
            float ppmTol = this.currentScan.getMsLevel() == 1 ? MzScopePreferences.getInstance().getMzPPMTolerance() : MzScopePreferences.getInstance().getFragmentMzPPMTolerance();
            double maxMz = mz + mz * (double)ppmTol / 1000000.0;
            double minMz = mz - mz * (double)ppmTol / 1000000.0;
            this.scanPlot.addMarker((AbstractMarker)new IntervalMarker(this.spectrumPlotPanel, Color.orange, Color.RED, minMz, maxMz));
            MsnExtractionRequest.Builder<?> builder = MsnExtractionRequest.builder();
            if (this.currentScan.getMsLevel() == 1) {
                ((MsnExtractionRequest.Builder)builder.setMinMz(minMz)).setMaxMz(maxMz);
            } else {
                ((MsnExtractionRequest.Builder)((MsnExtractionRequest.Builder)builder.setMz(this.currentScan.getPrecursorMz())).setFragmentMz(mz)).setFragmentMzTolPPM(ppmTol);
            }
            if ((e.getModifiers() & 2) != 0) {
                this.rawFilePanel.extractAndDisplayChromatogram(builder.build(), new Display(Display.Mode.OVERLAY), null);
            } else {
                this.rawFilePanel.extractAndDisplayChromatogram(builder.build(), new Display(this.rawFilePanel.getChromatogramDisplayMode()), null);
            }
        } else if (SwingUtilities.isLeftMouseButton(e)) {
            this.positionMarker.setValue(xValue);
            this.positionMarker.setVisible(true);
        }
    }

    @Override
    public void updateScanIndex(Integer scanIndex) {
        this.rawFilePanel.displayScan(scanIndex.intValue());
    }

    @Override
    public void updateRetentionTime(float retentionTime) {
        int scanIdx = this.rawFilePanel.getCurrentRawfile().getSpectrumId(retentionTime);
        this.rawFilePanel.displayScan(scanIdx);
    }

    @Override
    public void keepMsLevel(boolean keep) {
        this.keepSameMsLevel = keep;
    }

    public void addMarkerRange(double minMz, double maxMz) {
        this.scanPlot.addMarker((AbstractMarker)new IntervalMarker(this.spectrumPlotPanel, Color.orange, Color.RED, minMz, maxMz));
    }

    public void displayScan(Spectrum scan) {
        double xMin = 0.0;
        double xMax = 0.0;
        double yMin = 0.0;
        double yMax = 0.0;
        if (this.currentScan != null && this.currentScan.getMasses().length > 0) {
            xMin = this.spectrumPlotPanel.getXAxis().getMinValue();
            xMax = this.spectrumPlotPanel.getXAxis().getMaxValue();
            yMin = this.spectrumPlotPanel.getYAxis().getMinValue();
            yMax = this.spectrumPlotPanel.getYAxis().getMaxValue();
        }
        if (scan != null && scan.getMasses().length > 0) {
            Color plotColor = this.rawFilePanel.getPlotColor(this.rawFilePanel.getCurrentRawfile().getName());
            ScanTableModel scanModel = new ScanTableModel(scan);
            scanModel.setColor(plotColor);
            this.scanPlot = this.buildPlot(scan, plotColor);
            this.spectrumPlotPanel.setPlot((PlotBaseAbstract)this.scanPlot);
            this.spectrumPlotPanel.lockMinXValue();
            this.spectrumPlotPanel.lockMinYValue();
            if (this.currentScan != null && this.currentScan.getMasses().length > 0 && this.currentScan.getMsLevel() == scan.getMsLevel()) {
                if (!this.autoZoom) {
                    this.spectrumPlotPanel.getXAxis().setRange(xMin, xMax);
                    this.spectrumPlotPanel.getYAxis().setRange(yMin, yMax);
                } else {
                    this.spectrumPlotPanel.getXAxis().setRange(xMin, xMax);
                }
            }
            if (this.currentScan != null && this.currentScan.getMsLevel() != scan.getMsLevel()) {
                this.positionMarker.setVisible(false);
            }
            this.scanPlot.addMarker((AbstractMarker)this.positionMarker);
            this._displayReferenceSpectrum(this.referenceSpectrum);
            this.spectrumPlotPanel.repaint();
            this.headerSpectrumPanel.setMzdbFileName(this.rawFilePanel.getCurrentRawfile().getName());
            this.currentScan = scan;
            this.spinnerModel.setValue(this.currentScan.getIndex());
            this.headerSpectrumPanel.setScan(this.currentScan);
        } else if (scan != null) {
            logger.info("display scan id = {},contains no data ", (Object)scan.getIndex());
            this.currentScan = scan;
            this.spinnerModel.setValue(this.currentScan.getIndex());
            this.headerSpectrumPanel.setScan(this.currentScan);
            this.spectrumPlotPanel.clearPlotsWithRepaint();
        } else {
            this.spectrumPlotPanel.clearPlotsWithRepaint();
        }
    }

    private void _displayReferenceSpectrum(Spectrum spectrum) {
        if (spectrum != null) {
            double xMin = 0.0;
            double xMax = 0.0;
            double yMin = 0.0;
            double yMax = 0.0;
            if (this.currentScan != null) {
                xMin = this.spectrumPlotPanel.getXAxis().getMinValue();
                xMax = this.spectrumPlotPanel.getXAxis().getMaxValue();
                yMin = this.spectrumPlotPanel.getYAxis().getMinValue();
                yMax = this.spectrumPlotPanel.getYAxis().getMaxValue();
            }
            PlotXYAbstract plot = this.buildPlot(spectrum, CyclicColorPalette.getColor((int)5));
            this.spectrumPlotPanel.addPlot(plot, true);
            if (this.currentScan != null) {
                this.spectrumPlotPanel.getXAxis().setRange(xMin, xMax);
                this.spectrumPlotPanel.getYAxis().setRange(yMin, yMax);
            }
            this.referenceSpectrum = spectrum;
            this.spectrumPlotPanel.repaint();
        }
    }

    private PlotXYAbstract buildPlot(Spectrum scan, Color plotColor) {
        ScanTableModel scanModel = new ScanTableModel(scan);
        PlotStick plot = null;
        scanModel.setColor(plotColor);
        if (scan.getDataType() == Spectrum.ScanType.CENTROID) {
            plot = new PlotStick(this.spectrumPlotPanel, (ExtendedTableModelInterface)scanModel, null, 0, 1);
            plot.setStrokeFixed(true);
            plot.setPlotInformation(scanModel.getPlotInformation());
        } else {
            plot = new PlotLinear(this.spectrumPlotPanel, (ExtendedTableModelInterface)scanModel, null, 0, 1);
            plot.addMeasurement((AbstractMeasurement)new IntegralMeasurement((PlotBaseAbstract)plot));
            plot.addMeasurement((AbstractMeasurement)new WidthMeasurement((PlotBaseAbstract)plot));
            ((PlotLinear)plot).setStrokeFixed(true);
            ((PlotLinear)plot).setPlotInformation(scanModel.getPlotInformation());
        }
        plot.setIsPaintMarker(true);
        return plot;
    }

    public void clearReferenceSpectrumData() {
        if (this.referenceSpectrum != null) {
            this.referenceSpectrum = null;
            this.displayScan(this.currentScan);
        }
    }

    public void displayReferenceSpectrum(Spectrum spectrum) {
        this.referenceSpectrum = spectrum;
        this.displayScan(this.currentScan);
    }

    public int getNextScanIndex(Integer spectrumIndex) {
        if (this.keepSameMsLevel) {
            return this.rawFilePanel.getCurrentRawfile().getNextSpectrumId(spectrumIndex, this.currentScan.getMsLevel());
        }
        return Math.min(this.currentScan.getIndex() + 1, this.rawFilePanel.getCurrentRawfile().getSpectrumCount() - 1);
    }

    public int getPreviousScanIndex(Integer spectrumIndex) {
        if (this.keepSameMsLevel) {
            return this.rawFilePanel.getCurrentRawfile().getPreviousSpectrumId(spectrumIndex, this.currentScan.getMsLevel());
        }
        return Math.max(1, this.currentScan.getIndex() - 1);
    }

    public void updateAxisRange(double[] oldX, double[] newX, double[] oldY, double[] newY) {
    }

    class ScansSpinnerModel
    extends AbstractSpinnerModel {
        ScansSpinnerModel() {
        }

        @Override
        public Object getValue() {
            return SpectrumPanel.this.currentScan == null ? 0 : SpectrumPanel.this.currentScan.getIndex();
        }

        @Override
        public void setValue(Object value) {
            if (((Integer)value).intValue() != ((Integer)this.getValue()).intValue()) {
                SpectrumPanel.this.rawFilePanel.displayScan(((Integer)value).intValue());
            }
            this.fireStateChanged();
        }

        @Override
        public Object getNextValue() {
            return SpectrumPanel.this.currentScan == null ? 0 : SpectrumPanel.this.getNextScanIndex(SpectrumPanel.this.currentScan.getIndex());
        }

        @Override
        public Object getPreviousValue() {
            return SpectrumPanel.this.currentScan == null ? 0 : SpectrumPanel.this.getPreviousScanIndex(SpectrumPanel.this.currentScan.getIndex());
        }
    }
}

