/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui.model;

import fr.proline.studio.table.DataGroup;
import java.awt.Color;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MapDataGroup
extends DataGroup {
    private static DecimalFormat DECIMAL_FORMAT = new DecimalFormat("###,###,###.0");
    private static DecimalFormat SCIENTIFIC_FORMAT = new DecimalFormat("0.00E0");
    private static DecimalFormat PRECISION_FORMAT = new DecimalFormat("###,###,##0.0000");
    private static DateFormat MEDIUM_DATEFORMAT = DateFormat.getDateTimeInstance(2, 2);
    private List<List<DataGroup.GroupObject>> values;
    private List<DataGroup.GroupObject> rows;
    private Color color;

    public MapDataGroup(List<Map<String, Object>> maps, Color color, String name, int rowStart) {
        super(name, rowStart);
        this.rows = this.extractKeys(maps);
        this.values = new ArrayList<List<DataGroup.GroupObject>>();
        for (DataGroup.GroupObject row : this.rows) {
            ArrayList<DataGroup.GroupObject> rowValues = new ArrayList<DataGroup.GroupObject>();
            for (Map<String, Object> map : maps) {
                Object value = map.get(row.stringForRendering());
                rowValues.add(new DataGroup.GroupObject((DataGroup)this, MapDataGroup.convertToString(value), (DataGroup)this));
            }
            this.values.add(rowValues);
        }
        this.color = color;
    }

    private List<DataGroup.GroupObject> extractKeys(List<Map<String, Object>> maps) {
        ArrayList<DataGroup.GroupObject> keys = new ArrayList<DataGroup.GroupObject>();
        HashSet<String> dictionnary = new HashSet<String>();
        for (Map<String, Object> map : maps) {
            for (Map.Entry<String, Object> e : map.entrySet()) {
                if (dictionnary.contains(e.getKey())) continue;
                keys.add(new DataGroup.GroupObject((DataGroup)this, e.getKey(), (DataGroup)this));
                dictionnary.add(e.getKey());
            }
        }
        return keys;
    }

    public DataGroup.GroupObject getGroupValueAt(int rowIndex, int columnIndex) {
        return this.values.get(rowIndex).get(columnIndex);
    }

    public DataGroup.GroupObject getGroupNameAt(int rowIndex) {
        return this.rows.get(rowIndex);
    }

    public Color getGroupColor(int row) {
        return this.color;
    }

    public int getRowCountImpl() {
        return this.rows.size();
    }

    private static String convertToString(Object value) {
        if (value == null) {
            return "";
        }
        if (String.class.isAssignableFrom(value.getClass())) {
            return (String)value;
        }
        if (Integer.class.isAssignableFrom(value.getClass())) {
            return String.valueOf((Integer)value);
        }
        if (Number.class.isAssignableFrom(value.getClass())) {
            double v = ((Number)value).doubleValue();
            DecimalFormat format = DECIMAL_FORMAT;
            if (v <= 1.0) {
                format = PRECISION_FORMAT;
            } else if (v > 1.0E7) {
                format = SCIENTIFIC_FORMAT;
            }
            return format.format(v);
        }
        if (Date.class.isAssignableFrom(value.getClass())) {
            return MEDIUM_DATEFORMAT.format((Date)value);
        }
        return value.toString();
    }
}

