/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui.model;

import fr.proline.mzscope.model.Spectrum;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.graphics.PlotDataSpec;
import fr.proline.studio.graphics.PlotInformation;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

public class ScanTableModel
extends AbstractTableModel
implements ExtendedTableModelInterface {
    private static final String[] m_columnNames = new String[]{"Masses", "Intensities", "Retention Time", "MS Level"};
    public static final int COLTYPE_SCAN_MASS = 0;
    public static final int COLTYPE_SCAN_INTENSITIES = 1;
    public static final int COLTYPE_SCAN_RETENTION_TIME = 2;
    public static final int COLTYPE_SCAN_MSLEVEL = 3;
    private Spectrum scan;
    private String m_modelName;
    private Color scanColor;

    public ScanTableModel(Spectrum scan) {
        this.scan = scan;
    }

    @Override
    public int getRowCount() {
        return this.scan.getMasses().length;
    }

    @Override
    public int getColumnCount() {
        return m_columnNames.length;
    }

    @Override
    public String getColumnName(int col) {
        return m_columnNames[col];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.scan.getMasses()[rowIndex];
            }
            case 1: {
                return Float.valueOf(this.scan.getIntensities()[rowIndex]);
            }
            case 2: {
                return Float.valueOf(this.scan.getRetentionTime() / 60.0f);
            }
            case 3: {
                return this.scan.getMsLevel();
            }
        }
        return null;
    }

    public String getDataColumnIdentifier(int columnIndex) {
        return this.getColumnName(columnIndex);
    }

    public Class getDataColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Double.class;
            }
            case 1: {
                return Float.class;
            }
            case 2: {
                return Float.class;
            }
            case 3: {
                return Integer.class;
            }
        }
        return null;
    }

    public Object getDataValueAt(int rowIndex, int columnIndex) {
        return this.getValueAt(rowIndex, columnIndex);
    }

    public int[] getKeysColumn() {
        int[] keys = new int[]{0};
        return keys;
    }

    public int getInfoColumn() {
        return 2;
    }

    public void setName(String name) {
        this.m_modelName = name;
    }

    public String getName() {
        return this.m_modelName;
    }

    public Map<String, Object> getExternalData() {
        return null;
    }

    public PlotInformation getPlotInformation() {
        PlotInformation plotInformation = new PlotInformation();
        plotInformation.setPlotColor(this.scanColor);
        return plotInformation;
    }

    public void setColor(Color c) {
        this.scanColor = c;
    }

    public long row2UniqueId(int rowIndex) {
        return rowIndex;
    }

    public int uniqueId2Row(long id) {
        return (int)id;
    }

    public ArrayList<ExtraDataType> getExtraDataTypes() {
        return null;
    }

    public Object getValue(Class c) {
        return null;
    }

    public Object getRowValue(Class c, int row) {
        return null;
    }

    public Object getColValue(Class c, int col) {
        return null;
    }

    public void addSingleValue(Object v) {
    }

    public Object getSingleValue(Class c) {
        return null;
    }

    public PlotDataSpec getDataSpecAt(int i) {
        return null;
    }
}

