/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui.peakels;

import fr.profi.mzdb.model.Peakel;
import fr.proline.mzscope.model.IPeakel;
import fr.proline.mzscope.ui.IMzScopeController;
import fr.proline.mzscope.ui.peakels.PeakelWrapper;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.filter.actions.ClearRestrainAction;
import fr.proline.studio.filter.actions.RestrainAction;
import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.PlotLinear;
import fr.proline.studio.graphics.PlotXYAbstract;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerContainerPanel;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.table.AbstractTableAction;
import fr.proline.studio.table.DecoratedMarkerTable;
import fr.proline.studio.table.TablePopupMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPeakelsPanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPeakelsPanel.class);
    protected int m_modelSelectedRowBeforeSort = -1;
    protected DecoratedMarkerTable m_table;
    protected CompoundTableModel m_compoundTableModel;
    protected IMzScopeController m_viewersController;
    protected BasePlotPanel m_graphPlot;
    protected MarkerContainerPanel m_markerContainerPanel;

    public AbstractPeakelsPanel(IMzScopeController controller) {
        this.m_viewersController = controller;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        this.m_table = new FeatureTable();
        this.m_compoundTableModel = this.buildTableModel();
        this.m_table.setModel((TableModel)this.m_compoundTableModel);
        this.m_table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AbstractPeakelsPanel.this.tableMouseClicked(evt);
            }
        });
        jScrollPane.setViewportView((Component)this.m_table);
        this.m_table.setFillsViewportHeight(true);
        this.m_table.setViewport(jScrollPane.getViewport());
        this.m_table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AbstractPeakelsPanel.this.updatePeakelsViewer(AbstractPeakelsPanel.this.getSelectedPeakels());
            }
        });
        JToolBar toolbar = this.initToolbar();
        this.m_markerContainerPanel = new MarkerContainerPanel(jScrollPane, (MarkerComponentInterface)this.m_table);
        tablePanel.add((Component)toolbar, "West");
        tablePanel.add((Component)this.m_markerContainerPanel, "Center");
        JSplitPane splitPane = new JSplitPane();
        splitPane.setLeftComponent(tablePanel);
        this.m_graphPlot = new BasePlotPanel();
        splitPane.setRightComponent((Component)this.m_graphPlot);
        this.add((Component)splitPane, "Center");
    }

    protected abstract CompoundTableModel buildTableModel();

    protected JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        FilterButton filterButton = new FilterButton((FilterTableModelInterface)((CompoundTableModel)this.m_table.getModel())){

            protected void filteringDone() {
            }
        };
        ExportButton exportButton = new ExportButton((ProgressInterface)((CompoundTableModel)this.m_table.getModel()), "Features-Peakels", (JXTable)this.m_table);
        toolbar.add((Component)filterButton);
        toolbar.add((Component)exportButton);
        return toolbar;
    }

    protected void tableMouseClicked(MouseEvent evt) {
        List<IPeakel> peakels = this.getSelectedIPeakels();
        this.updatePeakelsViewer(this.getSelectedPeakels());
        if (evt.getClickCount() == 2 && peakels != null && peakels.size() > 0) {
            this.m_viewersController.getRawFileViewer(peakels.get(0).getRawFile(), true).displayPeakel(peakels.get(0));
        }
    }

    protected abstract List<IPeakel> getSelectedIPeakels();

    protected abstract List<Peakel> getSelectedPeakels();

    private void updatePeakelsViewer(List<Peakel> peakels) {
        if (peakels != null) {
            this.m_graphPlot.clearPlots();
            float maxY = 0.0f;
            int index = 0;
            for (Peakel p : peakels) {
                maxY = Math.max(p.getApexIntensity(), maxY);
                PeakelWrapper wrapper = new PeakelWrapper(p, index++);
                PlotLinear plot = new PlotLinear(this.m_graphPlot, (ExtendedTableModelInterface)wrapper, null, 0, 1);
                plot.setPlotInformation(wrapper.getPlotInformation());
                this.m_graphPlot.addPlot((PlotXYAbstract)plot);
            }
            this.m_graphPlot.getYAxis().lockMinValue(Double.valueOf(0.0));
            this.m_graphPlot.getYAxis().setRange(0.0, (double)maxY);
            this.m_graphPlot.repaint();
        }
    }

    protected int getModelRowId(int rowId) {
        CompoundTableModel compoundTableModel = (CompoundTableModel)this.m_table.getModel();
        if (compoundTableModel.getRowCount() != 0) {
            rowId = this.m_table.convertRowIndexToModel(rowId);
            rowId = compoundTableModel.convertCompoundRowToBaseModelRow(rowId);
        }
        return rowId;
    }

    private class FeatureTable
    extends DecoratedMarkerTable {
        private FeatureTable() {
        }

        public TablePopupMenu initPopupMenu() {
            TablePopupMenu popupMenu = new TablePopupMenu();
            popupMenu.addAction((AbstractTableAction)new DisplayRawFileAction());
            popupMenu.addAction((AbstractTableAction)new DisplayFeatureInCurrentRawFileAction());
            popupMenu.addAction(null);
            popupMenu.addAction((AbstractTableAction)new RestrainAction(){

                public void filteringDone() {
                }
            });
            popupMenu.addAction((AbstractTableAction)new ClearRestrainAction(){

                public void filteringDone() {
                }
            });
            return popupMenu;
        }

        public void prepostPopupMenu() {
        }

        public void addTableModelListener(TableModelListener l) {
            this.getModel().addTableModelListener(l);
        }
    }

    private class DisplayFeatureInCurrentRawFileAction
    extends AbstractTableAction {
        public DisplayFeatureInCurrentRawFileAction() {
            super("Display in the currently active raw file");
        }

        public void actionPerformed(int col, int row, int[] selectedRows, JTable table) {
            List<IPeakel> peakels = AbstractPeakelsPanel.this.getSelectedIPeakels();
            if (peakels != null && peakels.size() > 0) {
                AbstractPeakelsPanel.this.m_viewersController.getCurrentRawFileViewer().displayPeakel(peakels.get(0));
            }
        }

        public void updateEnabled(int row, int col, int[] selectedRows, JTable table) {
            this.setEnabled(selectedRows.length == 1);
        }
    }

    private class DisplayRawFileAction
    extends AbstractTableAction {
        public DisplayRawFileAction() {
            super("Display in the raw file");
        }

        public void actionPerformed(int col, int row, int[] selectedRows, JTable table) {
            List<IPeakel> peakels = AbstractPeakelsPanel.this.getSelectedIPeakels();
            if (peakels != null && peakels.size() > 0) {
                AbstractPeakelsPanel.this.m_viewersController.getRawFileViewer(peakels.get(0).getRawFile(), true).displayPeakel(peakels.get(0));
            }
        }

        public void updateEnabled(int row, int col, int[] selectedRows, JTable table) {
            this.setEnabled(selectedRows.length == 1);
        }
    }
}

