/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui.peakels;

import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.model.SpectrumData;
import fr.proline.mzscope.model.BaseFeature;
import fr.proline.mzscope.model.IFeature;
import fr.proline.mzscope.model.IPeakel;
import fr.proline.mzscope.model.Spectrum;
import fr.proline.mzscope.processing.PeakelsHelper;
import fr.proline.mzscope.ui.IMzScopeController;
import fr.proline.mzscope.ui.peakels.AbstractPeakelsPanel;
import fr.proline.mzscope.ui.peakels.FeaturesTableModel;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.extendedtablemodel.ImportedDataTableModel;
import fr.proline.studio.utils.IconManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeaturesPanel
extends AbstractPeakelsPanel {
    private static final Logger logger = LoggerFactory.getLogger(FeaturesPanel.class);
    private static final String LAST_DIR = "mzscope.last.csv.features.directory";
    private JFileChooser m_fchooser;
    private List<IFeature> m_features = new ArrayList<IFeature>();
    private PeakelsHelper m_helper = null;

    public FeaturesPanel(IMzScopeController controller) {
        super(controller);
        this.m_fchooser = new JFileChooser();
        this.m_fchooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(".csv");
            }

            @Override
            public String getDescription() {
                return "*.csv";
            }
        });
    }

    @Override
    protected CompoundTableModel buildTableModel() {
        FeaturesTableModel model = new FeaturesTableModel();
        return new CompoundTableModel((GlobalTableModelInterface)model, true);
    }

    @Override
    protected JToolBar initToolbar() {
        JToolBar toolbar = super.initToolbar();
        JButton matchIonsBtn = new JButton();
        matchIonsBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.TABLE_IMPORT));
        matchIonsBtn.setToolTipText("Match (m/z,rt) values from a csv file...");
        matchIonsBtn.addActionListener(e -> this.matchCSVIons());
        toolbar.add(matchIonsBtn);
        JButton buildSpectrumBtn = new JButton();
        buildSpectrumBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.SIGNAL));
        buildSpectrumBtn.setToolTipText("Build Spectrum from peakels");
        buildSpectrumBtn.addActionListener(e -> this.buildSpectrum());
        toolbar.add(buildSpectrumBtn);
        return toolbar;
    }

    private void buildSpectrum() {
        List<IPeakel> peakels = this.getSelectedIPeakels();
        Peakel peakel = peakels.get(0).getPeakel();
        PeakelsHelper helper = this.getPeakelsHelper();
        List<Peakel> coelutingPeakels = helper.findCoelutigPeakels(peakel.getApexMz() - 5.0, peakel.getApexMz() + 5.0, peakel.getFirstElutionTime(), peakel.getLastElutionTime());
        SpectrumData spectrumData = helper.buildSpectrumDataFromPeakels(peakel, coelutingPeakels);
        Spectrum spectrum = new Spectrum(-1, peakel.getApexElutionTime(), spectrumData.getMzList(), spectrumData.getIntensityList(), 1, Spectrum.ScanType.CENTROID);
        this.m_viewersController.getRawFileViewer(peakels.get(0).getRawFile(), true).setReferenceSpectrum(spectrum);
    }

    private PeakelsHelper getPeakelsHelper() {
        if (this.m_helper == null) {
            Peakel[] apeakels = (Peakel[])this.m_features.stream().flatMap(f -> Arrays.stream(f.getPeakels())).toArray(Peakel[]::new);
            this.m_helper = new PeakelsHelper(apeakels);
        }
        return this.m_helper;
    }

    @Override
    protected List<IPeakel> getSelectedIPeakels() {
        if (this.m_features != null && !this.m_features.isEmpty() && this.m_table.getSelectedRowCount() > 0) {
            int[] selectedRows = this.m_table.getSelectedRows();
            List<IPeakel> selectedPeakels = Arrays.stream(selectedRows).mapToObj(r -> this.m_features.get(this.getModelRowId(r))).collect(Collectors.toList());
            return selectedPeakels;
        }
        return null;
    }

    @Override
    protected List<Peakel> getSelectedPeakels() {
        if (this.m_features != null && !this.m_features.isEmpty() && this.m_table.getSelectedRowCount() > 0) {
            int[] selectedRows = this.m_table.getSelectedRows();
            List<Peakel> selectedPeakels = Arrays.stream(selectedRows).mapToObj(r -> this.m_features.get(this.getModelRowId(r))).flatMap(f -> Arrays.stream(f.getPeakels())).collect(Collectors.toList());
            return selectedPeakels;
        }
        return null;
    }

    public void addFeatures(List<IFeature> features) {
        ((FeaturesTableModel)this.m_compoundTableModel.getBaseModel()).addFeatures(features);
        this.m_features.addAll(features);
        this.m_markerContainerPanel.setMaxLineNumber(features.size());
    }

    public void setFeatures(List<IFeature> features, boolean displayRawFileColumn) {
        this.m_modelSelectedRowBeforeSort = -1;
        this.m_helper = null;
        ((FeaturesTableModel)this.m_compoundTableModel.getBaseModel()).setFeatures(features);
        this.m_features = features;
        this.m_markerContainerPanel.setMaxLineNumber(features.size());
        this.m_table.getColumnExt(this.m_table.convertColumnIndexToView(FeaturesTableModel.COLTYPE_FEATURE_RAWFILE.getIndex())).setVisible(displayRawFileColumn);
    }

    private void matchCSVIons() {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        String directory = prefs.get(LAST_DIR, this.m_fchooser.getCurrentDirectory().getAbsolutePath());
        this.m_fchooser.setCurrentDirectory(new File(directory));
        int result = this.m_fchooser.showOpenDialog(this);
        if (result == 0) {
            File csvFile = this.m_fchooser.getSelectedFile();
            String fileName = csvFile.getName();
            if (!fileName.endsWith(".csv")) {
                JOptionPane.showMessageDialog(this, "The file must be a csv file", "Error", 0);
                return;
            }
            prefs.put(LAST_DIR, csvFile.getParentFile().getAbsolutePath());
            ImportedDataTableModel importedTableModel = new ImportedDataTableModel();
            Exception csvException = ImportedDataTableModel.loadFile((ImportedDataTableModel)importedTableModel, (String)csvFile.getAbsolutePath(), (char)';', (boolean)true, (boolean)false);
            if (csvException == null) {
                int mzColumnIdx = this.findColumn((AbstractTableModel)importedTableModel, new String[]{"moz", "m/z", "mz"});
                int rtColumnIdx = this.findColumn((AbstractTableModel)importedTableModel, new String[]{"rt", "retention_time", "retention time", "elution_time", "elution time", "time"});
                int zColumnIdx = this.findColumn((AbstractTableModel)importedTableModel, new String[]{"charge", "z"});
                if (mzColumnIdx != -1) {
                    ArrayList<Double> mzValues = new ArrayList<Double>();
                    ArrayList<Double> rtValues = new ArrayList<Double>();
                    ArrayList<Integer> zValues = new ArrayList<Integer>();
                    for (int k = 0; k < importedTableModel.getRowCount(); ++k) {
                        mzValues.add((Double)importedTableModel.getValueAt(k, mzColumnIdx));
                        rtValues.add(rtColumnIdx != -1 ? (Double)importedTableModel.getValueAt(k, rtColumnIdx) : -1.0);
                        zValues.add(zColumnIdx != -1 ? ((Long)importedTableModel.getValueAt(k, zColumnIdx)).intValue() : 0);
                    }
                    this.matchFeatures(mzValues, rtValues, zValues);
                } else {
                    StringBuffer columnNamesBuffer = new StringBuffer("[");
                    for (int i = 0; i < importedTableModel.getColumnCount(); ++i) {
                        columnNamesBuffer.append(importedTableModel.getColumnName(i)).append(";");
                    }
                    columnNamesBuffer.deleteCharAt(columnNamesBuffer.length() - 1);
                    columnNamesBuffer.append("]");
                    String message = "No column named \"mz\",\"moz\" or \"m/z\" detected in the imported file.\n Verify the column headers (the column separator must be \";\") \n" + columnNamesBuffer.toString();
                    JOptionPane.showMessageDialog(this, message, "Error", 0);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Error while redading CSV file : " + csvException.getMessage(), "Error", 0);
            }
        }
    }

    private void matchFeatures(List<Double> mzValues, List<Double> rtValues, List<Integer> zValues) {
        float moztol = 10.0f;
        Map featuresByNominalMass = this.m_features.stream().collect(Collectors.groupingBy(f -> (int)f.getMz(), Collectors.toList()));
        int matchingCount = 0;
        ArrayList<ImmutablePair> matched = new ArrayList<ImmutablePair>();
        ArrayList<BaseFeature> notFound = new ArrayList<BaseFeature>();
        ArrayList<IFeature> dubiousFeatures = new ArrayList<IFeature>();
        for (int k = 0; k < mzValues.size(); ++k) {
            double mz = mzValues.get(k);
            double rt = rtValues.get(k) * 60.0;
            int z = zValues.get(k);
            List features = featuresByNominalMass.get((int)mz);
            if (features != null) {
                IFeature feature2 = features.stream().filter(f -> {
                    double tolDa = f.getMz() * (double)moztol / 1000000.0;
                    return rt >= (double)f.getFirstElutionTime() && rt <= (double)f.getLastElutionTime() && Math.abs(f.getMz() - mz) < tolDa && (f.getCharge() == 0 || z == 0 || z == f.getCharge());
                }).findFirst().orElse(null);
                if (feature2 != null) {
                    ++matchingCount;
                    matched.add(new ImmutablePair((Object)k, (Object)feature2));
                    logger.info("Feature matching: {}; {}; {}; {}+ = {}; {}; {}+; {}", new Object[]{k, mz, rt, z, feature2.getMz(), Float.valueOf(feature2.getElutionTime()), feature2.getCharge(), feature2.getPeakelsCount()});
                    if (feature2.getPeakelsCount() > 2) continue;
                    dubiousFeatures.add(feature2);
                    continue;
                }
                BaseFeature f2 = new BaseFeature(mz, (float)rt, (float)rt, (float)rt, null, 1);
                f2.setCharge(z);
                notFound.add(f2);
                logger.warn("no feature found for {}, {}, {}+", new Object[]{mz, rt / 60.0, z});
                continue;
            }
            BaseFeature f3 = new BaseFeature(mz, (float)rt, (float)rt, (float)rt, null, 1);
            f3.setCharge(z);
            notFound.add(f3);
            logger.warn("no feature found for {}, {}, {}+", new Object[]{mz, rt / 60.0, z});
        }
        logger.info("Found {} matches over {}", (Object)matchingCount, (Object)mzValues.size());
        logger.info("Not matched summary :: {}", (Object)matched.size());
        matched.forEach(p -> logger.info("matched Feature  = {}; {}; {}; {}; {} ", new Object[]{p.getLeft(), ((IFeature)p.getRight()).getMz(), (double)((IFeature)p.getRight()).getElutionTime() / 60.0, ((IFeature)p.getRight()).getCharge(), ((IFeature)p.getRight()).getPeakelsCount()}));
        logger.info("Not found summary :: {}", (Object)notFound.size());
        notFound.forEach(feature -> logger.info("Feature not found = {}, {}, {}+", new Object[]{feature.getMz(), (double)feature.getElutionTime() / 60.0, feature.getCharge()}));
        logger.info("Dubious features summary :: {} ", (Object)dubiousFeatures.size());
        dubiousFeatures.forEach(feature -> logger.info("Dubious Feature  = {}, {}, {}+, {} ", new Object[]{feature.getMz(), (double)feature.getElutionTime() / 60.0, feature.getCharge(), feature.getPeakelsCount()}));
        logger.info("Found {} matches over {}", (Object)matchingCount, (Object)mzValues.size());
        logger.info("Not found summary :: {}", (Object)notFound.size());
        logger.info("Dubious features summary :: {} ", (Object)dubiousFeatures.size());
        Map<Integer, Long> result = dubiousFeatures.stream().collect(Collectors.groupingBy(IFeature::getPeakelsCount, Collectors.counting()));
        for (Map.Entry<Integer, Long> e : result.entrySet()) {
            logger.info("dubious features with {} peakels: {}", (Object)e.getKey(), (Object)e.getValue());
        }
    }

    private int findColumn(AbstractTableModel tableModel, String[] alternativeNames) {
        String name;
        int columnIdx = -1;
        String[] stringArray = alternativeNames;
        int n = stringArray.length;
        for (int i = 0; i < n && (columnIdx = tableModel.findColumn(name = stringArray[i])) == -1; ++i) {
        }
        return columnIdx;
    }
}

