/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui.peakels;

import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.model.SpectrumData;
import fr.proline.mzscope.model.IPeakel;
import fr.proline.mzscope.model.Spectrum;
import fr.proline.mzscope.processing.PeakelsHelper;
import fr.proline.mzscope.ui.IMzScopeController;
import fr.proline.mzscope.ui.peakels.AbstractPeakelsPanel;
import fr.proline.mzscope.ui.peakels.FeaturesTableModel;
import fr.proline.mzscope.ui.peakels.PeakelsTableModel;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.utils.IconManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class PeakelsPanel
extends AbstractPeakelsPanel {
    protected List<IPeakel> m_peakels = new ArrayList<IPeakel>();
    protected PeakelsHelper m_helper = null;

    public PeakelsPanel(IMzScopeController controller) {
        super(controller);
    }

    @Override
    protected CompoundTableModel buildTableModel() {
        PeakelsTableModel model = new PeakelsTableModel();
        return new CompoundTableModel((GlobalTableModelInterface)model, true);
    }

    @Override
    protected List<IPeakel> getSelectedIPeakels() {
        if (this.m_peakels != null && !this.m_peakels.isEmpty() && this.m_table.getSelectedRowCount() > 0) {
            int[] selectedRows = this.m_table.getSelectedRows();
            List<IPeakel> selectedPeakels = Arrays.stream(selectedRows).mapToObj(r -> this.m_peakels.get(this.getModelRowId(r))).collect(Collectors.toList());
            return selectedPeakels;
        }
        return null;
    }

    @Override
    protected List<Peakel> getSelectedPeakels() {
        return this.getSelectedIPeakels().stream().map(p -> p.getPeakel()).collect(Collectors.toList());
    }

    @Override
    protected JToolBar initToolbar() {
        JToolBar toolbar = super.initToolbar();
        JButton buildSpectrumBtn = new JButton();
        buildSpectrumBtn.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.SIGNAL));
        buildSpectrumBtn.setToolTipText("Build Spectrum from peakels");
        buildSpectrumBtn.addActionListener(e -> this.buildSpectrum());
        toolbar.add(buildSpectrumBtn);
        return toolbar;
    }

    private void buildSpectrum() {
        List<IPeakel> peakels = this.getSelectedIPeakels();
        Peakel peakel = peakels.get(0).getPeakel();
        PeakelsHelper helper = this.getPeakelsHelper();
        List<Peakel> coelutingPeakels = helper.findCoelutigPeakels(peakel.getApexMz() - 5.0, peakel.getApexMz() + 5.0, peakel.getFirstElutionTime(), peakel.getLastElutionTime());
        SpectrumData spectrumData = helper.buildSpectrumDataFromPeakels(peakel, coelutingPeakels);
        Spectrum spectrum = new Spectrum(-1, peakel.getApexElutionTime(), spectrumData.getMzList(), spectrumData.getIntensityList(), 1, Spectrum.ScanType.CENTROID);
        this.m_viewersController.getRawFileViewer(peakels.get(0).getRawFile(), true).setReferenceSpectrum(spectrum);
    }

    private PeakelsHelper getPeakelsHelper() {
        if (this.m_helper == null) {
            Peakel[] apeakels = (Peakel[])this.m_peakels.stream().map(p -> p.getPeakel()).toArray(Peakel[]::new);
            this.m_helper = new PeakelsHelper(apeakels);
        }
        return this.m_helper;
    }

    public void addPeakels(List<IPeakel> peakels) {
        ((PeakelsTableModel)this.m_compoundTableModel.getBaseModel()).addPeakels(peakels);
        this.m_peakels.addAll(peakels);
        this.m_markerContainerPanel.setMaxLineNumber(peakels.size());
    }

    public void setPeakels(List<IPeakel> peakels, boolean displayRawFileColumn) {
        this.m_modelSelectedRowBeforeSort = -1;
        this.m_helper = null;
        ((PeakelsTableModel)this.m_compoundTableModel.getBaseModel()).setPeakels(peakels);
        this.m_peakels = peakels;
        this.m_markerContainerPanel.setMaxLineNumber(peakels.size());
        this.m_table.getColumnExt(this.m_table.convertColumnIndexToView(FeaturesTableModel.COLTYPE_FEATURE_RAWFILE.getIndex())).setVisible(displayRawFileColumn);
    }
}

