/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.context;

import fr.proline.context.IExecutionContext;
import fr.proline.context.LcMsDbConnectionContext;
import fr.proline.context.MsiDbConnectionContext;
import fr.proline.context.UdsDbConnectionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecoratedExecutionContext
implements IExecutionContext {
    private static final Logger LOG = LoggerFactory.getLogger(DecoratedExecutionContext.class);
    private final IExecutionContext m_wrappedExecutionContext;

    protected DecoratedExecutionContext(IExecutionContext wrappedExecutionContext) {
        if (wrappedExecutionContext == null) {
            throw new IllegalArgumentException("WrappedExecutionContext is null");
        }
        if (wrappedExecutionContext instanceof DecoratedExecutionContext) {
            LOG.info("Wrapping a [{}] into a [{}]", (Object)wrappedExecutionContext.getClass().getName(), (Object)this.getClass().getName());
        }
        this.m_wrappedExecutionContext = wrappedExecutionContext;
    }

    public IExecutionContext unwrap() {
        return this.m_wrappedExecutionContext;
    }

    public <T extends IExecutionContext> T find(Class<? extends T> contextClassifier) {
        if (contextClassifier == null) {
            throw new IllegalArgumentException("ContextClassifier is null");
        }
        IExecutionContext result = null;
        if (contextClassifier.isInstance(this)) {
            result = (IExecutionContext)contextClassifier.cast(this);
        } else {
            IExecutionContext wrappedEC = this.unwrap();
            do {
                if (contextClassifier.isInstance(wrappedEC)) {
                    result = (IExecutionContext)contextClassifier.cast(wrappedEC);
                    continue;
                }
                if (!(wrappedEC instanceof DecoratedExecutionContext)) break;
                wrappedEC = ((DecoratedExecutionContext)wrappedEC).unwrap();
            } while (result == null);
        }
        return (T)result;
    }

    @Override
    public long getProjectId() {
        return this.m_wrappedExecutionContext.getProjectId();
    }

    @Override
    public UdsDbConnectionContext getUDSDbConnectionContext() {
        return this.m_wrappedExecutionContext.getUDSDbConnectionContext();
    }

    @Override
    public MsiDbConnectionContext getMSIDbConnectionContext() {
        return this.m_wrappedExecutionContext.getMSIDbConnectionContext();
    }

    @Override
    public LcMsDbConnectionContext getLCMSDbConnectionContext() {
        return this.m_wrappedExecutionContext.getLCMSDbConnectionContext();
    }

    @Override
    public boolean isJPA() {
        return this.m_wrappedExecutionContext.isJPA();
    }

    @Override
    public void closeAll() {
        try {
            this.clearContext();
        }
        finally {
            this.m_wrappedExecutionContext.closeAll();
        }
    }

    public void clearContext() {
    }
}

