/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.repository;

import fr.profi.util.PropertiesUtils;
import fr.proline.repository.AbstractDatabaseConnector;
import fr.proline.repository.DataSourceWrapper;
import fr.proline.repository.DriverType;
import fr.proline.repository.ProlineDatabaseType;
import fr.proline.repository.dialect.SQLiteDialect;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.sqlite.SQLiteDataSource;

public class SQLiteDatabaseConnector
extends AbstractDatabaseConnector {
    private static final String MEMORY_URL_PROTOCOL = ":memory:";

    public SQLiteDatabaseConnector(ProlineDatabaseType database, Map<Object, Object> properties) {
        super(database, properties);
    }

    @Override
    public DriverType getDriverType() {
        return DriverType.SQLITE;
    }

    @Override
    protected boolean isMemory(Map<Object, Object> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties Map is null");
        }
        boolean result = false;
        String databaseURL = PropertiesUtils.getProperty(properties, (String)"javax.persistence.jdbc.url");
        if (databaseURL != null) {
            result = databaseURL.toLowerCase().contains(MEMORY_URL_PROTOCOL);
        }
        return result;
    }

    @Override
    protected DataSource createDataSource(String ident, Map<Object, Object> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties Map is null");
        }
        SQLiteDataSource source = new SQLiteDataSource();
        source.setUrl(PropertiesUtils.getProperty(properties, (String)"javax.persistence.jdbc.url"));
        return new DataSourceWrapper((DataSource)source, this);
    }

    @Override
    protected EntityManagerFactory createEntityManagerFactory(ProlineDatabaseType database, Map<Object, Object> properties, boolean ormOptimizations) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties Map is null");
        }
        if (properties.get("hibernate.dialect") == null) {
            properties.put("hibernate.dialect", SQLiteDialect.class.getName());
        }
        return super.createEntityManagerFactory(database, properties, false);
    }
}

