/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.lib.ddl.DatabaseProductNotFoundException;
import org.netbeans.lib.ddl.adaptors.DefaultAdaptor;
import org.netbeans.lib.ddl.impl.CreateTable;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.lib.ddl.impl.SpecificationFactory;
import org.netbeans.lib.ddl.impl.TableColumn;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DerbyConectionEventListener;
import org.netbeans.modules.db.explorer.node.RootNode;
import org.netbeans.modules.db.metadata.model.api.Catalog;
import org.netbeans.modules.db.metadata.model.api.Column;
import org.netbeans.modules.db.metadata.model.api.Index;
import org.netbeans.modules.db.metadata.model.api.IndexColumn;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class DatabaseConnector {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private DatabaseConnection databaseConnection;
    private Connection connection = null;
    private Specification spec;
    private ConcurrentHashMap<String, DriverSpecification> driverSpecCache = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Object> properties = new ConcurrentHashMap();

    public DatabaseConnector(DatabaseConnection conn) {
        this.databaseConnection = conn;
    }

    public DatabaseConnection getDatabaseConnection() {
        return this.databaseConnection;
    }

    public Specification getDatabaseSpecification() {
        return this.spec;
    }

    public DriverSpecification getDriverSpecification(String catName) throws DatabaseException {
        DriverSpecification dspec = this.driverSpecCache.get(catName);
        if (dspec == null) {
            try {
                SpecificationFactory factory = RootNode.instance().getSpecificationFactory();
                dspec = factory.createDriverSpecification(this.spec.getMetaData().getDriverName().trim());
                if (this.spec.getMetaData().getDriverName().trim().equals("jConnect (TM) for JDBC (TM)")) {
                    dspec.setMetaData(this.connection.getMetaData());
                } else {
                    dspec.setMetaData(this.spec.getMetaData());
                }
                dspec.setCatalog(catName);
                dspec.setSchema(this.databaseConnection.getSchema());
                this.driverSpecCache.put(catName, dspec);
            }
            catch (SQLException e) {
                throw new DatabaseException(e.getMessage(), e);
            }
        }
        return dspec;
    }

    public void finishConnect(String dbsys, DatabaseConnection con, Connection connection) throws DatabaseException {
        try {
            SpecificationFactory factory = RootNode.instance().getSpecificationFactory();
            int readOnlyFlag = 0;
            if (dbsys != null) {
                this.spec = (Specification)factory.createSpecification(con, dbsys, connection);
                readOnlyFlag = 1;
            } else {
                this.spec = (Specification)factory.createSpecification(con, connection);
            }
            DatabaseMetaData md = this.spec.getMetaData();
            ((DefaultAdaptor)md).setreadOnly(readOnlyFlag);
            String adaname = "org.netbeans.lib.ddl.adaptors.DefaultAdaptor";
            if (!this.spec.getMetaDataAdaptorClassName().equals(adaname)) {
                this.spec.setMetaDataAdaptorClassName(adaname);
            }
            this.setConnection(connection);
        }
        catch (DatabaseProductNotFoundException e) {
            Logger.getLogger(DatabaseConnector.class.getName()).log(Level.FINE, e.getLocalizedMessage(), e);
            this.finishConnect("GenericDatabaseSystem", null, connection);
        }
        catch (Exception e) {
            throw new DatabaseException(e.getMessage());
        }
    }

    public boolean isDisconnected() {
        return this.connection == null;
    }

    public void performDisconnect() throws DatabaseException {
        if (this.connection != null) {
            Throwable cause = null;
            Connection con = this.connection;
            try {
                this.driverSpecCache.clear();
                this.setConnection(null);
                con.close();
            }
            catch (Exception exc) {
                this.setConnection(null);
            }
            DerbyConectionEventListener.getDefault().afterDisconnect(this.getDatabaseConnection(), con);
            if (cause != null) {
                throw new DatabaseException(NbBundle.getMessage(DatabaseConnector.class, (String)"EXC_DisconnectError", (Object)cause.getMessage()), cause);
            }
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection con) throws DatabaseException {
        Connection oldval = this.connection;
        if (con != null) {
            if (oldval != null && oldval.equals(con)) {
                return;
            }
            this.connection = con;
        } else {
            this.connection = null;
        }
        this.driverSpecCache.clear();
        this.notifyChange();
    }

    public static boolean containsColumn(Collection<Column> columnList, Column column) {
        boolean result = false;
        MetadataElementHandle columnHandle = MetadataElementHandle.create((MetadataElement)column);
        for (Column col : columnList) {
            MetadataElementHandle colHandle = MetadataElementHandle.create((MetadataElement)col);
            if (!columnHandle.equals((Object)colHandle)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean containsIndexColumn(Collection<Index> columnList, Column column) {
        boolean result = false;
        MetadataElementHandle columnHandle = MetadataElementHandle.create((MetadataElement)column);
        block0: for (Index idx : columnList) {
            Collection cols = idx.getColumns();
            for (IndexColumn col : cols) {
                MetadataElementHandle colHandle = MetadataElementHandle.create((MetadataElement)col);
                if (!columnHandle.equals((Object)colHandle)) continue;
                result = true;
                continue block0;
            }
        }
        return result;
    }

    public TableColumn getColumnSpecification(Table table, Column column) throws DatabaseException {
        TableColumn col;
        block8: {
            col = null;
            try {
                CreateTable cmd = this.spec.createCommandCreateTable("DUMMY");
                col = DatabaseConnector.containsColumn(table.getPrimaryKey().getColumns(), column) ? cmd.createPrimaryKeyColumn(column.getName()) : (DatabaseConnector.containsIndexColumn(table.getIndexes(), column) ? cmd.createUniqueColumn(column.getName()) : cmd.createColumn(column.getName()));
                Schema schema = table.getParent();
                Catalog catalog = schema.getParent();
                String catName = catalog.getName();
                if (catName == null) {
                    catName = schema.getName();
                }
                DriverSpecification drvSpec = this.getDriverSpecification(catName);
                if (!schema.isDefault() && schema.getName() != null && schema.getName().length() > 0) {
                    drvSpec.setSchema(schema.getName());
                }
                drvSpec.getColumns(table.getName(), column.getName());
                ResultSet rs = drvSpec.getResultSet();
                if (rs == null) break block8;
                boolean ok = rs.next();
                if (ok) {
                    Map<Integer, String> rset = drvSpec.getRow();
                    try {
                        col.setColumnType(Integer.parseInt(rset.get(new Integer(5))));
                        col.setColumnSize(Integer.parseInt(rset.get(new Integer(7))));
                    }
                    catch (NumberFormatException exc) {
                        col.setColumnType(0);
                        col.setColumnSize(0);
                    }
                    col.setNullAllowed(rset.get(new Integer(18)).toUpperCase().equals("YES"));
                    col.setDefaultValue(rset.get(new Integer(13)));
                    rset.clear();
                } else {
                    Logger.getLogger(DatabaseConnector.class.getName()).log(Level.INFO, "Empty ResultSet for {0}.{1} in catalog {2}", new Object[]{table.getName(), column.getName(), catName});
                }
                rs.close();
            }
            catch (Exception e) {
                throw new DatabaseException(e);
            }
        }
        return col;
    }

    public boolean supportsCommand(String cmd) {
        boolean supported;
        boolean bl = supported = this.spec.getCommandProperties(cmd) != null;
        if (supported && this.spec.getCommandProperties(cmd).containsKey("Supported")) {
            supported = this.spec.getCommandProperties(cmd).get("Supported").toString().equals("true");
        }
        return supported;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public void notifyChange() {
        this.changeSupport.fireChange();
    }
}

