/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.Bundle;
import org.netbeans.modules.db.explorer.node.CatalogNode;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Catalog;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

public class CatalogNodeProvider
extends NodeProvider
implements PropertyChangeListener {
    private final List<Node> nodes = new ArrayList<Node>();
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);

    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    private CatalogNodeProvider(Lookup lookup) {
        super(lookup, new CatalogComparator());
    }

    @Override
    protected synchronized void initialize() {
        final ArrayList<Node> newList = new ArrayList<Node>();
        final ArrayList otherList = new ArrayList();
        MetadataModel metaDataModel = this.connection.getMetadataModel();
        boolean isConnected = !this.connection.getConnector().isDisconnected();
        this.nodes.clear();
        if (isConnected && metaDataModel != null) {
            try {
                metaDataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metaData) {
                        Collection catalogs = metaData.getCatalogs();
                        for (Catalog catalog : catalogs) {
                            boolean oneCatalog;
                            boolean bl = oneCatalog = catalogs.size() == 1;
                            if (catalog.getName() == null && !oneCatalog) continue;
                            if (CatalogNodeProvider.this.isDefaultCatalog(catalog, CatalogNodeProvider.this.connection)) {
                                CatalogNodeProvider.this.updateNode(newList, catalog);
                                continue;
                            }
                            CatalogNodeProvider.this.updateNode(otherList, catalog);
                        }
                        CatalogNodeProvider.this.nodes.addAll(newList);
                        CatalogNodeProvider.this.nodes.addAll(otherList);
                        if (!otherList.isEmpty()) {
                            newList.add(new OtherCatalogsNode(otherList));
                        }
                        if (newList.size() == 1) {
                            CatalogNodeProvider.this.setProxyNodes(newList);
                        } else {
                            CatalogNodeProvider.this.setNodes(newList);
                        }
                    }
                });
            }
            catch (MetadataModelException e) {
                NodeRegistry.handleMetadataModelException(this.getClass(), this.connection, e, true);
            }
        } else if (!isConnected) {
            this.setNodes(newList);
        }
        this.connection.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.connection));
    }

    private boolean isDefaultCatalog(Catalog catalog, DatabaseConnection connection) {
        String def = connection.getDefaultCatalog();
        return def == null && catalog.isDefault() || def != null && def.equals(catalog.getName()) || connection.isImportantCatalog(catalog.getName());
    }

    private void updateNode(List<Node> newList, Catalog catalog) {
        MetadataElementHandle catalogHandle = MetadataElementHandle.create((MetadataElement)catalog);
        Collection<Node> matches = this.getNodes(catalogHandle);
        if (matches != null && matches.size() > 0) {
            newList.addAll(matches);
        } else {
            NodeDataLookup lookup = new NodeDataLookup();
            lookup.add(this.connection);
            lookup.add(catalogHandle);
            newList.add((Node)CatalogNode.create(lookup, this));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (this.initialized && "importantCatalogs".equals(pce.getPropertyName())) {
            ArrayList<Node> mainList = new ArrayList<Node>();
            ArrayList<Node> otherList = new ArrayList<Node>();
            for (Node node : new ArrayList<Node>(this.nodes)) {
                if (this.connection.isImportantCatalog(node.getName())) {
                    mainList.add(node.cloneNode());
                    continue;
                }
                otherList.add(node.cloneNode());
            }
            if (!otherList.isEmpty()) {
                mainList.add((Node)new OtherCatalogsNode(otherList));
            }
            this.setNodes(mainList);
        }
    }

    static class CatalogComparator
    implements Comparator<Node> {
        CatalogComparator() {
        }

        @Override
        public int compare(Node node1, Node node2) {
            if (node1 instanceof OtherCatalogsNode) {
                return 1;
            }
            if (node2 instanceof OtherCatalogsNode) {
                return -1;
            }
            return node1.getDisplayName().compareToIgnoreCase(node2.getDisplayName());
        }
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            @Override
            public CatalogNodeProvider createInstance(Lookup lookup) {
                CatalogNodeProvider provider = new CatalogNodeProvider(lookup);
                return provider;
            }
        };

        private FactoryHolder() {
        }
    }

    private static class OtherCatalogsNode
    extends AbstractNode {
        private static final String ICON_BASE = "org/netbeans/modules/db/resources/database.gif";

        public OtherCatalogsNode(List<Node> otherList) {
            super(OtherCatalogsNode.createChildren(otherList));
            this.setDisplayName(Bundle.LBL_OtherDatabases());
            this.setIconBaseWithExtension(ICON_BASE);
        }

        private static Children createChildren(final List<Node> otherList) {
            Children c = Children.create((ChildFactory)new ChildFactory<Node>(){

                protected boolean createKeys(List<Node> toPopulate) {
                    toPopulate.addAll(otherList);
                    return true;
                }

                protected Node createNodeForKey(Node key) {
                    return key;
                }
            }, (boolean)false);
            return c;
        }
    }
}

