/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.repository.util;

import fr.profi.util.StringUtils;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.spi.JdbcWrapper;
import org.postgresql.PGConnection;
import org.postgresql.copy.CopyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PostgresUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PostgresUtils.class);

    private PostgresUtils() {
    }

    public static CopyManager getCopyManager(Object connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException("Con is null");
        }
        CopyManager result = null;
        if (connection instanceof PGConnection) {
            PGConnection pgConnection = (PGConnection)connection;
            result = pgConnection.getCopyAPI();
        } else if (connection instanceof JdbcWrapper) {
            JdbcWrapper jdbcWrapper = (JdbcWrapper)connection;
            Object wrappedObject = jdbcWrapper.getWrappedObject();
            result = PostgresUtils.getCopyManager(wrappedObject);
        } else if (connection instanceof Connection) {
            PGConnection pgConnection = ((Connection)connection).unwrap(PGConnection.class);
            result = pgConnection.getCopyAPI();
        } else {
            PostgresUtils.debugProxy(connection);
            throw new IllegalArgumentException("Invalid PostgreSQL connection");
        }
        return result;
    }

    private static void debugProxy(Object obj) {
        Class<?>[] interfaces;
        Class<?> clazz = obj.getClass();
        StringBuilder buff = new StringBuilder();
        buff.append("Runtime Class : ").append(clazz.getName());
        if (Proxy.isProxyClass(clazz)) {
            buff.append("  Java Proxy class");
        }
        buff.append(StringUtils.LINE_SEPARATOR);
        for (Class<?> intf : interfaces = clazz.getInterfaces()) {
            buff.append("  implement : ").append(intf.getName());
            buff.append(StringUtils.LINE_SEPARATOR);
        }
        LOG.warn(buff.toString());
    }
}

