/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dst;

import edu.emory.mathcs.jtransforms.dst.FloatDST_1D;
import edu.emory.mathcs.jtransforms.dst.FloatDST_2D;
import edu.emory.mathcs.jtransforms.dst.FloatDST_3D;
import edu.emory.mathcs.utils.IOUtils;

public class AccuracyCheckFloatDST {
    private static int[] sizes1D = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 512, 1024, 1056, 2048, 8192, 10158, 16384, 32768, 65536, 131072};
    private static int[] sizes2D = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 511, 512, 1024};
    private static int[] sizes3D = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 128};
    private static double eps = Math.pow(2.0, -23.0);

    private AccuracyCheckFloatDST() {
    }

    public static void checkAccuracyDST_1D() {
        System.out.println("Checking accuracy of 1D DST...");
        for (int i = 0; i < sizes1D.length; ++i) {
            FloatDST_1D dst = new FloatDST_1D(sizes1D[i]);
            double err = 0.0;
            float[] a = new float[sizes1D[i]];
            IOUtils.fillMatrix_1D(sizes1D[i], a);
            float[] b = new float[sizes1D[i]];
            IOUtils.fillMatrix_1D(sizes1D[i], b);
            dst.forward(a, true);
            dst.inverse(a, true);
            err = AccuracyCheckFloatDST.computeRMSE(a, b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes1D[i] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes1D[i] + ";\terror = " + err);
            }
            a = null;
            b = null;
            dst = null;
            System.gc();
        }
    }

    public static void checkAccuracyDST_2D() {
        Object b;
        Object a;
        double err;
        FloatDST_2D dst2;
        int i;
        System.out.println("Checking accuracy of 2D DST (float[] input)...");
        for (i = 0; i < sizes2D.length; ++i) {
            dst2 = new FloatDST_2D(sizes2D[i], sizes2D[i]);
            err = 0.0;
            a = new float[sizes2D[i] * sizes2D[i]];
            IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], a);
            b = new float[sizes2D[i] * sizes2D[i]];
            IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], b);
            dst2.forward((float[])a, true);
            dst2.inverse((float[])a, true);
            err = AccuracyCheckFloatDST.computeRMSE(a, b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D[i] + " x " + sizes2D[i] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D[i] + " x " + sizes2D[i] + ";\terror = " + err);
            }
            a = null;
            b = null;
            dst2 = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D DST (float[][] input)...");
        for (i = 0; i < sizes2D.length; ++i) {
            dst2 = new FloatDST_2D(sizes2D[i], sizes2D[i]);
            err = 0.0;
            a = new float[sizes2D[i]][sizes2D[i]];
            IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], (float[][])a);
            b = new float[sizes2D[i]][sizes2D[i]];
            IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], (float[][])b);
            dst2.forward((float[][])a, true);
            dst2.inverse((float[][])a, true);
            err = AccuracyCheckFloatDST.computeRMSE((float[][])a, (float[][])b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D[i] + " x " + sizes2D[i] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D[i] + " x " + sizes2D[i] + ";\terror = " + err);
            }
            a = null;
            b = null;
            dst2 = null;
            System.gc();
        }
    }

    public static void checkAccuracyDST_3D() {
        Object b;
        Object a;
        double err;
        FloatDST_3D dst3;
        int i;
        System.out.println("Checking accuracy of 3D DST (float[] input)...");
        for (i = 0; i < sizes3D.length; ++i) {
            dst3 = new FloatDST_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            err = 0.0;
            a = new float[sizes3D[i] * sizes3D[i] * sizes3D[i]];
            IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], a);
            b = new float[sizes3D[i] * sizes3D[i] * sizes3D[i]];
            IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], b);
            dst3.forward((float[])a, true);
            dst3.inverse((float[])a, true);
            err = AccuracyCheckFloatDST.computeRMSE(a, b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + ";\t\terror = " + err);
            }
            a = null;
            b = null;
            dst3 = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D DST (float[][][] input)...");
        for (i = 0; i < sizes3D.length; ++i) {
            dst3 = new FloatDST_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            err = 0.0;
            a = new float[sizes3D[i]][sizes3D[i]][sizes3D[i]];
            IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], (float[][][])a);
            b = new float[sizes3D[i]][sizes3D[i]][sizes3D[i]];
            IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], (float[][][])b);
            dst3.forward((float[][][])a, true);
            dst3.inverse((float[][][])a, true);
            err = AccuracyCheckFloatDST.computeRMSE((float[][][])a, (float[][][])b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + ";\t\terror = " + err);
            }
            a = null;
            b = null;
            dst3 = null;
            System.gc();
        }
    }

    private static double computeRMSE(float[] a, float[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double rms = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double tmp = a[i] - b[i];
            rms += tmp * tmp;
        }
        return Math.sqrt(rms / (double)a.length);
    }

    private static double computeRMSE(float[][] a, float[][] b) {
        if (a.length != b.length || a[0].length != b[0].length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double rms = 0.0;
        for (int r = 0; r < a.length; ++r) {
            for (int c = 0; c < a[0].length; ++c) {
                double tmp = a[r][c] - b[r][c];
                rms += tmp * tmp;
            }
        }
        return Math.sqrt(rms / (double)(a.length * a[0].length));
    }

    private static double computeRMSE(float[][][] a, float[][][] b) {
        if (a.length != b.length || a[0].length != b[0].length || a[0][0].length != b[0][0].length) {
            throw new IllegalArgumentException("Arrays are not the same size");
        }
        double rms = 0.0;
        for (int s = 0; s < a.length; ++s) {
            for (int r = 0; r < a[0].length; ++r) {
                for (int c = 0; c < a[0][0].length; ++c) {
                    double tmp = a[s][r][c] - b[s][r][c];
                    rms += tmp * tmp;
                }
            }
        }
        return Math.sqrt(rms / (double)(a.length * a[0].length * a[0][0].length));
    }

    public static void main(String[] args) {
        AccuracyCheckFloatDST.checkAccuracyDST_1D();
        AccuracyCheckFloatDST.checkAccuracyDST_2D();
        AccuracyCheckFloatDST.checkAccuracyDST_3D();
        System.exit(0);
    }
}

