/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.logparser.txt;

import fr.proline.logparser.model.LogLineReader;
import fr.proline.logparser.model.ProlineException;
import fr.proline.logparser.model.Utility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import org.openide.util.Exceptions;

public class LogApp {
    LogLineReader m_reader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogApp(String filePath, Utility.DATE_FORMAT dateFormat) throws IOException, ProlineException {
        LogLineReader reader;
        long start = System.currentTimeMillis();
        InputStream inputStream = null;
        File file = new File(filePath);
        this.m_reader = reader = new LogLineReader(file.getName(), dateFormat, true, true);
        try {
            String abPath = file.getAbsolutePath();
            System.out.println("absolute path is " + abPath);
            inputStream = new FileInputStream(abPath);
            Scanner fileScanner = new Scanner(inputStream, StandardCharsets.UTF_8.name());
            long index = 0L;
            try {
                System.out.println("Analyse begin...");
                while (fileScanner.hasNextLine()) {
                    String line = fileScanner.nextLine();
                    this.m_reader.registerTask(-1, line, ++index);
                }
            }
            catch (ProlineException ex) {
                System.err.println(" task register stop at line " + index);
                throw ex;
            }
            this.m_reader.memoryClean();
            String info = String.format("Analyse done. %d line in total, %d lines no treated. Total read time is %s", index, this.m_reader.getNoTreatLineCount(), Utility.formatDeltaTime(System.currentTimeMillis() - start));
            System.out.println(info);
            this.m_reader.showNoTreatedLines();
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            inputStream.close();
        }
        this.m_reader.close();
    }

    public static void main(String[] args) {
        int count = args.length;
        if (count == 0) {
            System.out.println("Please give the log file to Analyse");
            System.out.println("LogApp FileNameToAnalyse [dateformate(normal/short)]");
            return;
        }
        String file2Anaylse = "";
        String logTaskBeginEndFileName = "";
        Utility.DATE_FORMAT dFormat = Utility.DATE_FORMAT.SHORT;
        String dateFormat = "";
        block7: for (int i = 0; i < count; ++i) {
            switch (i) {
                case 0: {
                    file2Anaylse = args[0];
                    continue block7;
                }
                case 1: {
                    dateFormat = args[1];
                    if (!dateFormat.equalsIgnoreCase("normal")) continue block7;
                    dFormat = Utility.DATE_FORMAT.NORMAL;
                    continue block7;
                }
                case 2: {
                    logTaskBeginEndFileName = args[2];
                    continue block7;
                }
            }
        }
        try {
            System.out.println(".File to Analyse: " + file2Anaylse);
            System.out.println(".. Task Start Stop registered in File : " + logTaskBeginEndFileName);
            LogApp i = new LogApp(file2Anaylse, dFormat);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

