/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.db.sql.editor.OptionsUtils;
import org.netbeans.modules.db.sql.editor.completion.SQLCompletionEnv;
import org.netbeans.modules.db.sql.lexer.SQLLexer;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;
import org.netbeans.spi.editor.typinghooks.TypedTextInterceptor;

public class SQLTypedTextInterceptor
implements TypedTextInterceptor {
    public boolean beforeInsert(final TypedTextInterceptor.Context context) throws BadLocationException {
        Boolean result;
        if (!OptionsUtils.isPairCharactersCompletion()) {
            return false;
        }
        final Document doc = context.getDocument();
        Callable<Boolean> callable = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                Character prevChar;
                Character nextChar;
                int caretOffset = context.getOffset();
                String str = context.getText();
                try {
                    nextChar = Character.valueOf(doc.getText(caretOffset, 1).charAt(0));
                }
                catch (BadLocationException ex) {
                    nextChar = null;
                }
                try {
                    prevChar = Character.valueOf(doc.getText(caretOffset - 1, 1).charAt(0));
                }
                catch (BadLocationException ex) {
                    prevChar = null;
                }
                if (nextChar.charValue() == str.charAt(0) && (prevChar.charValue() == '(' && nextChar.charValue() == ')' || SQLLexer.isEndStringQuoteChar(prevChar.charValue(), nextChar.charValue()) || SQLLexer.isEndIdentifierQuoteChar(prevChar.charValue(), nextChar.charValue()))) {
                    Caret c = context.getComponent().getCaret();
                    c.setDot(c.getDot() + 1);
                    return true;
                }
                return false;
            }
        };
        try {
            if (doc instanceof BaseDocument) {
                FutureTask<Boolean> task = new FutureTask<Boolean>(callable);
                ((BaseDocument)doc).runAtomic(task);
                result = task.get();
            } else {
                result = (Boolean)callable.call();
            }
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    public void insert(TypedTextInterceptor.MutableContext context) throws BadLocationException {
    }

    public void afterInsert(final TypedTextInterceptor.Context context) throws BadLocationException {
        if (!OptionsUtils.isPairCharactersCompletion()) {
            return;
        }
        final Document doc = context.getDocument();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Character nextChar;
                int caretOffset = context.getOffset();
                String str = context.getText();
                try {
                    nextChar = Character.valueOf(doc.getText(caretOffset + str.length(), 1).charAt(0));
                }
                catch (BadLocationException ex) {
                    nextChar = null;
                }
                if (!str.isEmpty()) {
                    char insertedChar = str.charAt(str.length() - 1);
                    if (SQLLexer.isStartIdentifierQuoteChar(insertedChar) && (nextChar == null || Character.isWhitespace(nextChar.charValue()) || nextChar.equals(Character.valueOf('.'))) || SQLLexer.isStartStringQuoteChar(insertedChar) && (nextChar == null || Character.isWhitespace(nextChar.charValue()))) {
                        if (SQLTypedTextInterceptor.canCompleteQuote(doc, caretOffset)) {
                            try {
                                doc.insertString(caretOffset + str.length(), String.valueOf((char)SQLLexer.getMatchingQuote(insertedChar)), null);
                                context.getComponent().getCaret().setDot(caretOffset + str.length());
                            }
                            catch (BadLocationException ex) {}
                        }
                    } else if (insertedChar == '(' && (nextChar == null || Character.isWhitespace(nextChar.charValue())) && SQLTypedTextInterceptor.canCompleteBrace(doc, caretOffset)) {
                        try {
                            doc.insertString(caretOffset + str.length(), ")", null);
                            context.getComponent().getCaret().setDot(caretOffset + str.length());
                        }
                        catch (BadLocationException ex) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        if (doc instanceof BaseDocument) {
            ((BaseDocument)doc).runAtomic(r);
        } else {
            r.run();
        }
    }

    private static boolean canCompleteQuote(Document doc, int caretOffset) {
        SQLCompletionEnv env = SQLCompletionEnv.forDocument(doc, caretOffset);
        TokenSequence<SQLTokenId> seq = env.getTokenSequence();
        if (seq.move(caretOffset) == 0 && seq.movePrevious()) {
            switch ((SQLTokenId)seq.token().id()) {
                case WHITESPACE: 
                case DOT: {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean canCompleteBrace(Document doc, int caretOffset) {
        SQLCompletionEnv env = SQLCompletionEnv.forDocument(doc, caretOffset);
        TokenSequence<SQLTokenId> seq = env.getTokenSequence();
        if (seq.move(caretOffset) == 0 && seq.movePrevious()) {
            switch ((SQLTokenId)seq.token().id()) {
                case WHITESPACE: {
                    return true;
                }
            }
        }
        return false;
    }

    public void cancelled(TypedTextInterceptor.Context context) {
    }

    public static class Factory
    implements TypedTextInterceptor.Factory {
        public TypedTextInterceptor createTypedTextInterceptor(MimePath mimePath) {
            return new SQLTypedTextInterceptor();
        }
    }
}

