/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.LookupSensitiveAction;
import org.netbeans.modules.project.ui.actions.ShortcutManager;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.FileActionPerformer;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.Mutex;

public final class FileAction
extends LookupSensitiveAction
implements ContextAwareAction {
    private String command;
    private FileActionPerformer performer;
    private final String namePattern;
    private static final Logger LOG = Logger.getLogger(FileAction.class.getName());

    public FileAction(String command, String namePattern, Icon icon, Lookup lookup) {
        this(command, null, namePattern, icon, lookup);
    }

    public FileAction(FileActionPerformer performer, String namePattern, Icon icon, Lookup lookup) {
        this(null, performer, namePattern, icon, lookup);
    }

    private FileAction(String command, FileActionPerformer performer, String namePattern, Icon icon, Lookup lookup) {
        super(icon, lookup, new Class[]{Project.class, DataObject.class});
        assert (!(command == null && performer == null || command != null && performer != null));
        this.command = command;
        if (command != null) {
            ShortcutManager.INSTANCE.registerAction(command, this);
        }
        this.performer = performer;
        this.namePattern = namePattern;
        String presenterName = ActionsUtil.formatName(namePattern, 0, "");
        this.setDisplayName(presenterName);
        this.putValue("ShortDescription", Actions.cutAmpersand((String)presenterName));
    }

    @Override
    public final void putValue(String key, Object value) {
        super.putValue(key, value);
        if ("AcceleratorKey".equals(key)) {
            ShortcutManager.INSTANCE.registerShortcut(this.command, value);
        }
    }

    @Override
    protected void refresh(final Lookup context, boolean immediate) {
        final Runnable[] r = new Runnable[1];
        final boolean[] enable = new boolean[1];
        final String[] presenterName = new String[1];
        if (this.command != null) {
            r[0] = new Runnable(){

                @Override
                public void run() {
                    Project[] projects = ActionsUtil.getProjectsFromLookup(context, FileAction.this.command);
                    if (projects.length != 1) {
                        if (projects.length == 0 && FileAction.this.globalProvider(context) != null) {
                            enable[0] = true;
                            Collection files = context.lookupAll(DataObject.class);
                            presenterName[0] = ActionsUtil.formatName(FileAction.this.namePattern, files.size(), files.isEmpty() ? "" : ((DataObject)files.iterator().next()).getPrimaryFile().getNameExt());
                            if (LOG.isLoggable(Level.FINER)) {
                                LOG.log(Level.FINER, "Enabling [{0}, {1}] for {2}. (no projects in lookup)", new Object[]{presenterName[0], enable[0], files.isEmpty() ? "no files" : ((DataObject)files.iterator().next()).getPrimaryFile()});
                            }
                        } else {
                            enable[0] = false;
                            presenterName[0] = ActionsUtil.formatName(FileAction.this.namePattern, 0, "");
                            if (LOG.isLoggable(Level.FINER)) {
                                Collection files = context.lookupAll(DataObject.class);
                                LOG.log(Level.FINER, "Enabling [{0}, {1}] for {2}. (projects > 1 in lookup)", new Object[]{presenterName[0], enable[0], files.isEmpty() ? "no files" : ((DataObject)files.iterator().next()).getPrimaryFile()});
                            }
                        }
                    } else {
                        FileObject[] files = ActionsUtil.getFilesFromLookup(context, projects[0]);
                        enable[0] = true;
                        presenterName[0] = ActionsUtil.formatName(FileAction.this.namePattern, files.length, files.length > 0 ? files[0].getNameExt() : "");
                        if (LOG.isLoggable(Level.FINER)) {
                            LOG.log(Level.FINER, "Enabling [{0}, {1}] for {2}. (one project in lookup)", new Object[]{presenterName[0], enable[0], files.length == 0 ? "no files" : files[0]});
                        }
                    }
                }
            };
        } else if (this.performer != null) {
            r[0] = new Runnable(){

                @Override
                public void run() {
                    Collection dobjs = context.lookupAll(DataObject.class);
                    if (dobjs.size() == 1) {
                        FileObject f = ((DataObject)dobjs.iterator().next()).getPrimaryFile();
                        enable[0] = FileAction.this.performer.enable(f);
                        presenterName[0] = ActionsUtil.formatName(FileAction.this.namePattern, 1, f.getNameExt());
                        if (LOG.isLoggable(Level.FINER)) {
                            LOG.log(Level.FINER, "Enabling [{0}, {1}] for {2}.", new Object[]{presenterName[0], enable[0], f});
                        }
                    } else {
                        enable[0] = false;
                        presenterName[0] = ActionsUtil.formatName(FileAction.this.namePattern, 0, "");
                        if (LOG.isLoggable(Level.FINER)) {
                            LOG.log(Level.FINER, "Enabling [{0}, {1}]. (no dataobjects)", new Object[]{presenterName[0], enable[0]});
                        }
                    }
                }
            };
        }
        if (r != null) {
            Runnable delegate = new Runnable(){

                @Override
                public void run() {
                    r[0].run();
                    Mutex.EVENT.writeAccess(new Runnable(){

                        @Override
                        public void run() {
                            FileAction.this.putValue("menuText", presenterName[0]);
                            FileAction.this.putValue("ShortDescription", Actions.cutAmpersand((String)presenterName[0]));
                            FileAction.this.setEnabled(enable[0]);
                        }
                    });
                }
            };
            if (immediate) {
                delegate.run();
            } else {
                RP.post(delegate);
            }
        }
    }

    @Override
    protected void actionPerformed(final Lookup context) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Collection dobjs;
                if (FileAction.this.command != null) {
                    final Project[] projects = ActionsUtil.getProjectsFromLookup(context, FileAction.this.command);
                    Runnable r2 = new Runnable(){

                        @Override
                        public void run() {
                            if (projects.length == 1) {
                                ActionProvider ap = (ActionProvider)projects[0].getLookup().lookup(ActionProvider.class);
                                ap.invokeAction(FileAction.this.command, context);
                                return;
                            }
                            ActionProvider provider = FileAction.this.globalProvider(context);
                            if (provider != null) {
                                provider.invokeAction(FileAction.this.command, context);
                            }
                        }
                    };
                    if (SwingUtilities.isEventDispatchThread()) {
                        r2.run();
                    } else {
                        SwingUtilities.invokeLater(r2);
                    }
                } else if (FileAction.this.performer != null && (dobjs = context.lookupAll(DataObject.class)).size() == 1) {
                    FileAction.this.performer.perform(((DataObject)dobjs.iterator().next()).getPrimaryFile());
                }
            }
        };
        if (Boolean.getBoolean("sync.project.execution")) {
            r.run();
        } else {
            RP.post(r);
        }
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new FileAction(this.command, this.performer, this.namePattern, (Icon)this.getValue("SmallIcon"), actionContext);
    }

    private ActionProvider globalProvider(Lookup context) {
        for (ActionProvider ap : Lookup.getDefault().lookupAll(ActionProvider.class)) {
            if (!Arrays.asList(ap.getSupportedActions()).contains(this.command) || !ap.isActionEnabled(this.command, context)) continue;
            return ap;
        }
        return null;
    }
}

