/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.groups;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.project.ui.groups.Bundle;
import org.netbeans.modules.project.ui.groups.Group;
import org.netbeans.modules.project.ui.groups.GroupsMenu;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ManageGroupsPanel
extends JPanel
implements PropertyChangeListener {
    private static final RequestProcessor RP = new RequestProcessor(ManageGroupsPanel.class.getName());
    private static final String NONE_GOUP = "(none)";
    private JList groupList;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JButton propertiesButton;
    private JButton removeAllButton;
    private JButton removeButton;
    private JLabel selectionLabel;

    public ManageGroupsPanel() {
        this.initComponents();
        DefaultListModel<String> model = new DefaultListModel<String>();
        String selectedValue = null;
        for (Group g : Group.allGroups()) {
            model.addElement(g.getName());
            if (!g.equals(Group.getActiveGroup())) continue;
            selectedValue = g.getName();
        }
        model.addElement(NONE_GOUP);
        this.groupList.setModel(model);
        this.groupList.setSelectedValue(selectedValue == null ? NONE_GOUP : selectedValue, true);
        this.groupList.setEnabled(model.getSize() > 0);
        this.groupList.setSelectionMode(2);
        this.groupList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ManageGroupsPanel.this.firePropertyChange("selection", null, null);
            }
        });
        this.groupList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            Group.setActiveGroup(ManageGroupsPanel.this.getSelectedGroups()[0], false);
                        }
                    });
                    Window w = SwingUtilities.getWindowAncestor(ManageGroupsPanel.this);
                    if (w != null) {
                        w.setVisible(false);
                        w.dispose();
                    }
                }
            }
        });
        boolean isReady = this.isReady();
        boolean isNoneGroupSelected = this.isNoneGroupSelected();
        this.removeButton.setEnabled(isReady && this.isAtLeastOneGroupSelected() && !isNoneGroupSelected);
        this.removeAllButton.setEnabled(isReady && model.getSize() > 1);
        this.propertiesButton.setEnabled(isReady && this.isExactlyOneGroupSelected() && !isNoneGroupSelected);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("selection")) {
                    boolean isNoneGroupSelected = ManageGroupsPanel.this.isNoneGroupSelected();
                    ManageGroupsPanel.this.removeButton.setEnabled(ManageGroupsPanel.this.isAtLeastOneGroupSelected() && !isNoneGroupSelected);
                    ManageGroupsPanel.this.removeAllButton.setEnabled(ManageGroupsPanel.this.groupList.getModel().getSize() > 1);
                    ManageGroupsPanel.this.propertiesButton.setEnabled(ManageGroupsPanel.this.isExactlyOneGroupSelected() && !isNoneGroupSelected);
                    ManageGroupsPanel.this.groupList.setEnabled(ManageGroupsPanel.this.groupList.getModel().getSize() > 0);
                }
            }
        });
    }

    private boolean isReady() {
        ListModel model = this.groupList.getModel();
        return model.getSize() == Group.allGroups().size() + 1;
    }

    private boolean isNoneGroupSelected() {
        Group[] selectedGroups;
        for (Group groupIter : selectedGroups = this.getSelectedGroups()) {
            if (groupIter != null) continue;
            return true;
        }
        return false;
    }

    private boolean isAtLeastOneGroupSelected() {
        return this.groupList.getSelectedValuesList().size() >= 1;
    }

    final boolean isExactlyOneGroupSelected() {
        return this.groupList.getSelectedValuesList().size() == 1;
    }

    Group[] getSelectedGroups() {
        Group[] selection = new Group[this.groupList.getSelectedValuesList().size()];
        for (int i = 0; i < this.groupList.getSelectedValuesList().size(); ++i) {
            String groupName = (String)this.groupList.getSelectedValuesList().get(i);
            for (Group g : Group.allGroups()) {
                if (g.getName().equals(groupName)) {
                    selection[i] = g;
                    continue;
                }
                if (!NONE_GOUP.equals(groupName)) continue;
                selection[i] = null;
            }
        }
        return selection;
    }

    private void removeGroups(Iterable<Group> groups) {
        DefaultListModel model = (DefaultListModel)this.groupList.getModel();
        for (final Group groupIter : groups) {
            if (groupIter == null) continue;
            model.removeElement(groupIter.getName());
            RP.post(new Runnable(){

                @Override
                public void run() {
                    groupIter.destroy();
                }
            });
        }
    }

    private void initComponents() {
        this.selectionLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.groupList = new JList();
        this.propertiesButton = new JButton();
        this.removeButton = new JButton();
        this.removeAllButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.setMinimumSize(new Dimension(600, 250));
        this.setPreferredSize(new Dimension(600, 250));
        this.setLayout(new GridBagLayout());
        this.selectionLabel.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.selectionLabel, (String)NbBundle.getMessage(ManageGroupsPanel.class, (String)"ManageGroupsPanel.selectionLabel.text"));
        this.selectionLabel.setVerticalTextPosition(1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 12, 0);
        this.add((Component)this.selectionLabel, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(300, 130));
        this.jScrollPane1.setViewportView(this.groupList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.4;
        gridBagConstraints.weighty = 1.9;
        gridBagConstraints.insets = new Insets(0, 12, 12, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.propertiesButton, (String)NbBundle.getMessage(ManageGroupsPanel.class, (String)"ManageGroupsPanel.propertiesButton.text"));
        this.propertiesButton.setMaximumSize(new Dimension(105, 29));
        this.propertiesButton.setMinimumSize(new Dimension(105, 29));
        this.propertiesButton.setPreferredSize(new Dimension(105, 29));
        this.propertiesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageGroupsPanel.this.propertiesButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.add((Component)this.propertiesButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(ManageGroupsPanel.class, (String)"ManageGroupsPanel.removeButton.text"));
        this.removeButton.setMaximumSize(new Dimension(87, 29));
        this.removeButton.setMinimumSize(new Dimension(87, 29));
        this.removeButton.setPreferredSize(new Dimension(87, 29));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageGroupsPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 18;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 0, 12);
        this.add((Component)this.removeButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeAllButton, (String)NbBundle.getMessage(ManageGroupsPanel.class, (String)"ManageGroupsPanel.removeAllButton.text"));
        this.removeAllButton.setMaximumSize(new Dimension(87, 29));
        this.removeAllButton.setMinimumSize(new Dimension(87, 29));
        this.removeAllButton.setPreferredSize(new Dimension(87, 29));
        this.removeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageGroupsPanel.this.removeAllButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 18;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 0, 12);
        this.add((Component)this.removeAllButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(17, 12, 0, 12);
        this.add((Component)this.jSeparator2, gridBagConstraints);
    }

    private void propertiesButtonActionPerformed(ActionEvent evt) {
        Group selectedGroup = this.getSelectedGroups()[0];
        selectedGroup.addChangeListener(this);
        GroupsMenu.openProperties(selectedGroup);
        selectedGroup.removeChangeListener(this);
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)Bundle.ManageGroupsPanel_wrn_remove_selected_groups_msg(), Bundle.ManageGroupsPanel_wrn_remove_selected_groups_title(), 0, 3);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION) {
            this.removeGroups(Arrays.asList(this.getSelectedGroups()));
        }
    }

    private void removeAllButtonActionPerformed(ActionEvent evt) {
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)Bundle.ManageGroupsPanel_wrn_remove_all_groups_msg(), Bundle.ManageGroupsPanel_wrn_remove_all_groups_title(), 0, 3);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION) {
            this.removeGroups(Group.allGroups());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("groupRename")) {
            String oldGroupName = (String)event.getOldValue();
            String newGroupName = (String)event.getNewValue();
            DefaultListModel model = (DefaultListModel)this.groupList.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                if (!((String)model.getElementAt(i)).equals(oldGroupName)) continue;
                model.setElementAt(newGroupName, i);
            }
        }
    }
}

