/*
 * Decompiled with CFR 0.152.
 */
package com.github.mzdb4s.msdata;

import com.github.mzdb4s.msdata.AbstractSpectrumData;
import com.github.mzdb4s.msdata.ILcContext;
import com.github.mzdb4s.msdata.IPeak;
import com.github.mzdb4s.msdata.Peak;
import com.github.mzdb4s.msdata.SpectrumData$;
import com.github.mzdb4s.util.ms.MsUtils$;
import java.util.Arrays;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileByteRef;

@ScalaSignature(bytes="\u0006\u0001\t\rb\u0001B\u0001\u0003\u0001.\u0011Ab\u00159fGR\u0014X/\u001c#bi\u0006T!a\u0001\u0003\u0002\r5\u001cH-\u0019;b\u0015\t)a!\u0001\u0004nu\u0012\u0014Gg\u001d\u0006\u0003\u000f!\taaZ5uQV\u0014'\"A\u0005\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u0001a\u0001C\u0006\t\u0003\u001b9i\u0011AA\u0005\u0003\u001f\t\u0011A#\u00112tiJ\f7\r^*qK\u000e$(/^7ECR\f\u0007CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"a\u0002)s_\u0012,8\r\u001e\t\u0003#]I!\u0001\u0007\n\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011i\u0001!Q3A\u0005\u0002m\ta!\u001c>MSN$X#\u0001\u000f\u0011\u0007u\u0011C%D\u0001\u001f\u0015\ty\u0002%A\u0004nkR\f'\r\\3\u000b\u0005\u0005\u0012\u0012AC2pY2,7\r^5p]&\u00111E\b\u0002\r/J\f\u0007\u000f]3e\u0003J\u0014\u0018-\u001f\t\u0003#\u0015J!A\n\n\u0003\r\u0011{WO\u00197f\u0011!A\u0003A!E!\u0002\u0013a\u0012aB7{\u0019&\u001cH\u000f\t\u0015\u0003O)\u0002\"a\u000b\u0018\u000e\u00031R!!\f\n\u0002\u000b\t,\u0017M\\:\n\u0005=b#\u0001\u0004\"fC:\u0004&o\u001c9feRL\b\"B\u0019\u0001\t\u0003\u0011\u0014!C4fi6SH*[:u)\u0005a\u0002\u0002\u0003\u001b\u0001\u0005+\u0007I\u0011A\u001b\u0002\u001b%tG/\u001a8tSRLH*[:u+\u00051\u0004cA\u000f#oA\u0011\u0011\u0003O\u0005\u0003sI\u0011QA\u00127pCRD\u0001b\u000f\u0001\u0003\u0012\u0003\u0006IAN\u0001\u000fS:$XM\\:jifd\u0015n\u001d;!Q\tQ$\u0006C\u0003?\u0001\u0011\u0005q(\u0001\thKRLe\u000e^3og&$\u0018\u0010T5tiR\ta\u0007\u0003\u0005B\u0001\tU\r\u0011\"\u00016\u00031aWM\u001a;Io\"lG*[:u\u0011!\u0019\u0005A!E!\u0002\u00131\u0014!\u00047fMRDu\u000f[7MSN$\b\u0005\u000b\u0002CU!)a\t\u0001C\u0001\u007f\u0005yq-\u001a;MK\u001a$\bj\u001e5n\u0019&\u001cH\u000f\u0003\u0005I\u0001\tU\r\u0011\"\u00016\u00035\u0011\u0018n\u001a5u\u0011^DW\u000eT5ti\"A!\n\u0001B\tB\u0003%a'\u0001\bsS\u001eDG\u000fS<i[2K7\u000f\u001e\u0011)\u0005%S\u0003\"B'\u0001\t\u0003y\u0014\u0001E4fiJKw\r\u001b;Io\"lG*[:u\u0011\u0015y\u0005\u0001\"\u0001Q\u0003\u0019a\u0014N\\5u}Q)\u0011KU*U+B\u0011Q\u0002\u0001\u0005\u000659\u0003\r\u0001\b\u0005\u0006i9\u0003\rA\u000e\u0005\u0006\u0003:\u0003\rA\u000e\u0005\u0006\u0011:\u0003\rA\u000e\u0005\b/\u0002\u0011\r\u0011\"\u0001Y\u0003)\u0001X-Y6t\u0007>,h\u000e^\u000b\u00023B\u0011\u0011CW\u0005\u00037J\u00111!\u00138u\u0011\u0019i\u0006\u0001)A\u00053\u0006Y\u0001/Z1lg\u000e{WO\u001c;!\u0011\u0015y\u0005\u0001\"\u0001`)\r\t\u0006\r\u001a\u0005\u00065y\u0003\r!\u0019\t\u0004#\t$\u0013BA2\u0013\u0005\u0015\t%O]1z\u0011\u0015!d\f1\u0001f!\r\t\"m\u000e\u0005\u0006O\u0002!\t\u0001[\u0001\fM>\u0014X)Y2i!\u0016\f7\u000e\u0006\u0002jkR\u0011!.\u001c\t\u0003#-L!\u0001\u001c\n\u0003\tUs\u0017\u000e\u001e\u0005\u0006]\u001a\u0004\ra\\\u0001\ra\u0016\f7nQ8ogVlWM\u001d\t\u0006#A\u0014\u0018L[\u0005\u0003cJ\u0011\u0011BR;oGRLwN\u001c\u001a\u0011\u00055\u0019\u0018B\u0001;\u0003\u0005\u0015I\u0005+Z1l\u0011\u00151h\r1\u0001x\u0003%a7mQ8oi\u0016DH\u000f\u0005\u0002\u000eq&\u0011\u0011P\u0001\u0002\u000b\u00132\u001b7i\u001c8uKb$\b\"B>\u0001\t\u0003a\u0018a\u0002;p!\u0016\f7n\u001d\u000b\u0003{z\u00042!\u00052s\u0011\u00151(\u00101\u0001x\u0011\u001d\t\t\u0001\u0001C\u0005\u0003\u0007\tQd\u00182j]N+\u0017M]2i\u0013:$W\r\u001f+p\u001d\u0016\f'/Z:u\u0013:$W\r\u001f\u000b\u00043\u0006\u0015\u0001BBA\u0004\u007f\u0002\u0007\u0011,\u0001\bcS:\u001cV-\u0019:dQ&sG-\u001a=\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e\u0005qq-\u001a;OK\u0006\u0014Xm\u001d;QK\u0006\\Gc\u0002:\u0002\u0010\u0005M\u0011q\u0003\u0005\b\u0003#\tI\u00011\u0001%\u0003\ti'\u0010C\u0004\u0002\u0016\u0005%\u0001\u0019\u0001\u0013\u0002\u00115THk\u001c7Q!6CaA^A\u0005\u0001\u00049\bbBA\u000e\u0001\u0011\u0005\u0011QD\u0001\u0014O\u0016$h*Z1sKN$\b+Z1l\u0013:$W\r\u001f\u000b\u00043\u0006}\u0001bBA\u0011\u00033\u0001\r\u0001J\u0001\u0006m\u0006dW/\u001a\u0005\b\u0003K\u0001A\u0011AA\u0014\u000319W\r\u001e)fC.Le\u000eZ3y)\u0015I\u0016\u0011FA\u0016\u0011\u001d\t\t#a\tA\u0002\u0011Bq!!\f\u0002$\u0001\u0007A%\u0001\u0004qa6$v\u000e\u001c\u0005\b\u0003c\u0001A\u0011AA\u001a\u00035i'PU1oO\u00164\u0015\u000e\u001c;feR)\u0011+!\u000e\u0002:!9\u0011qGA\u0018\u0001\u0004!\u0013!B7j]6S\bbBA\u001e\u0003_\u0001\r\u0001J\u0001\u0006[\u0006DXJ\u001f\u0005\n\u0003\u007f\u0001\u0011\u0011!C\u0001\u0003\u0003\nAaY8qsRI\u0011+a\u0011\u0002F\u0005\u001d\u0013\u0011\n\u0005\t5\u0005u\u0002\u0013!a\u00019!AA'!\u0010\u0011\u0002\u0003\u0007a\u0007\u0003\u0005B\u0003{\u0001\n\u00111\u00017\u0011!A\u0015Q\bI\u0001\u0002\u00041\u0004\"CA'\u0001E\u0005I\u0011AA(\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u0015+\u0007q\t\u0019f\u000b\u0002\u0002VA!\u0011qKA1\u001b\t\tIF\u0003\u0003\u0002\\\u0005u\u0013!C;oG\",7m[3e\u0015\r\tyFE\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA2\u00033\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\t9\u0007AI\u0001\n\u0003\tI'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005-$f\u0001\u001c\u0002T!I\u0011q\u000e\u0001\u0012\u0002\u0013\u0005\u0011\u0011N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0011%\t\u0019\bAI\u0001\n\u0003\tI'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\t\u0013\u0005]\u0004!!A\u0005B\u0005e\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002|A!\u0011QPAD\u001b\t\tyH\u0003\u0003\u0002\u0002\u0006\r\u0015\u0001\u00027b]\u001eT!!!\"\u0002\t)\fg/Y\u0005\u0005\u0003\u0013\u000byH\u0001\u0004TiJLgn\u001a\u0005\t\u0003\u001b\u0003\u0011\u0011!C\u00011\u0006a\u0001O]8ek\u000e$\u0018I]5us\"I\u0011\u0011\u0013\u0001\u0002\u0002\u0013\u0005\u00111S\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t)*a'\u0011\u0007E\t9*C\u0002\u0002\u001aJ\u00111!\u00118z\u0011%\ti*a$\u0002\u0002\u0003\u0007\u0011,A\u0002yIEB\u0011\"!)\u0001\u0003\u0003%\t%a)\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!*\u0011\r\u0005\u001d\u0016\u0011VAK\u001b\u0005\u0001\u0013bAAVA\tA\u0011\n^3sCR|'\u000fC\u0005\u00020\u0002\t\t\u0011\"\u0001\u00022\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u00024\u0006e\u0006cA\t\u00026&\u0019\u0011q\u0017\n\u0003\u000f\t{w\u000e\\3b]\"Q\u0011QTAW\u0003\u0003\u0005\r!!&\t\u0013\u0005u\u0006!!A\u0005B\u0005}\u0016\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003eC\u0011\"a1\u0001\u0003\u0003%\t%!2\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u001f\t\u0013\u0005%\u0007!!A\u0005B\u0005-\u0017AB3rk\u0006d7\u000f\u0006\u0003\u00024\u00065\u0007BCAO\u0003\u000f\f\t\u00111\u0001\u0002\u0016\u001eI\u0011\u0011\u001b\u0002\u0002\u0002#\u0005\u00111[\u0001\r'B,7\r\u001e:v[\u0012\u000bG/\u0019\t\u0004\u001b\u0005Ug\u0001C\u0001\u0003\u0003\u0003E\t!a6\u0014\u000b\u0005U\u0017\u0011\u001c\f\u0011\u0013\u0005m\u0017\u0011\u001d\u000f7mY\nVBAAo\u0015\r\tyNE\u0001\beVtG/[7f\u0013\u0011\t\u0019/!8\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007C\u0004P\u0003+$\t!a:\u0015\u0005\u0005M\u0007BCAb\u0003+\f\t\u0011\"\u0012\u0002F\"Q\u0011Q^Ak\u0003\u0003%\t)a<\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013E\u000b\t0!>\u0002z\u0006u\bB\u0002\u000e\u0002l\u0002\u0007A\u0004K\u0002\u0002r*Ba\u0001NAv\u0001\u00041\u0004fAA{U!1\u0011)a;A\u0002YB3!!?+\u0011\u0019A\u00151\u001ea\u0001m!\u001a\u0011Q \u0016\t\u0015\t\r\u0011Q[A\u0001\n\u0003\u0013)!A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\u001d!1\u0003\t\u0006#\t%!QB\u0005\u0004\u0005\u0017\u0011\"AB(qi&|g\u000eE\u0004\u0012\u0005\u001fabG\u000e\u001c\n\u0007\tE!C\u0001\u0004UkBdW\r\u000e\u0005\n\u0005+\u0011\t!!AA\u0002E\u000b1\u0001\u001f\u00131\u0011)\u0011I\"!6\u0002\u0002\u0013%!1D\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\u001eA!\u0011Q\u0010B\u0010\u0013\u0011\u0011\t#a \u0003\r=\u0013'.Z2u\u0001")
public class SpectrumData
extends AbstractSpectrumData
implements Product,
Serializable {
    private final WrappedArray<Object> mzList;
    private final WrappedArray<Object> intensityList;
    private final WrappedArray<Object> leftHwhmList;
    private final WrappedArray<Object> rightHwhmList;
    private final int peaksCount;

    public static Option<Tuple4<WrappedArray<Object>, WrappedArray<Object>, WrappedArray<Object>, WrappedArray<Object>>> unapply(SpectrumData spectrumData) {
        return SpectrumData$.MODULE$.unapply(spectrumData);
    }

    public static SpectrumData apply(WrappedArray<Object> wrappedArray, WrappedArray<Object> wrappedArray2, WrappedArray<Object> wrappedArray3, WrappedArray<Object> wrappedArray4) {
        return SpectrumData$.MODULE$.apply(wrappedArray, wrappedArray2, wrappedArray3, wrappedArray4);
    }

    public static Function1<Tuple4<WrappedArray<Object>, WrappedArray<Object>, WrappedArray<Object>, WrappedArray<Object>>, SpectrumData> tupled() {
        return SpectrumData$.MODULE$.tupled();
    }

    public static Function1<WrappedArray<Object>, Function1<WrappedArray<Object>, Function1<WrappedArray<Object>, Function1<WrappedArray<Object>, SpectrumData>>>> curried() {
        return SpectrumData$.MODULE$.curried();
    }

    public WrappedArray<Object> mzList() {
        return this.mzList;
    }

    public WrappedArray<Object> intensityList() {
        return this.intensityList;
    }

    public WrappedArray<Object> leftHwhmList() {
        return this.leftHwhmList;
    }

    public WrappedArray<Object> rightHwhmList() {
        return this.rightHwhmList;
    }

    @Override
    public int peaksCount() {
        return this.peaksCount;
    }

    @Override
    public void forEachPeak(ILcContext lcContext, Function2<IPeak, Object, BoxedUnit> peakConsumer) {
        for (int i = 0; i < this.peaksCount(); ++i) {
            float leftHwhm = 0.0f;
            float rightHwhm = 0.0f;
            if (this.leftHwhmList() != null && this.rightHwhmList() != null) {
                leftHwhm = BoxesRunTime.unboxToFloat((Object)this.leftHwhmList().apply(i));
                rightHwhm = BoxesRunTime.unboxToFloat((Object)this.rightHwhmList().apply(i));
            }
            peakConsumer.apply((Object)new Peak(BoxesRunTime.unboxToDouble((Object)this.mzList().apply(i)), BoxesRunTime.unboxToFloat((Object)this.intensityList().apply(i)), leftHwhm, rightHwhm, lcContext), (Object)BoxesRunTime.boxToInteger((int)i));
        }
    }

    @Override
    public IPeak[] toPeaks(ILcContext lcContext) {
        ObjectRef leftHwhmArray$lzy = ObjectRef.zero();
        ObjectRef rightHwhmArray$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        IPeak[] peaks = new IPeak[this.peaksCount()];
        double[] mzArray = (double[])this.mzList().array();
        float[] intensityArray = (float[])this.intensityList().array();
        for (int i = 0; i < this.peaksCount(); ++i) {
            float leftHwhm = 0.0f;
            float rightHwhm = 0.0f;
            if (this.leftHwhmList() != null && this.rightHwhmList() != null) {
                leftHwhm = this.leftHwhmArray$1(leftHwhmArray$lzy, bitmap$0)[i];
                rightHwhm = this.rightHwhmArray$1(rightHwhmArray$lzy, bitmap$0)[i];
            }
            peaks[i] = new Peak(mzArray[i], intensityArray[i], leftHwhm, rightHwhm, lcContext);
        }
        return peaks;
    }

    private int _binSearchIndexToNearestIndex(int binSearchIndex) {
        int idx;
        return binSearchIndex >= 0 ? binSearchIndex : ((idx = -binSearchIndex - 1) == 0 ? -1 : idx);
    }

    @Override
    public IPeak getNearestPeak(double mz, double mzTolPPM, ILcContext lcContext) {
        Peak peak;
        if (this.peaksCount() == 0) {
            return null;
        }
        double[] myMzList = (double[])this.mzList().array();
        double mzDa = MsUtils$.MODULE$.ppmToDa(mz, mzTolPPM);
        int binSearchIndex = Arrays.binarySearch(myMzList, mz);
        int idx = binSearchIndex >= 0 ? binSearchIndex : -binSearchIndex - 1;
        double prevVal = 0.0;
        double nextVal = 0.0;
        int newIdx = 0;
        if (idx == this.peaksCount()) {
            prevVal = myMzList[this.peaksCount() - 1];
            if (Math.abs(mz - prevVal) > mzDa) {
                return null;
            }
            newIdx = idx - 1;
        } else if (idx == 0) {
            nextVal = myMzList[idx];
            if (Math.abs(mz - nextVal) > mzDa) {
                return null;
            }
            newIdx = idx;
        } else {
            double diffPrevVal;
            nextVal = myMzList[idx];
            prevVal = myMzList[idx - 1];
            double diffNextVal = Math.abs(mz - nextVal);
            if (diffNextVal < (diffPrevVal = Math.abs(mz - prevVal))) {
                if (diffNextVal > mzDa) {
                    return null;
                }
                newIdx = idx;
            } else {
                if (diffPrevVal > mzDa) {
                    return null;
                }
                newIdx = idx - 1;
            }
        }
        if (this.leftHwhmList() == null || this.rightHwhmList() == null) {
            Peak peak2 = new Peak(myMzList[newIdx], ((float[])this.intensityList().array())[newIdx]);
            peak2.setLcContext(lcContext);
            peak = peak2;
        } else {
            peak = new Peak(myMzList[newIdx], ((float[])this.intensityList().array())[newIdx], ((float[])this.leftHwhmList().array())[newIdx], ((float[])this.rightHwhmList().array())[newIdx], lcContext);
        }
        return peak;
    }

    public int getNearestPeakIndex(double value) {
        double[] myMzList = (double[])this.mzList().array();
        int idx = Arrays.binarySearch(myMzList, value);
        idx = idx < 0 ? ~idx : idx;
        double min = Double.MAX_VALUE;
        for (int k = Math.max(0, idx - 1); k <= Math.min(this.peaksCount() - 1, idx + 1); ++k) {
            if (!(Math.abs(myMzList[k] - value) < min)) continue;
            min = Math.abs(myMzList[k] - value);
            idx = k;
        }
        return idx;
    }

    public int getPeakIndex(double value, double ppmTol) {
        double[] myMzList = (double[])this.mzList().array();
        int idx = Arrays.binarySearch(myMzList, value);
        idx = idx < 0 ? ~idx : idx;
        double min = Double.MAX_VALUE;
        int resultIdx = -1;
        for (int k = Math.max(0, idx - 1); k <= Math.min(this.peaksCount() - 1, idx + 1); ++k) {
            if (!(1000000.0 * Math.abs(myMzList[k] - value) / value < ppmTol) || !(Math.abs(myMzList[k] - value) < min)) continue;
            min = Math.abs(myMzList[k] - value);
            resultIdx = k;
        }
        return resultIdx;
    }

    public SpectrumData mzRangeFilter(double minMz, double maxMz) {
        int maxBinSearchIndex;
        int lastIdx;
        Predef$.MODULE$.require(minMz <= maxMz, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "maxMz can be lower than minMz";
            }
        });
        int nbPoints = this.peaksCount();
        double[] myMzList = (double[])this.mzList().array();
        int minBinSearchIndex = Arrays.binarySearch(myMzList, minMz);
        int firstIdx = this._binSearchIndexToNearestIndex(minBinSearchIndex);
        if (firstIdx == nbPoints) {
            return null;
        }
        if (firstIdx == -1) {
            firstIdx = 0;
        }
        if ((lastIdx = this._binSearchIndexToNearestIndex(maxBinSearchIndex = Arrays.binarySearch(myMzList, firstIdx, nbPoints, maxMz))) == -1) {
            return null;
        }
        SpectrumData filteredSpectrumData = this.leftHwhmList() == null || this.rightHwhmList() == null ? new SpectrumData(Arrays.copyOfRange(myMzList, firstIdx, lastIdx), Arrays.copyOfRange((float[])this.intensityList().array(), firstIdx, lastIdx)) : new SpectrumData((WrappedArray<Object>)Predef$.MODULE$.wrapDoubleArray(Arrays.copyOfRange(myMzList, firstIdx, lastIdx)), (WrappedArray<Object>)Predef$.MODULE$.wrapFloatArray(Arrays.copyOfRange((float[])this.intensityList().array(), firstIdx, lastIdx)), (WrappedArray<Object>)Predef$.MODULE$.wrapFloatArray(Arrays.copyOfRange((float[])this.leftHwhmList().array(), firstIdx, lastIdx)), (WrappedArray<Object>)Predef$.MODULE$.wrapFloatArray(Arrays.copyOfRange((float[])this.rightHwhmList().array(), firstIdx, lastIdx)));
        return filteredSpectrumData;
    }

    public WrappedArray<Object> getMzList() {
        return this.mzList();
    }

    public WrappedArray<Object> getIntensityList() {
        return this.intensityList();
    }

    public WrappedArray<Object> getLeftHwhmList() {
        return this.leftHwhmList();
    }

    public WrappedArray<Object> getRightHwhmList() {
        return this.rightHwhmList();
    }

    public SpectrumData copy(WrappedArray<Object> mzList, WrappedArray<Object> intensityList, WrappedArray<Object> leftHwhmList, WrappedArray<Object> rightHwhmList) {
        return new SpectrumData(mzList, intensityList, leftHwhmList, rightHwhmList);
    }

    public WrappedArray<Object> copy$default$1() {
        return this.mzList();
    }

    public WrappedArray<Object> copy$default$2() {
        return this.intensityList();
    }

    public WrappedArray<Object> copy$default$3() {
        return this.leftHwhmList();
    }

    public WrappedArray<Object> copy$default$4() {
        return this.rightHwhmList();
    }

    public String productPrefix() {
        return "SpectrumData";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        WrappedArray<Object> wrappedArray;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 3: {
                wrappedArray = this.rightHwhmList();
                break;
            }
            case 2: {
                wrappedArray = this.leftHwhmList();
                break;
            }
            case 1: {
                wrappedArray = this.intensityList();
                break;
            }
            case 0: {
                wrappedArray = this.mzList();
            }
        }
        return wrappedArray;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SpectrumData;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SpectrumData)) return false;
        boolean bl = true;
        if (!bl) return false;
        SpectrumData spectrumData = (SpectrumData)x$1;
        WrappedArray<Object> wrappedArray = this.mzList();
        WrappedArray<Object> wrappedArray2 = spectrumData.mzList();
        if (wrappedArray == null) {
            if (wrappedArray2 != null) {
                return false;
            }
        } else if (!wrappedArray.equals(wrappedArray2)) return false;
        WrappedArray<Object> wrappedArray3 = this.intensityList();
        WrappedArray<Object> wrappedArray4 = spectrumData.intensityList();
        if (wrappedArray3 == null) {
            if (wrappedArray4 != null) {
                return false;
            }
        } else if (!wrappedArray3.equals(wrappedArray4)) return false;
        WrappedArray<Object> wrappedArray5 = this.leftHwhmList();
        WrappedArray<Object> wrappedArray6 = spectrumData.leftHwhmList();
        if (wrappedArray5 == null) {
            if (wrappedArray6 != null) {
                return false;
            }
        } else if (!wrappedArray5.equals(wrappedArray6)) return false;
        WrappedArray<Object> wrappedArray7 = this.rightHwhmList();
        WrappedArray<Object> wrappedArray8 = spectrumData.rightHwhmList();
        if (wrappedArray7 == null) {
            if (wrappedArray8 != null) {
                return false;
            }
        } else if (!wrappedArray7.equals(wrappedArray8)) return false;
        if (!spectrumData.canEqual(this)) return false;
        return true;
    }

    private final float[] leftHwhmArray$lzycompute$1(ObjectRef leftHwhmArray$lzy$1, VolatileByteRef bitmap$0$1) {
        SpectrumData spectrumData = this;
        synchronized (spectrumData) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                leftHwhmArray$lzy$1.elem = (float[])this.leftHwhmList().array();
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (float[])leftHwhmArray$lzy$1.elem;
        }
    }

    private final float[] leftHwhmArray$1(ObjectRef leftHwhmArray$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.leftHwhmArray$lzycompute$1(leftHwhmArray$lzy$1, bitmap$0$1) : (float[])leftHwhmArray$lzy$1.elem;
    }

    private final float[] rightHwhmArray$lzycompute$1(ObjectRef rightHwhmArray$lzy$1, VolatileByteRef bitmap$0$1) {
        SpectrumData spectrumData = this;
        synchronized (spectrumData) {
            if ((byte)(bitmap$0$1.elem & 2) == 0) {
                rightHwhmArray$lzy$1.elem = (float[])this.rightHwhmList().array();
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 2);
            }
            return (float[])rightHwhmArray$lzy$1.elem;
        }
    }

    private final float[] rightHwhmArray$1(ObjectRef rightHwhmArray$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 2) == 0 ? this.rightHwhmArray$lzycompute$1(rightHwhmArray$lzy$1, bitmap$0$1) : (float[])rightHwhmArray$lzy$1.elem;
    }

    public SpectrumData(WrappedArray<Object> mzList, WrappedArray<Object> intensityList, WrappedArray<Object> leftHwhmList, WrappedArray<Object> rightHwhmList) {
        this.mzList = mzList;
        this.intensityList = intensityList;
        this.leftHwhmList = leftHwhmList;
        this.rightHwhmList = rightHwhmList;
        Product.class.$init$((Product)this);
        Predef$.MODULE$.require(mzList != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "mzList is null";
            }
        });
        Predef$.MODULE$.require(intensityList != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "intensityList is null";
            }
        });
        this.peaksCount = mzList.length();
    }

    public SpectrumData(double[] mzList, float[] intensityList) {
        this((WrappedArray<Object>)Predef$.MODULE$.wrapDoubleArray(mzList), (WrappedArray<Object>)Predef$.MODULE$.wrapFloatArray(intensityList), null, null);
    }
}

