/*
 * Decompiled with CFR 0.152.
 */
package com.github.mzdb4s.util.primitive;

public final class BytesUtils$ {
    public static final BytesUtils$ MODULE$;
    private final int BYTE_LEN;
    private final int SHORT_LEN;
    private final int INT_LEN;
    private final int FLOAT_LEN;
    private final int LONG_LEN;
    private final int DOUBLE_LEN;

    static {
        new BytesUtils$();
    }

    public int BYTE_LEN() {
        return this.BYTE_LEN;
    }

    public int SHORT_LEN() {
        return this.SHORT_LEN;
    }

    public int INT_LEN() {
        return this.INT_LEN;
    }

    public int FLOAT_LEN() {
        return this.FLOAT_LEN;
    }

    public int LONG_LEN() {
        return this.LONG_LEN;
    }

    public int DOUBLE_LEN() {
        return this.DOUBLE_LEN;
    }

    public int intToBytes(int num, byte[] bytes, int startIndex) {
        bytes[startIndex] = (byte)(num & 0xFF);
        bytes[startIndex + 1] = (byte)(num >> 8 & 0xFF);
        bytes[startIndex + 2] = (byte)(num >> 16 & 0xFF);
        bytes[startIndex + 3] = (byte)(num >> 24 & 0xFF);
        return startIndex + 4;
    }

    public int bytesToInt(byte[] bytes, int startIndex) {
        return bytes[startIndex] & 0xFF | (bytes[startIndex + 1] & 0xFF) << 8 | (bytes[startIndex + 2] & 0xFF) << 16 | (bytes[startIndex + 3] & 0xFF) << 24;
    }

    public int floatToBytes(float fnum, byte[] bytes, int startIndex) {
        return this.intToBytes(Float.floatToIntBits(fnum), bytes, startIndex);
    }

    public float bytesToFloat(byte[] bytes, int startIndex) {
        return Float.intBitsToFloat(this.bytesToInt(bytes, startIndex));
    }

    public int shortToBytes(short num, byte[] bytes, int startIndex) {
        bytes[startIndex] = (byte)(num & 0xFF);
        bytes[startIndex + 1] = (byte)(num >> 8 & 0xFF);
        return startIndex + 2;
    }

    public short bytesToShort(byte[] bytes, int startIndex) {
        return (short)(bytes[startIndex] & 0xFF | (bytes[startIndex + 1] & 0xFF) << 8);
    }

    public int stringToBytes(String str, byte[] bytes, int startIndex) {
        int n;
        int offset = startIndex + 1;
        int len = str.length();
        byte[] temp = str.getBytes();
        if (len > 255) {
            System.err.println("String has more than 255 bytes in \"stringToBytes\", it will be truncated.");
            bytes[startIndex] = (byte)255;
            System.arraycopy(temp, 0, bytes, offset, 255);
            n = offset + 255;
        } else {
            bytes[startIndex] = (byte)len;
            System.arraycopy(temp, 0, bytes, offset, len);
            n = offset + len;
        }
        return n;
    }

    public String bytesToString(byte[] bytes, int startIndex) {
        int len = bytes[startIndex] & 0xFF;
        return new String(bytes, startIndex + 1, len);
    }

    public int longToBytes(long lnum, byte[] bytes, int startIndex) {
        for (int i = 0; i < 8; ++i) {
            bytes[startIndex + i] = (byte)(lnum >> i * 8 & 0xFFL);
        }
        return startIndex + 8;
    }

    public long bytesToLong(byte[] bytes, int startIndex) {
        return (long)bytes[startIndex] & 0xFFL | ((long)bytes[startIndex + 1] & 0xFFL) << 8 | ((long)bytes[startIndex + 2] & 0xFFL) << 16 | ((long)bytes[startIndex + 3] & 0xFFL) << 24 | ((long)bytes[startIndex + 4] & 0xFFL) << 32 | ((long)bytes[startIndex + 5] & 0xFFL) << 40 | ((long)bytes[startIndex + 6] & 0xFFL) << 48 | ((long)bytes[startIndex + 7] & 0xFFL) << 56;
    }

    public int doubleToBytes(double dnum, byte[] bytes, int startIndex) {
        return this.longToBytes(Double.doubleToLongBits(dnum), bytes, startIndex);
    }

    public double bytesToDouble(byte[] bytes, int startIndex) {
        return Double.longBitsToDouble(this.bytesToLong(bytes, startIndex));
    }

    private BytesUtils$() {
        MODULE$ = this;
        this.BYTE_LEN = 1;
        this.SHORT_LEN = 2;
        this.INT_LEN = 4;
        this.FLOAT_LEN = 4;
        this.LONG_LEN = 8;
        this.DOUBLE_LEN = 8;
    }
}

