/*
 * Decompiled with CFR 0.152.
 */
package mr.go.sgfilter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mr.go.sgfilter.DataFilter;
import mr.go.sgfilter.Preprocessor;
import org.apache.commons.math.linear.RealMatrixImpl;

public class SGFilter {
    private final List<DataFilter> dataFilters = new ArrayList<DataFilter>();
    private int nl;
    private int nr;
    private final List<Preprocessor> preprocessors = new ArrayList<Preprocessor>();

    public static double[] computeSGCoefficients(int nl, int nr, int degree) {
        double sum;
        if (nl < 0 || nr < 0 || nl + nr < degree) {
            throw new IllegalArgumentException("Bad arguments");
        }
        RealMatrixImpl matrix = new RealMatrixImpl(degree + 1, degree + 1);
        double[][] a = matrix.getDataRef();
        for (int i = 0; i <= degree; ++i) {
            for (int j = 0; j <= degree; ++j) {
                int k;
                sum = i == 0 && j == 0 ? 1.0 : 0.0;
                for (k = 1; k <= nr; ++k) {
                    sum += Math.pow(k, i + j);
                }
                for (k = 1; k <= nl; ++k) {
                    sum += Math.pow(-k, i + j);
                }
                a[i][j] = sum;
            }
        }
        double[] b = new double[degree + 1];
        b[0] = 1.0;
        b = matrix.solve(b);
        double[] coeffs = new double[nl + nr + 1];
        for (int n = -nl; n <= nr; ++n) {
            sum = b[0];
            for (int m = 1; m <= degree; ++m) {
                sum += b[m] * Math.pow(n, m);
            }
            coeffs[n + nl] = sum;
        }
        return coeffs;
    }

    private static void convertDoubleArrayToFloat(double[] in, float[] out) {
        for (int i = 0; i < in.length; ++i) {
            out[i] = (float)in[i];
        }
    }

    private static void convertFloatArrayToDouble(float[] in, double[] out) {
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i];
        }
    }

    public SGFilter(int nl, int nr) {
        if (nl < 0 || nr < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        this.nl = nl;
        this.nr = nr;
    }

    public void appendDataFilter(DataFilter dataFilter) {
        this.dataFilters.add(dataFilter);
    }

    public void appendPreprocessor(Preprocessor p) {
        this.preprocessors.add(p);
    }

    public int getNl() {
        return this.nl;
    }

    public int getNr() {
        return this.nr;
    }

    public void insertDataFilter(DataFilter dataFilter, int index) {
        this.dataFilters.add(index, dataFilter);
    }

    public void insertPreprocessor(Preprocessor p, int index) {
        this.preprocessors.add(index, p);
    }

    public boolean removeDataFilter(DataFilter dataFilter) {
        return this.dataFilters.remove(dataFilter);
    }

    public DataFilter removeDataFilter(int index) {
        return this.dataFilters.remove(index);
    }

    public Preprocessor removePreprocessor(int index) {
        return this.preprocessors.remove(index);
    }

    public boolean removePreprocessor(Preprocessor p) {
        return this.preprocessors.remove(p);
    }

    public void setNl(int nl) {
        if (nl < 0) {
            throw new IllegalArgumentException("nl < 0");
        }
        this.nl = nl;
    }

    public void setNr(int nr) {
        if (nr < 0) {
            throw new IllegalArgumentException("nr < 0");
        }
        this.nr = nr;
    }

    public double[] smooth(double[] data, double[] coeffs) {
        return this.smooth(data, 0, data.length, coeffs);
    }

    public double[] smooth(double[] data, double[] leftPad, double[] rightPad, double[] coeffs) {
        return this.smooth(data, leftPad, rightPad, 0, (double[][])new double[][]{coeffs});
    }

    public double[] smooth(double[] data, double[] leftPad, double[] rightPad, int bias, double[][] coeffs) {
        int i;
        double sum;
        double[] sg;
        int b;
        int i2;
        int i3;
        if (bias < 0 || bias > this.nr || bias > this.nl) {
            throw new IllegalArgumentException("bias < 0 or bias > nr or bias > nl");
        }
        for (DataFilter dataFilter : this.dataFilters) {
            data = dataFilter.filter(data);
        }
        int dataLength = data.length;
        if (dataLength == 0) {
            return data;
        }
        int n = dataLength + this.nl + this.nr;
        double[] dataCopy = new double[n];
        int leftPadOffset = this.nl - leftPad.length;
        if (leftPadOffset >= 0) {
            for (i3 = 0; i3 < leftPad.length; ++i3) {
                dataCopy[leftPadOffset + i3] = leftPad[i3];
            }
        } else {
            for (i3 = 0; i3 < this.nl; ++i3) {
                dataCopy[i3] = leftPad[i3 - leftPadOffset];
            }
        }
        for (i3 = 0; i3 < dataLength; ++i3) {
            dataCopy[i3 + this.nl] = data[i3];
        }
        int rightPadOffset = this.nr - rightPad.length;
        if (rightPadOffset >= 0) {
            for (i2 = 0; i2 < rightPad.length; ++i2) {
                dataCopy[i2 + dataLength + this.nl] = rightPad[i2];
            }
        } else {
            for (i2 = 0; i2 < this.nr; ++i2) {
                dataCopy[i2 + dataLength + this.nl] = rightPad[i2];
            }
        }
        for (Preprocessor p : this.preprocessors) {
            p.apply(dataCopy);
        }
        double[] sdata = new double[dataLength];
        for (b = bias; b > 0; --b) {
            sg = coeffs[coeffs.length - b];
            int x = this.nl + bias - b;
            sum = 0.0;
            for (i = -this.nl + b; i <= this.nr; ++i) {
                sum += dataCopy[x + i] * sg[this.nl - b + i];
            }
            sdata[x - this.nl] = sum;
        }
        sg = coeffs[0];
        for (int x = this.nl + bias; x < n - this.nr - bias; ++x) {
            double sum2 = 0.0;
            for (int i4 = -this.nl; i4 <= this.nr; ++i4) {
                sum2 += dataCopy[x + i4] * sg[this.nl + i4];
            }
            sdata[x - this.nl] = sum2;
        }
        for (b = 1; b <= bias; ++b) {
            sg = coeffs[b];
            int x = n - this.nr - bias + (b - 1);
            sum = 0.0;
            for (i = -this.nl; i <= this.nr - b; ++i) {
                sum += dataCopy[x + i] * sg[this.nl + i];
            }
            sdata[x - this.nl] = sum;
        }
        return sdata;
    }

    public double[] smooth(double[] data, int from, int to, double[] coeffs) {
        return this.smooth(data, from, to, 0, (double[][])new double[][]{coeffs});
    }

    public double[] smooth(double[] data, int from, int to, int bias, double[][] coeffs) {
        double[] leftPad = Arrays.copyOfRange(data, 0, from);
        double[] rightPad = Arrays.copyOfRange(data, to, data.length);
        double[] dataCopy = Arrays.copyOfRange(data, from, to);
        return this.smooth(dataCopy, leftPad, rightPad, bias, coeffs);
    }

    public float[] smooth(float[] data, double[] coeffs) {
        return this.smooth(data, 0, data.length, coeffs);
    }

    public float[] smooth(float[] data, float[] leftPad, float[] rightPad, double[] coeffs) {
        return this.smooth(data, leftPad, rightPad, 0, (double[][])new double[][]{coeffs});
    }

    public float[] smooth(float[] data, float[] leftPad, float[] rightPad, int bias, double[][] coeffs) {
        double[] dataAsDouble = new double[data.length];
        double[] leftPadAsDouble = new double[leftPad.length];
        double[] rightPadAsDouble = new double[rightPad.length];
        SGFilter.convertFloatArrayToDouble(data, dataAsDouble);
        SGFilter.convertFloatArrayToDouble(leftPad, leftPadAsDouble);
        SGFilter.convertFloatArrayToDouble(rightPad, rightPadAsDouble);
        double[] results = this.smooth(dataAsDouble, leftPadAsDouble, rightPadAsDouble, bias, coeffs);
        float[] resultsAsFloat = new float[results.length];
        SGFilter.convertDoubleArrayToFloat(results, resultsAsFloat);
        return resultsAsFloat;
    }

    public float[] smooth(float[] data, int from, int to, double[] coeffs) {
        return this.smooth(data, from, to, 0, (double[][])new double[][]{coeffs});
    }

    public float[] smooth(float[] data, int from, int to, int bias, double[][] coeffs) {
        float[] leftPad = Arrays.copyOfRange(data, 0, from);
        float[] rightPad = Arrays.copyOfRange(data, to, data.length);
        float[] dataCopy = Arrays.copyOfRange(data, from, to);
        return this.smooth(dataCopy, leftPad, rightPad, bias, coeffs);
    }
}

