/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.toolsuite.ols.dialog.message;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import uk.ac.ebi.pride.toolsuite.ols.dialog.message.Message;

public class MessageBoard
extends JPanel {
    private final Set<MessagePanel> messagePanels = Collections.synchronizedSet(new HashSet());

    public MessageBoard() {
        this.setLayout(new BoxLayout(this, 1));
    }

    public void showMessage(Message message) {
        MessagePanel panel = new MessagePanel(message);
        this.add(panel);
        this.messagePanels.add(panel);
        this.validateAndPaint();
    }

    public void removeMessage(Message message) {
        Iterator<MessagePanel> iter = this.messagePanels.iterator();
        while (iter.hasNext()) {
            MessagePanel panel = iter.next();
            if (!panel.getMessage().equals(message)) continue;
            this.remove(panel);
            iter.remove();
        }
        this.validateAndPaint();
    }

    public void removeAllMessages() {
        this.removeAll();
        this.messagePanels.clear();
        this.validateAndPaint();
    }

    public void validateAndPaint() {
        this.revalidate();
        this.repaint();
    }

    private static class MessagePanel
    extends JPanel {
        private Message message;

        public MessagePanel(Message message) {
            this.message = message;
            this.setMaximumSize(new Dimension(600, 100));
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray));
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            JPanel container = new JPanel(new BorderLayout());
            container.setOpaque(false);
            container.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JPanel iconPanel = new JPanel(new GridBagLayout());
            iconPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            iconPanel.setOpaque(false);
            JLabel iconLabel = new JLabel();
            iconLabel.setIcon(message.getType().getIcon());
            iconPanel.add(iconLabel);
            container.add((Component)iconPanel, "West");
            JTextPane textPane = new JTextPane();
            textPane.setContentType("text/html");
            textPane.setText(message.getMessage());
            textPane.setEditable(false);
            textPane.setOpaque(false);
            container.add((Component)textPane, "Center");
            this.add((Component)container, "Center");
        }

        public Message getMessage() {
            return this.message;
        }
    }
}

