/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.toolsuite.ols.dialog.prop;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;

public class PropertyManager {
    private final Properties system = new Properties();
    private final Properties user = new Properties();

    public Properties getProperties() {
        Properties results = new Properties();
        results.putAll((Map<?, ?>)this.system);
        results.putAll((Map<?, ?>)this.user);
        return results;
    }

    public void loadSystemProps(InputStream in) throws IOException {
        this.loadProps(this.system, in);
    }

    public void loadUserProps(InputStream in) throws IOException {
        this.loadProps(this.user, in);
    }

    public String getProperty(String name) {
        String value = this.user.getProperty(name);
        if (value != null) {
            return value;
        }
        return this.system.getProperty(name);
    }

    public String getProperty(String name, Object[] args) {
        if (name == null) {
            return null;
        }
        if (args == null) {
            return this.getProperty(name);
        }
        String value = this.getProperty(name);
        if (value == null) {
            return null;
        }
        return MessageFormat.format(value, args);
    }

    public void setProperty(String name, String value) {
        if (this.user.containsKey(name)) {
            this.user.setProperty(name, value);
        } else if (this.system.containsKey(name)) {
            this.system.setProperty(name, value);
        } else {
            this.user.setProperty(name, value);
        }
    }

    private void loadProps(Properties into, InputStream in) throws IOException {
        try {
            into.load(in);
        }
        finally {
            in.close();
        }
    }
}

