/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.toolsuite.ols.dialog.task.impl;

import java.awt.Cursor;
import java.util.List;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import uk.ac.ebi.pride.toolsuite.ols.dialog.OLSDialog;
import uk.ac.ebi.pride.toolsuite.ols.dialog.task.AbstractTask;
import uk.ac.ebi.pride.utilities.ols.web.service.client.OLSClient;
import uk.ac.ebi.pride.utilities.ols.web.service.model.Identifier;
import uk.ac.ebi.pride.utilities.ols.web.service.model.Ontology;
import uk.ac.ebi.pride.utilities.ols.web.service.model.SearchQuery;
import uk.ac.ebi.pride.utilities.ols.web.service.model.SearchResult;

public class TermSearchTask
extends AbstractTask {
    private String ontologyName;
    private Map<String, List<Identifier>> preselectedOntologies;
    private String term;
    private boolean keyReverse;
    private Integer numTerms = 0;
    private static String TASK_NAME = "Search Terms by Name";
    private static int SEARCH_PAGE_SIZE = 100;

    public TermSearchTask(OLSDialog olsDialog, OLSClient olsClient) {
        super(TASK_NAME, olsDialog, olsClient);
    }

    public TermSearchTask(OLSDialog olsDialog, OLSClient olsClient, String term, boolean keyReverse, Map<String, List<Identifier>> preselectedOntologies) {
        super(TASK_NAME, olsDialog, olsClient);
        this.preselectedOntologies = preselectedOntologies;
        this.term = term;
        this.keyReverse = keyReverse;
    }

    public TermSearchTask(OLSDialog olsDialog, OLSClient olsClient, String term, boolean keyReverse) {
        super(TASK_NAME, olsDialog, olsClient);
        this.term = term;
        this.keyReverse = keyReverse;
    }

    public TermSearchTask(OLSDialog olsDialog, OLSClient olsClient, String term, boolean keyReverse, String ontology) {
        super(TASK_NAME, olsDialog, olsClient);
        this.term = term;
        this.keyReverse = keyReverse;
        this.ontologyName = ontology;
    }

    @Override
    protected void done() {
        Integer width = this.olsDialog.getPreferredColumnWidth(this.olsDialog.olsResultsTermNameSearchJTable, this.olsDialog.olsResultsTermNameSearchJTable.getColumn("Accession").getModelIndex(), 6);
        if (width != null) {
            this.olsDialog.olsResultsTermNameSearchJTable.getColumn("Accession").setMinWidth(width);
            this.olsDialog.olsResultsTermNameSearchJTable.getColumn("Accession").setMaxWidth(width);
        } else {
            this.olsDialog.olsResultsTermNameSearchJTable.getColumn("Accession").setMinWidth(15);
            this.olsDialog.olsResultsTermNameSearchJTable.getColumn("Accession").setMaxWidth(Integer.MAX_VALUE);
        }
        this.olsDialog.termNameSearchJTextField.requestFocus();
        this.olsDialog.setCursor(new Cursor(0));
        this.olsDialog.termNameSearchJTextField.setCursor(new Cursor(2));
        this.olsDialog.numberOfTermsTermNameSearchJTextField.setText("" + this.numTerms);
        if (this.olsDialog.olsResultsTermNameSearchJTable.getRowCount() > 0) {
            this.olsDialog.olsResultsTermNameSearchJTable.scrollRectToVisible(this.olsDialog.olsResultsTermNameSearchJTable.getCellRect(0, 0, false));
        }
    }

    @Override
    protected Object doInBackground() throws Exception {
        this.numTerms = 0;
        if (this.preselectedOntologies != null && !this.preselectedOntologies.isEmpty()) {
            for (String preselectedOntology : this.preselectedOntologies.keySet()) {
                this.searchOnOntology(preselectedOntology);
            }
        } else if (this.ontologyName != null) {
            this.searchOnOntology(this.ontologyName);
        } else {
            List ontologies = this.olsClient.getOntologies();
            for (Ontology preselectedOntology : ontologies) {
                this.searchOnOntology(preselectedOntology.getConfig().getPreferredPrefix());
            }
        }
        return null;
    }

    private void searchOnOntology(String preselectedOntology) {
        SearchQuery resultSearch = this.olsClient.getSearchQuery(0, this.term, preselectedOntology.toLowerCase(), false, null, false, SEARCH_PAGE_SIZE);
        int numberPages = resultSearch.getResponse().getNumFound() / SEARCH_PAGE_SIZE;
        if (resultSearch != null && resultSearch.getResponse() != null && resultSearch.getResponse().getSearchResults() != null) {
            this.addResultToTable(resultSearch.getResponse().getSearchResults());
        }
        for (int i = 1; i < numberPages; ++i) {
            resultSearch = this.olsClient.getSearchQuery(i, this.term, preselectedOntology.toLowerCase(), false, null, false, SEARCH_PAGE_SIZE);
            if (resultSearch == null || resultSearch.getResponse() == null || resultSearch.getResponse().getSearchResults() == null) continue;
            this.addResultToTable(resultSearch.getResponse().getSearchResults());
        }
    }

    private void addResultToTable(SearchResult[] searchResults) {
        if (searchResults != null && searchResults.length > 0) {
            for (SearchResult key : searchResults) {
                ((DefaultTableModel)this.olsDialog.olsResultsTermNameSearchJTable.getModel()).addRow(new Object[]{key, key});
            }
            this.numTerms = this.numTerms + searchResults.length;
        }
    }

    @Override
    protected void cancelled() {
    }

    protected void succeed(Object results) {
    }

    @Override
    protected void finished() {
    }

    @Override
    protected void interrupted(InterruptedException iex) {
    }
}

