/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.toolsuite.ols.dialog.taskmanager;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import uk.ac.ebi.pride.toolsuite.ols.dialog.OLSDialog;
import uk.ac.ebi.pride.toolsuite.ols.dialog.message.MessageBoard;
import uk.ac.ebi.pride.toolsuite.ols.dialog.message.ThrowableEntry;
import uk.ac.ebi.pride.toolsuite.ols.dialog.message.ThrowableHandler;

public class NotificationDialog
extends JDialog
implements PropertyChangeListener,
ActionListener {
    private static final String NOTIFICATION_DIALOG_TITLE = "Notifications";
    private static final String CLEAR_ALL = "Clear All";
    private MessageBoard messageBoard;
    private OLSDialog olsDialog;

    public NotificationDialog(OLSDialog olsDialog) {
        super((Dialog)olsDialog, NOTIFICATION_DIALOG_TITLE);
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(570, 400));
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.messageBoard = new MessageBoard();
        this.messageBoard.setBackground(Color.white);
        JScrollPane scrollPane = new JScrollPane(this.messageBoard, 20, 30);
        mainPanel.add((Component)scrollPane, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton clearButton = new JButton(CLEAR_ALL);
        clearButton.addActionListener(this);
        buttonPanel.add(clearButton);
        mainPanel.add((Component)buttonPanel, "South");
        this.add((Component)mainPanel, "Center");
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d.width - this.getWidth()) / 2, (d.height - this.getHeight()) / 2);
        ThrowableHandler handler = olsDialog.getThrowableHandler();
        handler.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        block3: {
            List newValues;
            List oldValues;
            String eventName;
            block2: {
                eventName = evt.getPropertyName();
                oldValues = (List)evt.getOldValue();
                newValues = (List)evt.getNewValue();
                if (!"ADD_THROWABLE_PROP".equals(eventName)) break block2;
                newValues.removeAll(oldValues);
                for (ThrowableEntry newValue : newValues) {
                    this.messageBoard.showMessage(newValue);
                }
                break block3;
            }
            if (!"REMOVE_THROWABLE_PROP".equals(eventName)) break block3;
            oldValues.removeAll(newValues);
            for (ThrowableEntry oldValue : oldValues) {
                this.messageBoard.removeMessage(oldValue);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(CLEAR_ALL)) {
            this.olsDialog.removeAllThrowableEntries();
        }
    }
}

