/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.toolsuite.ols.dialog.util;

import java.awt.Color;
import java.awt.Component;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class MyComboBoxRenderer
extends BasicComboBoxRenderer {
    private Vector tooltips;
    private int align;

    public MyComboBoxRenderer(Vector tooltips, int align) {
        this.tooltips = tooltips;
        this.align = align;
    }

    public void setToolTips(Vector tooltips) {
        this.tooltips = tooltips;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel lbl = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (isSelected) {
            lbl.setBackground(list.getSelectionBackground());
            lbl.setForeground(list.getSelectionForeground());
            if (this.tooltips != null) {
                if (-1 < index && index < this.tooltips.size()) {
                    if (this.tooltips.get(index) != null) {
                        String toolTip = (String)this.tooltips.get(index);
                        StringTokenizer tok = new StringTokenizer(toolTip);
                        StringBuilder temp = new StringBuilder();
                        StringBuilder temp2 = new StringBuilder();
                        while (tok.hasMoreTokens()) {
                            temp.append(tok.nextToken()).append(" ");
                            if (temp.length() <= 40) continue;
                            temp2.append((CharSequence)temp).append("<br>");
                            temp = new StringBuilder();
                        }
                        if (temp.length() > 0) {
                            temp2.append((CharSequence)temp);
                        }
                        list.setToolTipText("<html>" + temp2 + "</html>");
                    } else {
                        list.setToolTipText(null);
                    }
                }
            } else {
                list.setToolTipText(null);
            }
        } else {
            lbl.setBackground(Color.WHITE);
        }
        lbl.setFont(list.getFont());
        lbl.setText(value == null ? "" : value.toString());
        if (("" + value).length() < 80) {
            lbl.setHorizontalAlignment(this.align);
        } else {
            lbl.setHorizontalAlignment(10);
        }
        return lbl;
    }
}

