/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.ddl.impl;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.ddl.DriverSpecificationFactory;
import org.netbeans.lib.ddl.impl.SpecificationFactory;

public class DriverSpecification {
    private Map<Integer, String> desc;
    private String catalog;
    private String schema;
    private DatabaseMetaData dmd;
    private ResultSet rs;
    private String quoteString;
    SpecificationFactory factory;

    public DriverSpecification(Map<Integer, String> description) {
        this.desc = description;
        this.quoteString = null;
    }

    public DriverSpecificationFactory getDriverSpecificationFactory() {
        return this.factory;
    }

    public void setDriverSpecificationFactory(DriverSpecificationFactory fac) {
        this.factory = (SpecificationFactory)fac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCatalog(String catalog) {
        if (catalog == null || this.dmd == null) {
            this.catalog = catalog;
            return;
        }
        catalog = catalog.trim();
        ResultSet result = null;
        LinkedList<String> list = new LinkedList<String>();
        try {
            result = this.dmd.getCatalogs();
            while (result.next()) {
                String candidate = result.getString(1);
                if (candidate == null) continue;
                list.add(candidate.trim());
            }
            result.close();
        }
        catch (SQLException exc) {
            Logger.getLogger("global").log(Level.INFO, null, exc);
            this.catalog = null;
            return;
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (Exception ex) {}
        }
        this.catalog = list.contains(catalog) ? catalog : null;
    }

    public String getCatalog() {
        return this.catalog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSchema(String schema) {
        if (schema == null || this.dmd == null) {
            this.schema = schema;
            return;
        }
        schema = schema.trim();
        ResultSet result = null;
        LinkedList<String> list = new LinkedList<String>();
        try {
            result = this.dmd.getSchemas();
            while (result.next()) {
                String candidate = result.getString(1);
                if (candidate == null) continue;
                list.add(candidate.trim());
            }
        }
        catch (SQLException exc) {
            Logger.getLogger("global").log(Level.INFO, null, exc);
            this.schema = null;
            return;
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (Exception ex) {}
        }
        this.schema = list.contains(schema) ? schema : null;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setMetaData(DatabaseMetaData dmd) {
        this.dmd = dmd;
    }

    public DatabaseMetaData getMetaData() {
        return this.dmd;
    }

    public void getTables(String tableNamePattern, String[] types) throws SQLException {
        try {
            this.rs = this.dmd.getTables(this.catalog, this.schema, tableNamePattern, types);
        }
        catch (SQLException exc) {
            this.rs = null;
            throw exc;
        }
    }

    public void getProcedures(String procedureNamePattern) throws SQLException {
        try {
            procedureNamePattern = this.quoteString(procedureNamePattern);
            this.rs = this.dmd.getProcedures(this.catalog, this.schema, procedureNamePattern);
        }
        catch (SQLException exc) {
            this.rs = null;
            throw exc;
        }
    }

    public void getPrimaryKeys(String table) throws SQLException {
        try {
            table = this.quoteString(table);
            this.rs = this.dmd.getPrimaryKeys(this.catalog, this.schema, table);
        }
        catch (SQLException exc) {
            this.rs = null;
            throw exc;
        }
    }

    public void getIndexInfo(String table, boolean unique, boolean approximate) throws SQLException {
        try {
            table = this.quoteString(table);
            this.rs = this.dmd.getIndexInfo(this.catalog, this.schema, table, unique, approximate);
        }
        catch (SQLException exc) {
            this.rs = null;
            throw exc;
        }
    }

    public void getColumns(String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            tableNamePattern = this.quoteString(tableNamePattern);
            columnNamePattern = this.quoteString(columnNamePattern);
            this.rs = this.dmd.getColumns(this.catalog, this.schema, tableNamePattern, columnNamePattern);
        }
        catch (SQLException exc) {
            this.rs = null;
            throw exc;
        }
    }

    public void getProcedureColumns(String procedureNamePattern, String columnNamePattern) throws SQLException {
        try {
            procedureNamePattern = this.quoteString(procedureNamePattern);
            columnNamePattern = this.quoteString(columnNamePattern);
            this.rs = this.dmd.getProcedureColumns(this.catalog, this.schema, procedureNamePattern, columnNamePattern);
        }
        catch (SQLException exc) {
            this.rs = null;
            throw exc;
        }
    }

    public void getExportedKeys(String table) throws SQLException {
        try {
            table = this.quoteString(table);
            this.rs = this.dmd.getExportedKeys(this.catalog, this.schema, table);
        }
        catch (SQLException exc) {
            this.rs = null;
            throw exc;
        }
    }

    public void getImportedKeys(String table) throws SQLException {
        try {
            table = this.quoteString(table);
            this.rs = this.dmd.getImportedKeys(this.catalog, this.schema, table);
        }
        catch (SQLException exc) {
            this.rs = null;
            throw exc;
        }
    }

    public ResultSet getResultSet() {
        return this.rs;
    }

    public Map<Integer, String> getRow() throws SQLException {
        HashMap<Integer, String> rset = new HashMap<Integer, String>();
        try {
            int count = this.rs.getMetaData().getColumnCount();
            for (int i = 1; i <= count; ++i) {
                String value = null;
                try {
                    value = this.rs.getString(i);
                }
                catch (SQLException exc) {
                    rset = null;
                    throw exc;
                }
                rset.put(new Integer(i), value);
            }
        }
        catch (SQLException exc) {
            rset = null;
            throw exc;
        }
        return rset;
    }

    public boolean areViewsSupported() {
        try {
            String productName = this.dmd.getDatabaseProductName().trim();
            if ("PointBase".equals(productName)) {
                int driverMajorVersion = this.dmd.getDriverMajorVersion();
                int driverMinorVersion = this.dmd.getDriverMinorVersion();
                return driverMajorVersion == 4 && driverMinorVersion >= 1 || driverMajorVersion > 4;
            }
            if ("MySQL".equals(productName)) {
                int databaseMajorVersion = this.dmd.getDatabaseMajorVersion();
                return databaseMajorVersion >= 5;
            }
            if ("HypersonicSQL".equals(productName)) {
                return false;
            }
        }
        catch (SQLException exc) {
            Logger.getLogger("global").log(Level.INFO, null, exc);
        }
        return true;
    }

    private String getQuoteString() {
        if (this.quoteString == null) {
            try {
                this.quoteString = this.dmd.getIdentifierQuoteString();
                if (this.quoteString == null || this.quoteString.equals(" ")) {
                    this.quoteString = "";
                } else {
                    this.quoteString.trim();
                }
            }
            catch (SQLException exc) {
                this.quoteString = "";
            }
        }
        return this.quoteString;
    }

    private String quoteString(String str) {
        try {
            if (this.dmd.getDatabaseProductName().trim().equals("PointBase")) {
                String quoteStr = this.getQuoteString();
                if (str != null && !str.equals("%") && !quoteStr.isEmpty()) {
                    str = quoteStr + str + quoteStr;
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return str;
    }

    public String getDBName() {
        try {
            return this.dmd.getDatabaseProductName().trim();
        }
        catch (SQLException exc) {
            return null;
        }
    }
}

