/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.ms.algo;

import fr.profi.chemistry.model.AbundanceMapOps$;
import fr.profi.chemistry.model.Atom;
import fr.profi.chemistry.model.AtomComposition;
import fr.profi.chemistry.model.AtomIsotopeComposition;
import fr.profi.chemistry.model.AtomIsotopicVariant;
import fr.profi.ms.algo.IsotopeDistributionComputer$;
import fr.profi.ms.algo.IsotopeDistributionComputer$$anonfun$fr$profi$ms$algo$IsotopeDistributionComputer$;
import fr.profi.ms.model.IsotopeCombination;
import fr.profi.ms.model.IsotopeDistribution;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class IsotopeDistributionComputer$ {
    public static final IsotopeDistributionComputer$ MODULE$;
    private final int TARGETED_ATOM_COUNT_INCREMENT;

    static {
        new IsotopeDistributionComputer$();
    }

    public final int TARGETED_ATOM_COUNT_INCREMENT() {
        return 1024;
    }

    public IsotopeDistribution computeIsotopeDistribution(AtomComposition compoundAtomComposition, int charge, Map<Tuple2<Atom, Object>, IsotopeCombination[]> isotopeCombinationMap, float minProba) {
        HashMap<Atom, Object> compoundAtomCountByAtom = compoundAtomComposition.abundanceMap();
        Atom[] atoms = (Atom[])Predef$.MODULE$.refArrayOps((Object[])compoundAtomCountByAtom.keys().toArray(ClassTag$.MODULE$.apply(Atom.class))).sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Atom x$1) {
                return x$1.symbol();
            }
        }, (Ordering)Ordering.String$.MODULE$);
        IsotopeCombination emptyCombination = new IsotopeCombination((Map<AtomIsotopicVariant, Object>)Predef$.MODULE$.Map().empty(), 1.0);
        ArrayBuffer computedCombinations = new ArrayBuffer();
        this.fr$profi$ms$algo$IsotopeDistributionComputer$$_combineIsotopeCombinations((ArrayBuffer<IsotopeCombination>)computedCombinations, emptyCombination, compoundAtomCountByAtom, isotopeCombinationMap, atoms, minProba);
        Predef$.MODULE$.require(!computedCombinations.isEmpty(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "can't find an appropriate isotope combination";
            }
        });
        return new IsotopeDistribution((IsotopeCombination[])computedCombinations.toArray(ClassTag$.MODULE$.apply(IsotopeCombination.class)), charge);
    }

    public float computeIsotopeDistribution$default$4() {
        return 0.0f;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fr$profi$ms$algo$IsotopeDistributionComputer$$_combineIsotopeCombinations(ArrayBuffer<IsotopeCombination> computedCombinations, IsotopeCombination lastCombination, HashMap<Atom, Object> compoundAtomCountByAtom, Map<Tuple2<Atom, Object>, IsotopeCombination[]> isotopeCombinationMap, Atom[] atoms, float minProba) {
        if (Predef$.MODULE$.refArrayOps((Object[])atoms).isEmpty()) {
            IsotopeDistributionComputer$ isotopeDistributionComputer$ = this;
            synchronized (isotopeDistributionComputer$) {
                computedCombinations.$plus$eq((Object)lastCombination);
                return;
            }
        }
        Atom curAtom = (Atom)Predef$.MODULE$.refArrayOps((Object[])atoms).head();
        float curAtomCount = BoxesRunTime.unboxToFloat((Object)compoundAtomCountByAtom.apply((Object)curAtom));
        Atom[] remainingAtoms = (Atom[])Predef$.MODULE$.refArrayOps((Object[])atoms).tail();
        Option matchingIsotopeCombinationsOpt = isotopeCombinationMap.get((Object)new Tuple2((Object)curAtom, (Object)BoxesRunTime.boxToFloat((float)curAtomCount)));
        Predef$.MODULE$.require(matchingIsotopeCombinationsOpt.isDefined(), (Function0)new Serializable(curAtom, curAtomCount){
            public static final long serialVersionUID = 0L;
            private final Atom curAtom$1;
            private final float curAtomCount$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"provided computedCombinations has no entry for atom ", " with abundance ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.curAtom$1.symbol(), BoxesRunTime.boxToFloat((float)this.curAtomCount$1)}));
            }
            {
                this.curAtom$1 = curAtom$1;
                this.curAtomCount$1 = curAtomCount$1;
            }
        });
        IsotopeCombination[] matchingIsotopeCombinations = (IsotopeCombination[])matchingIsotopeCombinationsOpt.get();
        if (Predef$.MODULE$.refArrayOps((Object[])matchingIsotopeCombinations).isEmpty()) {
            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"can't find a combination for #", " atom of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)curAtomCount), curAtom})));
        }
        double lastProb = lastCombination.probability();
        IsotopeCombination[] filteredIsotopesCombinations = (IsotopeCombination[])Predef$.MODULE$.refArrayOps((Object[])matchingIsotopeCombinations).filter((Function1)new Serializable(minProba, lastProb){
            public static final long serialVersionUID = 0L;
            private final float minProba$1;
            private final double lastProb$1;

            public final boolean apply(IsotopeCombination x$2) {
                return x$2.probability() * this.lastProb$1 >= (double)this.minProba$1;
            }
            {
                this.minProba$1 = minProba$1;
                this.lastProb$1 = lastProb$1;
            }
        });
        IsotopeCombination[] finalIsotopesCombinations = Predef$.MODULE$.refArrayOps((Object[])filteredIsotopesCombinations).isEmpty() ? (IsotopeCombination[])((Object[])new IsotopeCombination[]{(IsotopeCombination)Predef$.MODULE$.refArrayOps((Object[])matchingIsotopeCombinations).maxBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(IsotopeCombination x$3) {
                return x$3.probability();
            }
        }, (Ordering)Ordering.Double$.MODULE$)}) : matchingIsotopeCombinations;
        Predef$.MODULE$.refArrayOps((Object[])finalIsotopesCombinations).foreach((Function1)new Serializable(computedCombinations, lastCombination, compoundAtomCountByAtom, isotopeCombinationMap, minProba, remainingAtoms){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer computedCombinations$1;
            private final IsotopeCombination lastCombination$1;
            private final HashMap compoundAtomCountByAtom$1;
            private final Map isotopeCombinationMap$1;
            private final float minProba$1;
            private final Atom[] remainingAtoms$1;

            public final void apply(IsotopeCombination isotopeCombination) {
                double newProbability = this.lastCombination$1.probability() * isotopeCombination.probability();
                HashMap<AtomIsotopicVariant, Object> newAbundanceMap = this.lastCombination$1.getCloneOfMutableAbundanceMap();
                AbundanceMapOps$.MODULE$.addAbundanceMap(newAbundanceMap, isotopeCombination.abundanceMap());
                IsotopeCombination newCombination = new IsotopeCombination((Map<AtomIsotopicVariant, Object>)newAbundanceMap.toMap(Predef$.MODULE$.$conforms()), newProbability);
                IsotopeDistributionComputer$.MODULE$.fr$profi$ms$algo$IsotopeDistributionComputer$$_combineIsotopeCombinations((ArrayBuffer<IsotopeCombination>)this.computedCombinations$1, newCombination, (HashMap<Atom, Object>)this.compoundAtomCountByAtom$1, (Map<Tuple2<Atom, Object>, IsotopeCombination[]>)this.isotopeCombinationMap$1, this.remainingAtoms$1, this.minProba$1);
            }
            {
                this.computedCombinations$1 = computedCombinations$1;
                this.lastCombination$1 = lastCombination$1;
                this.compoundAtomCountByAtom$1 = compoundAtomCountByAtom$1;
                this.isotopeCombinationMap$1 = isotopeCombinationMap$1;
                this.minProba$1 = minProba$1;
                this.remainingAtoms$1 = remainingAtoms$1;
            }
        });
    }

    private float _combineIsotopeCombinations$default$6() {
        return 0.0f;
    }

    public Map<Tuple2<Atom, Object>, IsotopeCombination[]> computeIsotopicVariantCombinations(Map<Atom, Object> maxAtomCountByAtom, float minProba) {
        Builder mapBuilder = Predef$.MODULE$.Map().newBuilder();
        maxAtomCountByAtom.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Atom, Object> check$ifrefutable$1) {
                Tuple2<Atom, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(minProba, mapBuilder){
            public static final long serialVersionUID = 0L;
            private final float minProba$2;
            public final Builder mapBuilder$1;

            public final void apply(Tuple2<Atom, Object> x$6) {
                Tuple2<Atom, Object> tuple2 = x$6;
                if (tuple2 != null) {
                    Atom atom = (Atom)tuple2._1();
                    int maxAtomCount = tuple2._2$mcI$sp();
                    IsotopeCombination[] isotopeCombinations = IsotopeDistributionComputer$.MODULE$.computeAtomIsotopicVariantCombinations(atom, maxAtomCount, this.minProba$2);
                    Predef$.MODULE$.refArrayOps((Object[])isotopeCombinations).groupBy((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final float apply(IsotopeCombination x$4) {
                            return x$4.atomCount();
                        }
                    }).withFilter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<Object, IsotopeCombination[]> check$ifrefutable$2) {
                            Tuple2<Object, IsotopeCombination[]> tuple2 = check$ifrefutable$2;
                            boolean bl = tuple2 != null;
                            return bl;
                        }
                    }).foreach((Function1)new Serializable(this, atom){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.computeIsotopicVariantCombinations.2 $outer;
                        private final Atom atom$1;

                        public final Builder<Tuple2<Tuple2<Atom, Object>, IsotopeCombination[]>, Map<Tuple2<Atom, Object>, IsotopeCombination[]>> apply(Tuple2<Object, IsotopeCombination[]> x$5) {
                            Tuple2<Object, IsotopeCombination[]> tuple2 = x$5;
                            if (tuple2 != null) {
                                float atomCount = BoxesRunTime.unboxToFloat((Object)tuple2._1());
                                IsotopeCombination[] combinations = (IsotopeCombination[])tuple2._2();
                                Builder builder = this.$outer.mapBuilder$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)this.atom$1, (Object)BoxesRunTime.boxToFloat((float)atomCount))), (Object)combinations));
                                return builder;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.atom$1 = atom$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.minProba$2 = minProba$2;
                this.mapBuilder$1 = mapBuilder$1;
            }
        });
        return (Map)mapBuilder.result();
    }

    public float computeIsotopicVariantCombinations$default$2() {
        return 0.0f;
    }

    public IsotopeCombination[] computeAtomIsotopicVariantCombinations(Atom atom, int maxAtomCount, float minProba) {
        Predef$.MODULE$.require(maxAtomCount >= 1, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "maxAtomCount must be >= 1";
            }
        });
        Predef$.MODULE$.require(minProba >= 0.0f && minProba <= 1.0f, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "minProba must be a number between 0 and 1";
            }
        });
        AtomIsotopicVariant[] atomIsotopes = atom.isotopicVariants();
        HashMap computedCombinationByFormula = new HashMap();
        computedCombinationByFormula.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)new IsotopeCombination((Map<AtomIsotopicVariant, Object>)Predef$.MODULE$.Map().empty(), 1.0)));
        this._computeIsotopicVariantCombinations((HashMap<String, IsotopeCombination>)computedCombinationByFormula, atomIsotopes, 0, maxAtomCount, minProba);
        return (IsotopeCombination[])computedCombinationByFormula.values().toArray(ClassTag$.MODULE$.apply(IsotopeCombination.class));
    }

    public float computeAtomIsotopicVariantCombinations$default$3() {
        return 0.0f;
    }

    private void _computeIsotopicVariantCombinations(HashMap<String, IsotopeCombination> computedCombinationByFormula, AtomIsotopicVariant[] atomIsotopes, int lastTargetedAtomCount, int maxAtomCount, float minProba) {
        while (lastTargetedAtomCount != maxAtomCount) {
            int curTargetedAtomCount = package$.MODULE$.min(lastTargetedAtomCount + 1024, maxAtomCount);
            computedCombinationByFormula.par().foreach((Function1)new Serializable(computedCombinationByFormula, atomIsotopes, lastTargetedAtomCount, minProba, curTargetedAtomCount){
                public static final long serialVersionUID = 0L;
                private final HashMap computedCombinationByFormula$1;
                private final AtomIsotopicVariant[] atomIsotopes$1;
                private final int lastTargetedAtomCount$1;
                private final float minProba$3;
                private final int curTargetedAtomCount$1;

                public final void apply(Tuple2<String, IsotopeCombination> computedCombination) {
                    Tuple2<String, IsotopeCombination> tuple2 = computedCombination;
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        String formula = (String)tuple2._1();
                        IsotopeCombination combination = (IsotopeCombination)tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)formula, (Object)combination);
                        String formula2 = (String)tuple23._1();
                        IsotopeCombination combination2 = (IsotopeCombination)tuple23._2();
                        if (combination2.atomCount() == (float)this.lastTargetedAtomCount$1) {
                            IsotopeDistributionComputer$.MODULE$.fr$profi$ms$algo$IsotopeDistributionComputer$$_createNewIsotopeCombinations((HashMap<String, IsotopeCombination>)this.computedCombinationByFormula$1, (Seq<IsotopeCombination>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IsotopeCombination[]{combination2}))), this.atomIsotopes$1, this.curTargetedAtomCount$1, this.minProba$3);
                        }
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.computedCombinationByFormula$1 = computedCombinationByFormula$1;
                    this.atomIsotopes$1 = atomIsotopes$1;
                    this.lastTargetedAtomCount$1 = lastTargetedAtomCount$1;
                    this.minProba$3 = minProba$3;
                    this.curTargetedAtomCount$1 = curTargetedAtomCount$1;
                }
            });
            lastTargetedAtomCount = curTargetedAtomCount;
        }
        return;
    }

    public void fr$profi$ms$algo$IsotopeDistributionComputer$$_createNewIsotopeCombinations(HashMap<String, IsotopeCombination> computedCombinationByFormula, Seq<IsotopeCombination> lastCombinations, AtomIsotopicVariant[] atomIsotopes, int targetedAtomCount, float minProba) {
        while (!lastCombinations.isEmpty()) {
            ArrayBuffer newCombinationsBuffers = new ArrayBuffer(atomIsotopes.length);
            lastCombinations.foreach((Function1)new Serializable(computedCombinationByFormula, atomIsotopes, targetedAtomCount, minProba, newCombinationsBuffers){
                public static final long serialVersionUID = 0L;
                public final HashMap computedCombinationByFormula$2;
                private final AtomIsotopicVariant[] atomIsotopes$2;
                private final int targetedAtomCount$1;
                public final float minProba$4;
                public final ArrayBuffer newCombinationsBuffers$1;

                public final void apply(IsotopeCombination lastCombination) {
                    float atomCount = lastCombination.atomCount();
                    if (atomCount < (float)this.targetedAtomCount$1) {
                        Map<AtomIsotopicVariant, Object> lastAbundanceMap = lastCombination.abundanceMap();
                        Predef$.MODULE$.refArrayOps((Object[])this.atomIsotopes$2).foreach((Function1)new Serializable(this, atomCount, lastAbundanceMap, lastCombination){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$fr$profi$ms$algo$IsotopeDistributionComputer$$_createNewIsotopeCombinations$1 $outer;
                            private final float atomCount$1;
                            private final Map lastAbundanceMap$1;
                            private final IsotopeCombination lastCombination$2;

                            /*
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            public final Object apply(AtomIsotopicVariant atomIsotope) {
                                BoxedUnit boxedUnit;
                                HashMap newAbundanceMap = new HashMap();
                                newAbundanceMap.$plus$plus$eq((TraversableOnce)this.lastAbundanceMap$1);
                                newAbundanceMap.getOrElseUpdate((Object)atomIsotope, (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final float apply() {
                                        return this.apply$mcF$sp();
                                    }

                                    public float apply$mcF$sp() {
                                        return 0.0f;
                                    }
                                });
                                newAbundanceMap.update((Object)atomIsotope, (Object)BoxesRunTime.boxToFloat((float)(BoxesRunTime.unboxToFloat((Object)newAbundanceMap.apply((Object)atomIsotope)) + 1.0f)));
                                String formula = new AtomIsotopeComposition((HashMap<AtomIsotopicVariant, Object>)newAbundanceMap).toFormula();
                                if (this.$outer.computedCombinationByFormula$2.contains((Object)formula)) {
                                    boxedUnit = BoxedUnit.UNIT;
                                    return boxedUnit;
                                }
                                float newIsotopeCount = BoxesRunTime.unboxToFloat((Object)newAbundanceMap.apply((Object)atomIsotope));
                                float newAtomCount = this.atomCount$1 + 1.0f;
                                double newProba = this.lastCombination$2.probability() * (double)atomIsotope.isotope().abundance() * (double)newAtomCount / (double)newIsotopeCount;
                                if (!(newProba >= (double)this.$outer.minProba$4)) {
                                    boxedUnit = BoxedUnit.UNIT;
                                    return boxedUnit;
                                }
                                IsotopeCombination newCombination = new IsotopeCombination((Map<AtomIsotopicVariant, Object>)newAbundanceMap.toMap(Predef$.MODULE$.$conforms()), newProba);
                                IsotopeDistributionComputer$ isotopeDistributionComputer$ = IsotopeDistributionComputer$.MODULE$;
                                synchronized (isotopeDistributionComputer$) {
                                    this.$outer.computedCombinationByFormula$2.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)formula), (Object)newCombination));
                                }
                                boxedUnit = this.$outer.newCombinationsBuffers$1.$plus$eq((Object)newCombination);
                                return boxedUnit;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.atomCount$1 = atomCount$1;
                                this.lastAbundanceMap$1 = lastAbundanceMap$1;
                                this.lastCombination$2 = lastCombination$2;
                            }
                        });
                    }
                }
                {
                    this.computedCombinationByFormula$2 = computedCombinationByFormula$2;
                    this.atomIsotopes$2 = atomIsotopes$2;
                    this.targetedAtomCount$1 = targetedAtomCount$1;
                    this.minProba$4 = minProba$4;
                    this.newCombinationsBuffers$1 = newCombinationsBuffers$1;
                }
            });
            lastCombinations = newCombinationsBuffers;
        }
        return;
    }

    private IsotopeDistributionComputer$() {
        MODULE$ = this;
    }
}

