/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.ms.algo;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.ms.algo.IsotopePatternInterpolator$;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.immutable.TreeMap;
import scala.collection.immutable.TreeMap$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Builder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;

public final class IsotopePatternInterpolator$
implements LazyLogging {
    public static final IsotopePatternInterpolator$ MODULE$;
    private final String LOOKUP_TABLE_URL;
    private final double avgIsoMassDiff;
    private final TreeMap<Object, int[]> lookupTable;
    private final int[] lookupTableMasses;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new IsotopePatternInterpolator$();
    }

    private Logger logger$lzycompute() {
        IsotopePatternInterpolator$ isotopePatternInterpolator$ = this;
        synchronized (isotopePatternInterpolator$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public final String LOOKUP_TABLE_URL() {
        return "/lookup_table.txt";
    }

    public final double avgIsoMassDiff() {
        return 1.0027;
    }

    public TreeMap<Object, int[]> lookupTable() {
        return this.lookupTable;
    }

    public int[] lookupTableMasses() {
        return this.lookupTableMasses;
    }

    public TheoreticalIsotopePattern getTheoreticalPattern(double mz, int charge) {
        int idx;
        Tuple2.mcII.sp sp2;
        Predef$.MODULE$.require(charge > 0, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "charge must be greater than zero";
            }
        });
        int[] keys = this.lookupTableMasses();
        DoubleRef mass = DoubleRef.create((double)fr.profi.util.ms.package$.MODULE$.mozToMass(mz, charge));
        if (mass.elem > (double)BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(keys).last())) {
            mass.elem = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(keys).last());
        }
        if ((sp2 = new Tuple2.mcII.sp(keys[(idx = Predef$.MODULE$.intArrayOps(keys).indexWhere((Function1)new Serializable(mass){
            public static final long serialVersionUID = 0L;
            private final DoubleRef mass$1;

            public final boolean apply(int x$2) {
                return this.apply$mcZI$sp(x$2);
            }

            public boolean apply$mcZI$sp(int x$2) {
                return (double)x$2 >= this.mass$1.elem;
            }
            {
                this.mass$1 = mass$1;
            }
        })) - 1], keys[idx])) != null) {
            Tuple2.mcII.sp sp3;
            int x1 = sp2._1$mcI$sp();
            int x2 = sp2._2$mcI$sp();
            Tuple2.mcII.sp sp4 = sp3 = new Tuple2.mcII.sp(x1, x2);
            int x12 = sp4._1$mcI$sp();
            int x22 = sp4._2$mcI$sp();
            Tuple2 tuple2 = new Tuple2(this.lookupTable().apply((Object)BoxesRunTime.boxToInteger((int)x12)), this.lookupTable().apply((Object)BoxesRunTime.boxToInteger((int)x22)));
            if (tuple2 != null) {
                Tuple2 tuple22;
                int[] minArray = (int[])tuple2._1();
                int[] maxArray = (int[])tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)minArray, (Object)maxArray);
                int[] minArray2 = (int[])tuple23._1();
                int[] maxArray2 = (int[])tuple23._2();
                ArrayBuffer mzIntPairs = new ArrayBuffer(minArray2.length);
                for (int i = 0; i < minArray2.length; ++i) {
                    Tuple2.mcII.sp sp5 = new Tuple2.mcII.sp(minArray2[i], maxArray2[i]);
                    if (sp5 != null) {
                        BoxedUnit boxedUnit;
                        Tuple2.mcII.sp sp6;
                        int y1 = sp5._1$mcI$sp();
                        int y2 = sp5._2$mcI$sp();
                        Tuple2.mcII.sp sp7 = sp6 = new Tuple2.mcII.sp(y1, y2);
                        int y12 = sp7._1$mcI$sp();
                        int y22 = sp7._2$mcI$sp();
                        if (y12 > 0 || y22 > 0) {
                            Tuple2 tuple24 = fr.profi.util.math.package$.MODULE$.calcLineParams((double)x12, (double)y12, (double)x22, (double)y22);
                            if (tuple24 != null) {
                                Tuple2.mcDD.sp sp8;
                                double slope = tuple24._1$mcD$sp();
                                double intercept = tuple24._2$mcD$sp();
                                Tuple2.mcDD.sp sp9 = sp8 = new Tuple2.mcDD.sp(slope, intercept);
                                double slope2 = sp9._1$mcD$sp();
                                double intercept2 = sp9._2$mcD$sp();
                                float abundance = (float)(slope2 * mass.elem + intercept2);
                                double isoMz = mz + (double)i * 1.0027 / (double)charge;
                                boxedUnit = mzIntPairs.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)isoMz)), (Object)BoxesRunTime.boxToFloat((float)abundance)));
                                continue;
                            }
                            throw new MatchError((Object)tuple24);
                        }
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    throw new MatchError((Object)sp5);
                }
                return new TheoreticalIsotopePattern((Tuple2[])mzIntPairs.toArray(ClassTag$.MODULE$.apply(Tuple2.class)), charge);
            }
            throw new MatchError((Object)tuple2);
        }
        throw new MatchError((Object)sp2);
    }

    public double calcAbundancesRmsd(float[] theoInt, float[] obsInt) {
        float maxObsInt = BoxesRunTime.unboxToFloat((Object)Predef$.MODULE$.floatArrayOps(obsInt).max((Ordering)Ordering.Float$.MODULE$));
        float[] scaledInt = (float[])Predef$.MODULE$.floatArrayOps(obsInt).map((Function1)new Serializable(maxObsInt){
            public static final long serialVersionUID = 0L;
            private final float maxObsInt$1;

            public final float apply(float x$7) {
                return this.apply$mcFF$sp(x$7);
            }

            public float apply$mcFF$sp(float x$7) {
                return x$7 * (float)100 / this.maxObsInt$1;
            }
            {
                this.maxObsInt$1 = maxObsInt$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
        double s = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.floatArrayOps(theoInt).zip((GenIterable)Predef$.MODULE$.wrapFloatArray(scaledInt), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double s, Tuple2<Object, Object> ab) {
                return s + package$.MODULE$.pow((double)(BoxesRunTime.unboxToFloat((Object)ab._1()) - BoxesRunTime.unboxToFloat((Object)ab._2())), 2.0);
            }
        }));
        return package$.MODULE$.sqrt(s);
    }

    private IsotopePatternInterpolator$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        ArrayBuffer rows = new ArrayBuffer();
        Source$.MODULE$.fromURL(this.getClass().getResource("/lookup_table.txt"), Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1)new anonfun.4(rows));
        int maxIsotopesCount = ((int[])rows.last()).length - 1;
        Builder tableBuilder = TreeMap$.MODULE$.newBuilder((Ordering)Ordering.Int$.MODULE$);
        rows.foreach((Function1)new anonfun.5(maxIsotopesCount, tableBuilder));
        this.lookupTable = (TreeMap)tableBuilder.result();
        this.lookupTableMasses = (int[])this.lookupTable().keys().toArray(ClassTag$.MODULE$.Int());
    }
}

