/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.api.sql.execute;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.api.sql.execute.LogFileLogger;
import org.netbeans.modules.db.api.sql.execute.SQLExecuteLogger;
import org.netbeans.modules.db.api.sql.execute.SQLExecutionInfo;
import org.netbeans.modules.db.api.sql.execute.StatementExecutionInfo;
import org.netbeans.modules.db.sql.execute.SQLExecuteHelper;
import org.netbeans.modules.db.sql.execute.SQLExecutionLogger;
import org.netbeans.modules.db.sql.execute.SQLExecutionResult;
import org.netbeans.modules.db.sql.execute.SQLExecutionResults;

public class SQLExecutor {
    private static Logger LOGGER = Logger.getLogger(SQLExecutor.class.getName());

    public static SQLExecutionInfo execute(DatabaseConnection dbconn, String sql) throws DatabaseException {
        return SQLExecutor.execute(dbconn, sql, new LogFileLogger());
    }

    public static SQLExecutionInfo execute(DatabaseConnection dbconn, String sql, SQLExecuteLogger logger) throws DatabaseException {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("You can not run this method on the event dispatching thread.");
        }
        if (logger == null) {
            throw new NullPointerException();
        }
        if (dbconn == null) {
            throw new IllegalArgumentException("The connection parameter cannot be null");
        }
        Connection conn = dbconn.getJDBCConnection(true);
        if (conn == null) {
            throw new DatabaseException("The connection is not open");
        }
        SQLExecutionResults results = SQLExecuteHelper.execute(sql, 0, sql.length(), dbconn, new LoggerProxy(logger));
        return new SQLExecutionInfoImpl(results);
    }

    private static class LoggerProxy
    implements SQLExecutionLogger {
        private final SQLExecuteLogger delegate;

        public LoggerProxy(SQLExecuteLogger delegate) {
            this.delegate = delegate;
        }

        @Override
        public void log(SQLExecutionResult result) {
            this.delegate.log(new StatementExecutionInfoImpl(result));
        }

        @Override
        public void finish(long executionTime) {
            this.delegate.finish(executionTime);
        }

        @Override
        public void cancel() {
            this.delegate.cancel();
        }
    }

    private static class SQLExecutionInfoImpl
    implements SQLExecutionInfo {
        private final boolean hasExceptions;
        private final List<Throwable> exceptions;
        private final List<StatementExecutionInfo> infos;

        SQLExecutionInfoImpl(SQLExecutionResults results) {
            this.hasExceptions = results.hasExceptions();
            this.exceptions = new ArrayList<Throwable>();
            this.infos = new ArrayList<StatementExecutionInfo>();
            for (SQLExecutionResult result : results.getResults()) {
                this.infos.add(new StatementExecutionInfoImpl(result));
                if (!result.hasExceptions()) continue;
                this.exceptions.addAll(result.getExceptions());
            }
        }

        @Override
        public boolean hasExceptions() {
            return this.hasExceptions;
        }

        @Override
        public List<? extends Throwable> getExceptions() {
            return this.exceptions;
        }

        @Override
        public List<StatementExecutionInfo> getStatementInfos() {
            return this.infos;
        }
    }

    private static class StatementExecutionInfoImpl
    implements StatementExecutionInfo {
        private SQLExecutionResult result;

        public StatementExecutionInfoImpl(SQLExecutionResult result) {
            this.result = result;
        }

        @Override
        public String getSQL() {
            return this.result.getStatementInfo().getSQL();
        }

        @Override
        public boolean hasExceptions() {
            return this.result.hasExceptions();
        }

        @Override
        public Collection<Throwable> getExceptions() {
            return this.result.getExceptions();
        }

        @Override
        public long getExecutionTime() {
            return this.result.getExecutionTime();
        }
    }
}

