/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.reader.bb;

import fr.profi.mzdb.io.reader.bb.AbstractBlobReader;
import fr.profi.mzdb.model.DataEncoding;
import fr.profi.mzdb.model.SpectrumData;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.model.SpectrumSlice;
import java.io.StreamCorruptedException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;

public class BytesReader
extends AbstractBlobReader {
    protected ByteBuffer _bbByteBuffer;
    protected int _blobSize;
    protected DataEncoding _firstDataEncondig;

    public BytesReader(byte[] bytes, long firstSpectrumId, long lastSpectrumId, Map<Long, SpectrumHeader> spectrumHeaderById, Map<Long, DataEncoding> dataEncodingBySpectrumId) throws StreamCorruptedException {
        super(firstSpectrumId, lastSpectrumId, spectrumHeaderById, dataEncodingBySpectrumId);
        this._bbByteBuffer = ByteBuffer.wrap(bytes);
        this._firstDataEncondig = dataEncodingBySpectrumId.values().iterator().next();
        this._bbByteBuffer.order(this._firstDataEncondig.getByteOrder());
        this._blobSize = bytes.length;
        this._indexSpectrumSlices((int)(1L + lastSpectrumId - firstSpectrumId));
    }

    protected void _indexSpectrumSlices(int estimatedSpectraCount) throws StreamCorruptedException {
        int[] spectrumSliceStartPositions = new int[estimatedSpectraCount];
        int[] peaksCounts = new int[estimatedSpectraCount];
        int spectrumSliceIdx = 0;
        int byteIdx = 0;
        while (byteIdx < this._blobSize) {
            int peaksCount;
            this._bbByteBuffer.position(byteIdx);
            long spectrumId = this._bbByteBuffer.getInt();
            spectrumSliceStartPositions[spectrumSliceIdx] = byteIdx;
            peaksCounts[spectrumSliceIdx] = peaksCount = this._bbByteBuffer.getInt();
            DataEncoding de = (DataEncoding)this._dataEncodingBySpectrumId.get(spectrumId);
            this.checkDataEncodingIsNotNull(de, spectrumId);
            byteIdx += 8 + peaksCount * de.getPeakStructSize();
            ++spectrumSliceIdx;
        }
        this._spectraCount = spectrumSliceIdx;
        this._spectrumSliceStartPositions = Arrays.copyOf(spectrumSliceStartPositions, this._spectraCount);
        this._peaksCounts = Arrays.copyOf(peaksCounts, this._spectraCount);
    }

    @Override
    public void disposeBlob() {
    }

    public int getBlobSize() {
        return this._blobSize;
    }

    @Override
    public int getSpectraCount() {
        return this._spectraCount;
    }

    @Override
    public long getSpectrumIdAt(int idx) {
        this.checkSpectrumIndexRange(idx);
        return this._getSpectrumIdAt(idx);
    }

    private long _getSpectrumIdAt(int idx) {
        return this._bbByteBuffer.getInt(this._spectrumSliceStartPositions[idx]);
    }

    @Override
    public SpectrumSlice readSpectrumSliceAt(int idx) {
        long spectrumId = this._getSpectrumIdAt(idx);
        SpectrumData spectrumSliceData = this._readFilteredSpectrumSliceDataAt(idx, spectrumId, -1.0, -1.0);
        SpectrumHeader sh = (SpectrumHeader)this._spectrumHeaderById.get(spectrumId);
        return new SpectrumSlice(sh, spectrumSliceData);
    }

    @Override
    public SpectrumData readSpectrumSliceDataAt(int idx) {
        return this._readFilteredSpectrumSliceDataAt(idx, this._getSpectrumIdAt(idx), -1.0, -1.0);
    }

    @Override
    public SpectrumData readFilteredSpectrumSliceDataAt(int idx, double minMz, double maxMz) {
        return this._readFilteredSpectrumSliceDataAt(idx, this._getSpectrumIdAt(idx), minMz, maxMz);
    }

    private SpectrumData _readFilteredSpectrumSliceDataAt(int idx, long spectrumId, double minMz, double maxMz) {
        DataEncoding de = (DataEncoding)this._dataEncodingBySpectrumId.get(spectrumId);
        int peaksBytesSize = this._peaksCounts[idx] * de.getPeakStructSize();
        int spectrumSliceStartPos = this._spectrumSliceStartPositions[idx] + 8;
        return this.readSpectrumSliceData(this._bbByteBuffer, spectrumSliceStartPos, peaksBytesSize, de, minMz, maxMz);
    }
}

