/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.reader.bb;

import fr.profi.mzdb.io.reader.bb.AbstractBlobReader;
import fr.profi.mzdb.model.DataEncoding;
import fr.profi.mzdb.model.SpectrumData;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.model.SpectrumSlice;
import fr.profi.mzdb.util.primitives.BytesUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class StreamReader
extends AbstractBlobReader {
    private InputStream _stream;

    public StreamReader(InputStream inputStream, long firstSpectrumId, long lastSpectrumId, Map<Long, SpectrumHeader> spectrumHeaderById, Map<Long, DataEncoding> dataEncodingBySpectrumId) {
        super(firstSpectrumId, lastSpectrumId, spectrumHeaderById, dataEncodingBySpectrumId);
        this._stream = inputStream;
    }

    @Override
    public void disposeBlob() {
        try {
            this._stream.close();
        }
        catch (IOException e) {
            this.logger.error("IOException has been caught while closing stream", (Throwable)e);
        }
    }

    @Override
    public int getSpectraCount() {
        return -1;
    }

    @Override
    public long getSpectrumIdAt(int idx) {
        long lastSpectrumId = 0L;
        try {
            for (int j = 0; j <= idx; ++j) {
                byte[] spectrumIdBytes = new byte[4];
                this._stream.read(spectrumIdBytes);
                lastSpectrumId = BytesUtils.bytesToInt(spectrumIdBytes, 0);
                byte[] peaksCountBytes = new byte[4];
                this._stream.read(peaksCountBytes);
                int peaksCount = BytesUtils.bytesToInt(peaksCountBytes, 0);
                DataEncoding de = (DataEncoding)this._dataEncodingBySpectrumId.get(lastSpectrumId);
                this.checkDataEncodingIsNotNull(de, lastSpectrumId);
                this._stream.skip(peaksCount * de.getPeakStructSize());
            }
            this._stream.close();
        }
        catch (IOException e) {
            this.logger.error("IOException has been caught while closing stream", (Throwable)e);
        }
        return lastSpectrumId;
    }

    @Override
    public SpectrumSlice readSpectrumSliceAt(int idx) {
        return this._readSpectrumSliceAt(idx, -1.0, -1.0);
    }

    private SpectrumSlice _readSpectrumSliceAt(int idx, double minMz, double maxMz) {
        byte[] peaksBytes = null;
        long spectrumId = 0L;
        int peaksCount = 0;
        DataEncoding de = null;
        try {
            for (int j = 0; j <= idx; ++j) {
                byte[] spectrumIdBytes = new byte[4];
                this._stream.read(spectrumIdBytes);
                spectrumId = BytesUtils.bytesToInt(spectrumIdBytes, 0);
                de = (DataEncoding)this._dataEncodingBySpectrumId.get(spectrumId);
                byte[] peaksCountBytes = new byte[4];
                this._stream.read(peaksCountBytes);
                peaksCount = BytesUtils.bytesToInt(peaksCountBytes, 0);
                int peaksBytesSize = peaksCount * de.getPeakStructSize();
                if (j < idx) {
                    this._stream.skip(peaksBytesSize);
                    continue;
                }
                byte[] pb = new byte[peaksBytesSize];
                this._stream.read(pb);
                peaksBytes = pb;
            }
            this._stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (peaksBytes == null) {
            return null;
        }
        SpectrumData spectrumSliceData = this.readSpectrumSliceData(ByteBuffer.wrap(peaksBytes), 0, peaksBytes.length, de, minMz, maxMz);
        return new SpectrumSlice((SpectrumHeader)this._spectrumHeaderById.get(spectrumId), spectrumSliceData);
    }

    @Override
    public SpectrumData readSpectrumSliceDataAt(int idx) {
        return this.readSpectrumSliceAt(idx).getData();
    }

    @Override
    public SpectrumData readFilteredSpectrumSliceDataAt(int idx, double minMz, double maxMz) {
        return this._readSpectrumSliceAt(idx, minMz, maxMz).getData();
    }
}

