/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.reader.table;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import fr.profi.mzdb.db.model.Sample;
import fr.profi.mzdb.db.table.SampleTable;
import fr.profi.mzdb.io.reader.table.AbstractTableModelReader;
import fr.profi.mzdb.io.reader.table.ParamTreeParser;
import fr.profi.mzdb.util.sqlite.ISQLiteRecordExtraction;
import fr.profi.mzdb.util.sqlite.SQLiteRecord;
import java.util.List;

public class SampleReader
extends AbstractTableModelReader<Sample> {
    public SampleReader(SQLiteConnection connection) {
        super(connection);
    }

    @Override
    protected ISQLiteRecordExtraction<Sample> buildRecordExtractor() {
        return new ISQLiteRecordExtraction<Sample>(){

            @Override
            public Sample extract(SQLiteRecord r) throws SQLiteException {
                int id = r.columnInt(SampleTable.ID);
                String name = r.columnString(SampleTable.NAME);
                String paramTreeAsStr = r.columnString(SampleTable.PARAM_TREE);
                return new Sample(id, name, ParamTreeParser.parseParamTree(paramTreeAsStr));
            }
        };
    }

    public Sample getSample(int id) throws SQLiteException {
        return (Sample)this.getRecord("sample", id);
    }

    public List<Sample> getSampleList() throws SQLiteException {
        return this.getRecordList("sample");
    }
}

