/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.reader.table;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import fr.profi.mzdb.db.model.SourceFile;
import fr.profi.mzdb.db.table.SourceFileTable;
import fr.profi.mzdb.io.reader.table.AbstractTableModelReader;
import fr.profi.mzdb.io.reader.table.ParamTreeParser;
import fr.profi.mzdb.util.sqlite.ISQLiteRecordExtraction;
import fr.profi.mzdb.util.sqlite.SQLiteRecord;
import java.util.List;

public class SourceFileReader
extends AbstractTableModelReader<SourceFile> {
    public SourceFileReader(SQLiteConnection connection) throws SQLiteException {
        super(connection);
    }

    @Override
    protected ISQLiteRecordExtraction<SourceFile> buildRecordExtractor() {
        return new ISQLiteRecordExtraction<SourceFile>(){

            @Override
            public SourceFile extract(SQLiteRecord r) throws SQLiteException {
                int id = r.columnInt(SourceFileTable.ID);
                String name = r.columnString(SourceFileTable.NAME);
                String location = r.columnString(SourceFileTable.LOCATION);
                String paramTreeAsStr = r.columnString(SourceFileTable.PARAM_TREE);
                return new SourceFile(id, name, location, ParamTreeParser.parseParamTree(paramTreeAsStr));
            }
        };
    }

    public SourceFile getSourceFile(int id) throws SQLiteException {
        return (SourceFile)this.getRecord("source_file", id);
    }

    public List<SourceFile> getSourceFileList() throws SQLiteException {
        return this.getRecordList("source_file");
    }
}

