/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.model;

import fr.profi.mzdb.model.DataMode;
import fr.profi.mzdb.model.PeakEncoding;
import java.nio.ByteOrder;

public class DataEncoding
implements Cloneable {
    protected final int id;
    protected final DataMode mode;
    protected PeakEncoding peakEncoding;
    protected final String compression;
    protected final ByteOrder byteOrder;
    protected final int peakStructSize;

    public DataEncoding(int id, DataMode mode, PeakEncoding peakEncoding, String compression, ByteOrder byteOrder) {
        this.id = id;
        this.mode = mode;
        this.peakEncoding = peakEncoding;
        this.compression = compression;
        this.byteOrder = byteOrder;
        int peakBytesSize = this.getPeakEncoding().getValue();
        if (this.getMode() == DataMode.FITTED) {
            peakBytesSize += 8;
        }
        this.peakStructSize = peakBytesSize;
    }

    public int getId() {
        return this.id;
    }

    public DataMode getMode() {
        return this.mode;
    }

    public PeakEncoding getPeakEncoding() {
        return this.peakEncoding;
    }

    public void setPeakEncoding(PeakEncoding p) {
        this.peakEncoding = p;
    }

    public String getCompression() {
        return this.compression;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public int getPeakStructSize() {
        return this.peakStructSize;
    }

    public DataEncoding clone() {
        return new DataEncoding(this.id, this.mode, this.peakEncoding, this.compression, this.byteOrder);
    }
}

