/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.model;

import fr.profi.mzdb.util.misc.AbstractInMemoryIdGen;

public class RunSliceHeader
extends AbstractInMemoryIdGen
implements Comparable<RunSliceHeader> {
    protected final int id;
    protected final int msLevel;
    protected final int number;
    protected final double beginMz;
    protected final double endMz;
    protected final int runId;

    public RunSliceHeader(int id, int msLevel, int number, double beginMz, double endMz, int runId) {
        this.id = id;
        this.msLevel = msLevel;
        this.number = number;
        this.beginMz = beginMz;
        this.endMz = endMz;
        this.runId = runId;
    }

    public int getId() {
        return this.id;
    }

    public int getMsLevel() {
        return this.msLevel;
    }

    public int getNumber() {
        return this.number;
    }

    public double getBeginMz() {
        return this.beginMz;
    }

    public double getEndMz() {
        return this.endMz;
    }

    public int getRunId() {
        return this.runId;
    }

    @Override
    public int compareTo(RunSliceHeader o) {
        if (this.beginMz < o.beginMz) {
            return -1;
        }
        if (Math.abs(this.beginMz - o.beginMz) < 1.0E-6) {
            return 0;
        }
        return 1;
    }

    public String toString() {
        return "RunSliceHeader [id=" + this.id + ", msLevel=" + this.msLevel + ", number=" + this.number + ", beginMz=" + this.beginMz + ", endMz=" + this.endMz + ", runId=" + this.runId + "]";
    }
}

