/*
 * Decompiled with CFR 0.152.
 */
package com.github.mzdb4s.db.model.params.thermo;

import com.github.mzdb4s.db.model.params.thermo.ThermoFragmentationTarget;
import com.github.mzdb4s.db.model.params.thermo.ThermoScanMetaData;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple5;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class ThermoScanMetaData$
implements Serializable {
    public static final ThermoScanMetaData$ MODULE$;
    private final String targetPattern;
    private final String ms2Pattern;
    private final String ms3Pattern;

    static {
        new ThermoScanMetaData$();
    }

    public String targetPattern() {
        return this.targetPattern;
    }

    public String ms2Pattern() {
        return this.ms2Pattern;
    }

    public String ms3Pattern() {
        return this.ms3Pattern;
    }

    public ThermoScanMetaData apply(String filterString) {
        String[] stringParts = filterString.split("Full ms");
        String rightString = stringParts[1];
        char msLevelChar = rightString.charAt(0);
        int msLevel = Character.getNumericValue(msLevelChar);
        String spectrumType = new StringBuilder().append((Object)stringParts[0]).append((Object)"Full ms").append((Object)BoxesRunTime.boxToCharacter((char)msLevelChar)).toString();
        String pattern = msLevel == 3 ? this.ms3Pattern() : this.ms2Pattern();
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(rightString);
        ThermoFragmentationTarget[] targets = new ThermoFragmentationTarget[msLevel - 1];
        float[] mzRange = new float[]{0.0f, 0.0f};
        if (m.find()) {
            targets[0] = new ThermoFragmentationTarget(1, new StringOps(Predef$.MODULE$.augmentString(m.group(1))).toDouble(), m.group(2), new StringOps(Predef$.MODULE$.augmentString(m.group(3))).toFloat());
            if (msLevel == 2) {
                mzRange[0] = new StringOps(Predef$.MODULE$.augmentString(m.group(4))).toFloat();
                mzRange[1] = new StringOps(Predef$.MODULE$.augmentString(m.group(5))).toFloat();
            } else {
                targets[1] = new ThermoFragmentationTarget(2, new StringOps(Predef$.MODULE$.augmentString(m.group(4))).toDouble(), m.group(5), new StringOps(Predef$.MODULE$.augmentString(m.group(6))).toFloat());
                mzRange[0] = new StringOps(Predef$.MODULE$.augmentString(m.group(7))).toFloat();
                mzRange[1] = new StringOps(Predef$.MODULE$.augmentString(m.group(8))).toFloat();
            }
        }
        return new ThermoScanMetaData(spectrumType, stringParts[0].split("\\s")[0], msLevel, mzRange, targets);
    }

    public ThermoScanMetaData apply(String spectrumType, String analyzerType, int msLevel, float[] mzRange, ThermoFragmentationTarget[] targets) {
        return new ThermoScanMetaData(spectrumType, analyzerType, msLevel, mzRange, targets);
    }

    public Option<Tuple5<String, String, Object, float[], ThermoFragmentationTarget[]>> unapply(ThermoScanMetaData x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)x$0.spectrumType(), (Object)x$0.analyzerType(), (Object)BoxesRunTime.boxToInteger((int)x$0.msLevel()), (Object)x$0.mzRange(), (Object)x$0.targets()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ThermoScanMetaData$() {
        MODULE$ = this;
        this.targetPattern = "\\s(\\d+\\.\\d+)@([a-z]+)(\\d+\\.\\d+)";
        this.ms2Pattern = new StringBuilder().append((Object)"\\d").append((Object)this.targetPattern()).append((Object)"\\s\\[(\\d+\\.\\d+)-(\\d+\\.\\d+)\\]").toString();
        this.ms3Pattern = new StringBuilder().append((Object)"\\d").append((Object)this.targetPattern()).append((Object)this.targetPattern()).append((Object)"\\s\\[(\\d+\\.\\d+)-(\\d+\\.\\d+)\\]").toString();
    }
}

