/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.logparser.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class ColorPalette
extends JPanel {
    public static final Color[] INTENSITY_PALETTE = new Color[]{Color.getHSBColor(0.0f, 0.0f, 1.0f), Color.getHSBColor(0.55f, 0.1f, 1.0f), Color.getHSBColor(0.55f, 0.2f, 1.0f), Color.getHSBColor(0.55f, 0.3f, 1.0f), Color.getHSBColor(0.55f, 0.4f, 1.0f), Color.getHSBColor(0.55f, 0.5f, 1.0f), Color.getHSBColor(0.3f, 0.2f, 1.0f), Color.getHSBColor(0.3f, 0.3f, 1.0f), Color.getHSBColor(0.3f, 0.5f, 1.0f), Color.getHSBColor(0.3f, 0.7f, 1.0f), Color.getHSBColor(0.3f, 0.9f, 1.0f), Color.getHSBColor(0.2f, 0.4f, 1.0f), Color.getHSBColor(0.18f, 0.5f, 1.0f), Color.getHSBColor(0.16f, 0.6f, 1.0f), Color.getHSBColor(0.14f, 0.6f, 1.0f), Color.getHSBColor(0.12f, 0.7f, 1.0f), Color.getHSBColor(0.1f, 0.8f, 1.0f), Color.getHSBColor(0.07f, 0.7f, 1.0f), Color.getHSBColor(0.05f, 0.6f, 1.0f), Color.getHSBColor(0.03f, 0.8f, 1.0f), Color.getHSBColor(0.0f, 1.0f, 1.0f)};
    static final int colorSize = INTENSITY_PALETTE.length;
    static final int EDGE = 18;
    static final int GAP = 1;

    public ColorPalette() {
        this.setBorder(BorderFactory.createLineBorder(Color.darkGray, 1, true));
        MouseAdapter dragGestureAdapter = this.getMouseAdapter();
        this.addMouseMotionListener(dragGestureAdapter);
        this.addMouseListener(dragGestureAdapter);
        this.setVisible(false);
        this.setPreferredSize(new Dimension(this.getWeightX(), 19));
        this.setSize(this.getPreferredSize());
    }

    private int getWeightX() {
        return 24 * INTENSITY_PALETTE.length + 2;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        String legend = "Color-Nb tasks : ";
        Rectangle2D bounds = g.getFontMetrics().getStringBounds(legend, g);
        int cx = new Double(bounds.getWidth()).intValue();
        g.setColor(Color.BLACK);
        g.drawString(legend, 2, 16);
        int x0 = cx;
        int y0 = 16;
        for (int i = 0; i < colorSize; ++i) {
            int start = 2 + x0 + i * 18;
            Color color = ColorPalette.pickColor(i);
            g.setColor(color);
            g.fillRect(start, 1, 18, 17);
            g.setColor(Color.BLACK);
            bounds = g.getFontMetrics().getStringBounds("" + i, g);
            cx = new Double(bounds.getCenterX()).intValue();
            g.drawString("" + i, start + (9 - cx), y0);
        }
    }

    public static Color pickColor(int nbTask) {
        int i = nbTask >= colorSize ? colorSize - 1 : nbTask;
        Color color = INTENSITY_PALETTE[i];
        return color;
    }

    private MouseAdapter getMouseAdapter() {
        MouseAdapter dragGestureAdapter = new MouseAdapter(){
            int dX;
            int dY;

            @Override
            public void mouseDragged(MouseEvent e) {
                int parentY;
                Component panel = e.getComponent();
                int newX = e.getLocationOnScreen().x - this.dX;
                int newY = e.getLocationOnScreen().y - this.dY;
                Container parentComponent = panel.getParent();
                int parentX = parentComponent.getX();
                if (newX < parentX) {
                    newX = parentX;
                }
                if (newY < (parentY = parentComponent.getY())) {
                    newY = parentY;
                }
                int parentWidth = parentComponent.getWidth();
                if (newX + panel.getWidth() > parentWidth - parentX) {
                    newX = parentWidth - parentX - panel.getWidth();
                }
                int parentHeight = parentComponent.getHeight();
                if (newY + panel.getHeight() > parentHeight - parentY) {
                    newY = parentHeight - parentY - panel.getHeight();
                }
                panel.setLocation(newX, newY);
                this.dX = e.getLocationOnScreen().x - panel.getX();
                this.dY = e.getLocationOnScreen().y - panel.getY();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JPanel panel = (JPanel)e.getComponent();
                panel.setCursor(Cursor.getPredefinedCursor(13));
                this.dX = e.getLocationOnScreen().x - panel.getX();
                this.dY = e.getLocationOnScreen().y - panel.getY();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JPanel panel = (JPanel)e.getComponent();
                panel.setCursor(null);
            }
        };
        return dragGestureAdapter;
    }
}

