/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.logparser.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import fr.proline.logparser.model.LogTask;
import fr.proline.logparser.model.Utility;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.openide.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskInJsonCtrl {
    protected static final Logger m_logger = LoggerFactory.getLogger(TaskInJsonCtrl.class);
    private static TaskInJsonCtrl m_instance;
    private Gson m_gson = new GsonBuilder().setPrettyPrinting().create();
    LogTask m_currentTask;
    File m_currentTaskFile;
    public File logFileDirectory;

    public static TaskInJsonCtrl getInstance() {
        if (m_instance == null) {
            m_instance = new TaskInJsonCtrl();
        }
        return m_instance;
    }

    public void init(String CortexLogFileName) {
        this.logFileDirectory = new File(Utility.WORKING_DATA_DIRECTORY + File.separator + CortexLogFileName);
        if (!this.logFileDirectory.isDirectory()) {
            boolean b = this.logFileDirectory.mkdir();
            m_logger.info("create folder {} successful ={}", (Object)this.logFileDirectory.getAbsolutePath(), (Object)b);
        }
    }

    private File getFile(int taskOrder) {
        return new File(this.logFileDirectory + File.separator + taskOrder + ".json");
    }

    public void initTaskFile(LogTask task) {
        int taskOrder = task.getTaskOrder();
        File taskFile = this.getFile(taskOrder);
        if (taskFile.isFile()) {
            taskFile.delete();
        }
    }

    public void writeTaskTrace(LogTask task, boolean isFirstTime, boolean isLastTime) {
        try {
            int taskOrder = task.getTaskOrder();
            File taskFile = this.getFile(taskOrder);
            try (FileWriter outputFile = null;){
                outputFile = new FileWriter(taskFile, true);
                String jsonOutput = this.m_gson.toJson(task.getTrace());
                if (jsonOutput.equals("[]")) {
                    jsonOutput = "]";
                } else {
                    String j1 = isFirstTime ? jsonOutput : "," + jsonOutput.substring(1);
                    int i = j1.lastIndexOf("]");
                    jsonOutput = j1.substring(0, i);
                    if (isLastTime) {
                        jsonOutput = jsonOutput + "]";
                    }
                }
                outputFile.write(jsonOutput);
            }
        }
        catch (IOException i) {
            m_logger.error("IO Exception when WriteTask in File. {} {}", (Object)i.getCause(), (Object)i.getLocalizedMessage());
        }
    }

    public ArrayList<LogTask.LogLine> getCurrentTaskTrace(int taskOrder) {
        try {
            this.m_currentTaskFile = this.getFile(taskOrder);
            JsonReader reader = new JsonReader((Reader)new FileReader(this.m_currentTaskFile));
            ArrayList traceList = null;
            Type type = new TypeToken<ArrayList<LogTask.LogLine>>(){}.getType();
            traceList = (ArrayList)this.m_gson.fromJson(reader, type);
            return traceList;
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public ArrayList<LogTask.LogLine> loadTrace(int taskOrder, int nomber) {
        try {
            this.m_currentTaskFile = this.getFile(taskOrder);
            JsonReader reader = new JsonReader((Reader)new FileReader(this.m_currentTaskFile));
            ArrayList<LogTask.LogLine> traces = new ArrayList<LogTask.LogLine>();
            reader.beginArray();
            for (int i = 0; reader.hasNext() && i < nomber; ++i) {
                LogTask.LogLine message = (LogTask.LogLine)this.m_gson.fromJson(reader, LogTask.LogLine.class);
                traces.add(message);
            }
            reader.close();
            return traces;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public File getCurrentFile() {
        return this.m_currentTaskFile;
    }
}

