/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.algo.ms.normalization;

import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.algo.ms.normalization.MsSpectrumNormalizer$;
import fr.profi.mzdb.model.Peak;
import fr.profi.mzdb.model.Spectrum;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.util.collection.package;
import fr.profi.util.collection.package$;
import java.util.Iterator;
import mr.go.sgfilter.SGFilterMath3;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.LongMap;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class MsSpectrumNormalizer$ {
    public static final MsSpectrumNormalizer$ MODULE$;

    static {
        new MsSpectrumNormalizer$();
    }

    public LongMap<Object> computeNfBySpectrumId(MzDbReader mzDbReader) {
        int cyclesCount = mzDbReader.getCyclesCount();
        float[] medians = new float[cyclesCount];
        long[] spectrumIds = new long[cyclesCount];
        Iterator msSpectrumIter = mzDbReader.getSpectrumIterator(1);
        while (msSpectrumIter.hasNext()) {
            Spectrum spectrum = (Spectrum)msSpectrumIter.next();
            float[] intensities = (float[])Predef$.MODULE$.refArrayOps((Object[])spectrum.toPeaks()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final float apply(Peak x$1) {
                    return x$1.getIntensity();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
            double medInt = this.median((Seq<Object>)Predef$.MODULE$.wrapFloatArray(intensities));
            SpectrumHeader sh = spectrum.getHeader();
            int idx = sh.getCycle() - 1;
            spectrumIds[idx] = sh.getId();
            medians[idx] = (float)medInt;
        }
        float[] nfs = this.computeNFs(medians);
        return package.LongMapBuilderFromTraversableOnce$.MODULE$.toLongMapWith$extension(package$.MODULE$.array2longMapBuilder(Predef$.MODULE$.longArrayOps(spectrumIds).zip((GenIterable)Predef$.MODULE$.wrapFloatArray(nfs), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    long id = tuple2._1$mcJ$sp();
                    float nf = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)id)), (Object)BoxesRunTime.boxToFloat((float)nf));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public float[] computeNFs(float[] sic) {
        int nbSpectra = sic.length;
        float[] smoothedValues = this.smoothValues(sic, 1);
        float[] nfs = new float[nbSpectra];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nbSpectra).foreach$mVc$sp((Function1)new Serializable(sic, smoothedValues, nfs){
            public static final long serialVersionUID = 0L;
            private final float[] sic$1;
            private final float[] smoothedValues$1;
            private final float[] nfs$1;

            public final void apply(int idx) {
                this.apply$mcVI$sp(idx);
            }

            public void apply$mcVI$sp(int idx) {
                float intensity = this.sic$1[idx];
                float corIntensity = this.smoothedValues$1[idx];
                this.nfs$1[idx] = corIntensity / intensity;
            }
            {
                this.sic$1 = sic$1;
                this.smoothedValues$1 = smoothedValues$1;
                this.nfs$1 = nfs$1;
            }
        });
        return nfs;
    }

    public double median(Seq<Object> s) {
        Tuple2 tuple2 = ((TraversableLike)s.sortWith((Function2)new anonfun.4())).splitAt(s.size() / 2);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq lower = (Seq)tuple2._1();
            Seq upper = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)lower, (Object)upper);
            Seq lower2 = (Seq)tuple23._1();
            Seq upper2 = (Seq)tuple23._2();
            return s.size() % 2 == 0 ? (double)(BoxesRunTime.unboxToFloat((Object)lower2.last()) + BoxesRunTime.unboxToFloat((Object)upper2.head())) / 2.0 : (double)BoxesRunTime.unboxToFloat((Object)upper2.head());
        }
        throw new MatchError((Object)tuple2);
    }

    public float[] smoothValues(float[] values, int times) {
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)1));
        if (tuple3 != null) {
            Tuple3 tuple32;
            int nl = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int nr = BoxesRunTime.unboxToInt((Object)tuple3._2());
            int order = BoxesRunTime.unboxToInt((Object)tuple3._3());
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)nl), (Object)BoxesRunTime.boxToInteger((int)nr), (Object)BoxesRunTime.boxToInteger((int)order));
            int nl2 = BoxesRunTime.unboxToInt((Object)tuple33._1());
            int nr2 = BoxesRunTime.unboxToInt((Object)tuple33._2());
            int order2 = BoxesRunTime.unboxToInt((Object)tuple33._3());
            float[] leftPad = (float[])Array$.MODULE$.fill(nl2, (Function0)new Serializable(values){
                public static final long serialVersionUID = 0L;
                private final float[] values$1;

                public final float apply() {
                    return this.apply$mcF$sp();
                }

                public float apply$mcF$sp() {
                    return BoxesRunTime.unboxToFloat((Object)Predef$.MODULE$.floatArrayOps(this.values$1).head());
                }
                {
                    this.values$1 = values$1;
                }
            }, ClassTag$.MODULE$.Float());
            float[] rightPad = (float[])Array$.MODULE$.fill(nl2, (Function0)new Serializable(values){
                public static final long serialVersionUID = 0L;
                private final float[] values$1;

                public final float apply() {
                    return this.apply$mcF$sp();
                }

                public float apply$mcF$sp() {
                    return BoxesRunTime.unboxToFloat((Object)Predef$.MODULE$.floatArrayOps(this.values$1).last());
                }
                {
                    this.values$1 = values$1;
                }
            }, ClassTag$.MODULE$.Float());
            double[] coeffs = SGFilterMath3.computeSGCoefficients(nl2, nr2, order2);
            SGFilterMath3 sgFilter = new SGFilterMath3(nl2, nr2);
            ObjectRef smoothedValues = ObjectRef.create((Object)values);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), times).foreach$mVc$sp((Function1)new Serializable(values, leftPad, rightPad, coeffs, sgFilter, smoothedValues){
                public static final long serialVersionUID = 0L;
                private final float[] values$1;
                private final float[] leftPad$1;
                private final float[] rightPad$1;
                private final double[] coeffs$1;
                private final SGFilterMath3 sgFilter$1;
                private final ObjectRef smoothedValues$2;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.smoothedValues$2.elem = this.sgFilter$1.smooth(this.values$1, this.leftPad$1, this.rightPad$1, this.coeffs$1);
                }
                {
                    this.values$1 = values$1;
                    this.leftPad$1 = leftPad$1;
                    this.rightPad$1 = rightPad$1;
                    this.coeffs$1 = coeffs$1;
                    this.sgFilter$1 = sgFilter$1;
                    this.smoothedValues$2 = smoothedValues$2;
                }
            });
            return (float[])smoothedValues.elem;
        }
        throw new MatchError((Object)tuple3);
    }

    private MsSpectrumNormalizer$() {
        MODULE$ = this;
    }
}

