/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.algo.signal.generation;

import fr.profi.mzdb.model.FullLcContext;
import fr.profi.mzdb.model.ILcContext;
import fr.profi.mzdb.model.Peak;
import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.model.PeakelBuilder;
import fr.profi.mzdb.util.math.pdf.GaussianModel;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.NumericRange;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichFloat;
import scala.runtime.RichFloat$;

public final class PeakelGenerator$ {
    public static final PeakelGenerator$ MODULE$;

    static {
        new PeakelGenerator$();
    }

    public Peakel generate(double mz, float time, float intensity, float duration, int samplingSize, float mzPeakHwhm) {
        Predef$.MODULE$.require(samplingSize > 0, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "samplingSize must be strictly positive";
            }
        });
        Predef$.MODULE$.require(duration > 0.0f, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "duration must be strictly positive";
            }
        });
        float halfDuration = duration / (float)2;
        GaussianModel gaussModel = new GaussianModel(time, intensity, halfDuration, 0.5);
        ArrayBuffer peaks = new ArrayBuffer();
        ((NumericRange)new RichFloat(Predef$.MODULE$.floatWrapper(time - halfDuration)).to((Object)BoxesRunTime.boxToFloat((float)(time + halfDuration))).by((Object)BoxesRunTime.boxToFloat((float)samplingSize))).foreach((Function1)new Serializable(mz, mzPeakHwhm, gaussModel, peaks){
            public static final long serialVersionUID = 0L;
            private final double mz$1;
            private final float mzPeakHwhm$1;
            private final GaussianModel gaussModel$1;
            private final ArrayBuffer peaks$1;

            public final ArrayBuffer<Peak> apply(float x) {
                double y = this.gaussModel$1.getYValue(x);
                return this.peaks$1.$plus$eq((Object)new Peak(this.mz$1, (float)y, this.mzPeakHwhm$1, this.mzPeakHwhm$1, (ILcContext)new FullLcContext(RichFloat$.MODULE$.round$extension(Predef$.MODULE$.floatWrapper(x)), x)));
            }
            {
                this.mz$1 = mz$1;
                this.mzPeakHwhm$1 = mzPeakHwhm$1;
                this.gaussModel$1 = gaussModel$1;
                this.peaks$1 = peaks$1;
            }
        });
        PeakelBuilder qual$1 = new PeakelBuilder((Seq<Peak>)Predef$.MODULE$.wrapRefArray((Object[])peaks.toArray(ClassTag$.MODULE$.apply(Peak.class))));
        int x$1 = qual$1.result$default$1();
        return qual$1.result(x$1);
    }

    private PeakelGenerator$() {
        MODULE$ = this;
    }
}

