/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.cli;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.mzdb.MzDbFeatureExtractor;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.XicMethod;
import fr.profi.mzdb.algo.feature.extraction.FeatureExtractorConfig;
import fr.profi.mzdb.algo.feature.extraction.FeatureExtractorConfig$;
import fr.profi.mzdb.algo.signal.detection.BasicPeakelFinder;
import fr.profi.mzdb.algo.signal.detection.BasicPeakelFinder$;
import fr.profi.mzdb.algo.signal.detection.waveletImpl.WaveletDetectorDuMethod;
import fr.profi.mzdb.cli.Commands;
import fr.profi.mzdb.cli.Commands$;
import fr.profi.mzdb.cli.Commands$$anonfun$extractXICs$1$1$;
import fr.profi.mzdb.cli.Commands$DetectedPeak$4$;
import fr.profi.mzdb.cli.MzDbProcessing$CreateMgfCommand$;
import fr.profi.mzdb.io.exporter.SQLiteFeatureStorer$;
import fr.profi.mzdb.io.reader.provider.RunSliceDataProvider;
import fr.profi.mzdb.io.writer.mgf.IPrecursorComputation;
import fr.profi.mzdb.io.writer.mgf.IsolationWindowPrecursorExtractor;
import fr.profi.mzdb.io.writer.mgf.MgfWriter;
import fr.profi.mzdb.io.writer.mgf.PrecursorMzComputationEnum;
import fr.profi.mzdb.model.Feature;
import fr.profi.mzdb.model.Feature$;
import fr.profi.mzdb.model.Peak;
import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.model.PeakelBuilder;
import fr.profi.mzdb.model.PutativeFeature;
import fr.profi.mzdb.model.Spectrum;
import fr.profi.mzdb.model.SpectrumSlice;
import fr.profi.util.stat.Bin;
import fr.profi.util.stat.package;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import mr.go.sgfilter.SGFilterMath3;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.collection.parallel.ParIterableLike;
import scala.collection.parallel.mutable.ParArray$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.FloatRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.VolatileObjectRef;

public final class Commands$
implements LazyLogging {
    public static final Commands$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new Commands$();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Commands$DetectedPeak$4$ fr$profi$mzdb$cli$Commands$$DetectedPeak$2$lzycompute(VolatileObjectRef x$1) {
        Commands$ commands$ = this;
        synchronized (commands$) {
            if (x$1.elem != null) return (Commands$DetectedPeak$4$)((Object)x$1.elem);
            x$1.elem = new Commands$DetectedPeak$4$(x$1);
            return (Commands$DetectedPeak$4$)((Object)x$1.elem);
        }
    }

    private Logger logger$lzycompute() {
        Commands$ commands$ = this;
        synchronized (commands$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void generateXICs(String mzdbListFilePath, String pepListFilePath, String outputFilePath, float mzTolInPPM, String algo) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        VolatileObjectRef DetectedPeak$module = VolatileObjectRef.zero();
        Tuple3[] mzList = this.getPeptideList$1(new File(pepListFilePath));
        PrintWriter writer = new PrintWriter(new FileOutputStream(outputFilePath));
        writer.println(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"file name", "input m/z", "exp m/z", "time", "duration", "area", "fwhm", "intensity", "ms1_intensity"})).mkString("\t"));
        writer.flush();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Starting the extraction of XICs...");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        String[][] xics = (String[][])Predef$.MODULE$.refArrayOps((Object[])this.getMzdbList$1(mzdbListFilePath)).map((Function1)new Serializable(mzTolInPPM, algo, mzList, DetectedPeak$module){
            public static final long serialVersionUID = 0L;
            private final float mzTolInPPM$1;
            private final String algo$1;
            private final Tuple3[] mzList$1;
            private final VolatileObjectRef DetectedPeak$module$1;

            public final String[] apply(String x$8) {
                return Commands$.MODULE$.fr$profi$mzdb$cli$Commands$$extractXICsForOneFile$1(x$8, this.mzList$1, this.mzTolInPPM$1, this.algo$1, this.DetectedPeak$module$1);
            }
            {
                this.mzTolInPPM$1 = mzTolInPPM$1;
                this.algo$1 = algo$1;
                this.mzList$1 = mzList$1;
                this.DetectedPeak$module$1 = DetectedPeak$module$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])xics).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String[] x) {
                return Predef$.MODULE$.refArrayOps((Object[])x);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(writer){
            public static final long serialVersionUID = 0L;
            private final PrintWriter writer$1;

            public final void apply(String x$9) {
                this.writer$1.println(x$9);
            }
            {
                this.writer$1 = writer$1;
            }
        });
        writer.close();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Extraction of XICs finished !");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void extractFeatures(String mzdbFilePath, String putativeFtsFile, String outputFile) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        BoxedUnit boxedUnit5;
        BoxedUnit boxedUnit6;
        MzDbReader mzDb = new MzDbReader(new File(mzdbFilePath), true);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Hello Predicted Time Extractor");
            boxedUnit6 = BoxedUnit.UNIT;
        } else {
            boxedUnit6 = BoxedUnit.UNIT;
        }
        PutativeFeature[] pfs = this.getPutativeFeatures$1(putativeFtsFile);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Read #{} putative features...", new Object[]{BoxesRunTime.boxToInteger((int)pfs.length)});
            boxedUnit5 = BoxedUnit.UNIT;
        } else {
            boxedUnit5 = BoxedUnit.UNIT;
        }
        java.util.Iterator rsIter = mzDb.getLcMsRunSliceIterator();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("got RS iterator");
            boxedUnit4 = BoxedUnit.UNIT;
        } else {
            boxedUnit4 = BoxedUnit.UNIT;
        }
        RunSliceDataProvider rsdProv = new RunSliceDataProvider(rsIter);
        int mzTolPPM = 10;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Starting Extraction...");
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        float x$20 = 10.0f;
        Some x$21 = new Some((Object)BoxesRunTime.boxToFloat((float)40.0f));
        int x$22 = FeatureExtractorConfig$.MODULE$.apply$default$2();
        int x$23 = FeatureExtractorConfig$.MODULE$.apply$default$3();
        int x$24 = FeatureExtractorConfig$.MODULE$.apply$default$4();
        float x$25 = FeatureExtractorConfig$.MODULE$.apply$default$5();
        float x$26 = FeatureExtractorConfig$.MODULE$.apply$default$6();
        Option<Object> x$27 = FeatureExtractorConfig$.MODULE$.apply$default$7();
        int x$28 = FeatureExtractorConfig$.MODULE$.apply$default$8();
        MzDbFeatureExtractor mzdbFtX = new MzDbFeatureExtractor(mzDb, 5, 2, new FeatureExtractorConfig(x$20, x$22, x$23, x$24, x$25, x$26, x$27, x$28, (Option<Object>)x$21));
        Seq<Feature> xFts = mzdbFtX.extractFeatures(rsdProv, (Seq<PutativeFeature>)Predef$.MODULE$.wrapRefArray((Object[])pfs), mzTolPPM);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Storing detected features");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        SQLiteFeatureStorer$.MODULE$.storeFeatures(xFts, new File(outputFile));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Ended");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public float[] smoothIntensities(float[] intensities) {
        int times = 3;
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)4));
        if (tuple3 != null) {
            Tuple3 tuple32;
            int nl = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int nr = BoxesRunTime.unboxToInt((Object)tuple3._2());
            int order = BoxesRunTime.unboxToInt((Object)tuple3._3());
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)nl), (Object)BoxesRunTime.boxToInteger((int)nr), (Object)BoxesRunTime.boxToInteger((int)order));
            int nl2 = BoxesRunTime.unboxToInt((Object)tuple33._1());
            int nr2 = BoxesRunTime.unboxToInt((Object)tuple33._2());
            int order2 = BoxesRunTime.unboxToInt((Object)tuple33._3());
            double[] coeffs = SGFilterMath3.computeSGCoefficients(nl2, nr2, order2);
            SGFilterMath3 sgFilter = new SGFilterMath3(5, 5);
            ObjectRef smoothedIntensities = ObjectRef.create((Object)intensities);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), times).foreach$mVc$sp((Function1)new Serializable(coeffs, sgFilter, smoothedIntensities){
                public static final long serialVersionUID = 0L;
                private final double[] coeffs$1;
                private final SGFilterMath3 sgFilter$1;
                private final ObjectRef smoothedIntensities$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.smoothedIntensities$1.elem = this.sgFilter$1.smooth((float[])this.smoothedIntensities$1.elem, this.coeffs$1);
                }
                {
                    this.coeffs$1 = coeffs$1;
                    this.sgFilter$1 = sgFilter$1;
                    this.smoothedIntensities$1 = smoothedIntensities$1;
                }
            });
            return (float[])smoothedIntensities.elem;
        }
        throw new MatchError((Object)tuple3);
    }

    public void dumpRegion(String mzdbFilePath, String outputFilePath, double mzmin, double mzmax, float rtmin, float rtmax) {
        BoxedUnit boxedUnit;
        long start = System.currentTimeMillis();
        MzDbReader mzDb = new MzDbReader(mzdbFilePath, true);
        PrintWriter outStream = new PrintWriter(new FileOutputStream(outputFilePath));
        SpectrumSlice[] spectrumSlices = mzDb.getMsSpectrumSlices(mzmin, mzmax, rtmin, rtmax);
        outStream.println(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"moz", "time", "intensity"})).mkString("\t"));
        Predef$.MODULE$.refArrayOps((Object[])spectrumSlices).foreach((Function1)new Serializable(outStream){
            public static final long serialVersionUID = 0L;
            public final PrintWriter outStream$1;

            public final void apply(SpectrumSlice spectrumSlice) {
                Predef$.MODULE$.refArrayOps((Object[])spectrumSlice.toPeaks()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.dumpRegion.1 $outer;

                    public final void apply(Peak peak) {
                        this.$outer.outStream$1.println(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{peak.getMz(), peak.getLcContext().getElutionTime(), peak.getIntensity()})).mkString("\t"));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.outStream$1 = outStream$1;
            }
        });
        outStream.close();
        mzDb.close();
        float took = (float)((double)(System.currentTimeMillis() - start) / 1000.0);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder().append((Object)"extraction took: ").append((Object)BoxesRunTime.boxToFloat((float)took)).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void dumpRegionBinning(String mzdbFilePath, String outputFilePath, int nbBins, double mzmin, double mzmax, float rtmin, float rtmax) {
        long start = System.currentTimeMillis();
        MzDbReader mzDb = new MzDbReader(mzdbFilePath, true);
        PrintWriter outStream = new PrintWriter(new FileOutputStream(outputFilePath));
        SpectrumSlice[] spectrumSlices = mzDb.getMsSpectrumSlices(mzmin, mzmax, rtmin, rtmax);
        double[] flattenedPeaksMz = (double[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])spectrumSlices).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Peak[] apply(SpectrumSlice x$11) {
                return x$11.toPeaks();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Peak.class))))).flatten((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final WrappedArray<Peak> apply(Peak[] xs) {
                return Predef$.MODULE$.wrapRefArray((Object[])xs);
            }
        }, ClassTag$.MODULE$.apply(Peak.class))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Peak x$12) {
                return x$12.getMz();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return x;
            }
        }, (Ordering)Ordering.Double$.MODULE$);
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(flattenedPeaksMz).head()), BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(flattenedPeaksMz).last()));
        if (sp2 != null) {
            BoxedUnit boxedUnit;
            Tuple2.mcDD.sp sp3;
            double minmz = sp2._1$mcD$sp();
            double maxmz = sp2._2$mcD$sp();
            Tuple2.mcDD.sp sp4 = sp3 = new Tuple2.mcDD.sp(minmz, maxmz);
            double minmz2 = sp4._1$mcD$sp();
            double maxmz2 = sp4._2$mcD$sp();
            package.EntityHistogramComputer binner = new package.EntityHistogramComputer((Seq)Predef$.MODULE$.wrapDoubleArray(flattenedPeaksMz), (Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(double x) {
                    return this.apply$mcDD$sp(x);
                }

                public double apply$mcDD$sp(double x) {
                    return x;
                }
            });
            Tuple2[] mzBins = binner.calcHistogram(nbBins, binner.calcHistogram$default$2());
            double[] mzList = (double[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])mzBins).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(Tuple2<Bin, Seq<Object>> x0$5) {
                    Tuple2<Bin, Seq<Object>> tuple2 = x0$5;
                    if (tuple2 != null) {
                        Bin bin = (Bin)tuple2._1();
                        double d = bin.center();
                        return d;
                    }
                    throw new MatchError(tuple2);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).toArray(ClassTag$.MODULE$.Double());
            float[] rtList = (float[])Predef$.MODULE$.floatArrayOps((float[])Predef$.MODULE$.refArrayOps((Object[])spectrumSlices).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final float apply(SpectrumSlice x$14) {
                    return x$14.getHeader().getElutionTime();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()))).toArray(ClassTag$.MODULE$.Float());
            float[][] intList = (float[][])Array$.MODULE$.ofDim(spectrumSlices.length, mzBins.length, ClassTag$.MODULE$.Float());
            IntRef i = IntRef.create((int)0);
            Predef$.MODULE$.refArrayOps((Object[])spectrumSlices).foreach((Function1)new Serializable(nbBins, minmz2, maxmz2, intList, i){
                public static final long serialVersionUID = 0L;
                private final int nbBins$1;
                private final double minmz$1;
                private final double maxmz$1;
                public final float[][] intList$1;
                public final IntRef i$1;

                public final void apply(SpectrumSlice spectrumSlice) {
                    package.EntityHistogramComputer binner_ = new package.EntityHistogramComputer((Seq)Predef$.MODULE$.wrapRefArray((Object[])spectrumSlice.toPeaks()), (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final double apply(Peak x) {
                            return x.getMz();
                        }
                    });
                    Tuple2[] bins = binner_.calcHistogram(this.nbBins$1, (Option)new Some((Object)Predef.Pair$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)this.minmz$1), (Object)BoxesRunTime.boxToDouble((double)this.maxmz$1))));
                    IntRef j = IntRef.create((int)0);
                    Predef$.MODULE$.refArrayOps((Object[])bins).foreach((Function1)new Serializable(this, j){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.dumpRegionBinning.1 $outer;
                        private final IntRef j$1;

                        public final void apply(Tuple2<Bin, Seq<Peak>> x0$6) {
                            Tuple2<Bin, Seq<Peak>> tuple2 = x0$6;
                            if (tuple2 != null) {
                                Seq values = (Seq)tuple2._2();
                                this.$outer.intList$1[this.$outer.i$1.elem][this.j$1.elem] = BoxesRunTime.unboxToFloat((Object)((TraversableOnce)values.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final float apply(Peak x$15) {
                                        return x$15.getIntensity();
                                    }
                                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
                                ++this.j$1.elem;
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.j$1 = j$1;
                        }
                    });
                    ++this.i$1.elem;
                }
                {
                    this.nbBins$1 = nbBins$1;
                    this.minmz$1 = minmz$1;
                    this.maxmz$1 = maxmz$1;
                    this.intList$1 = intList$1;
                    this.i$1 = i$1;
                }
            });
            outStream.println(new StringBuilder().append((Object)"moz: ").append((Object)Predef$.MODULE$.doubleArrayOps(mzList).mkString("\t")).toString());
            outStream.println(new StringBuilder().append((Object)"rt: ").append((Object)Predef$.MODULE$.floatArrayOps(rtList).mkString("\t")).toString());
            String intString = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])intList).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(float[] x$16) {
                    return Predef$.MODULE$.floatArrayOps(x$16).mkString("\t");
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toArray(ClassTag$.MODULE$.apply(String.class))).mkString(",");
            outStream.println(new StringBuilder().append((Object)"intensities: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])intList).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(float[] x$17) {
                    return Predef$.MODULE$.floatArrayOps(x$17).mkString("\t");
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toArray(ClassTag$.MODULE$.apply(String.class))).mkString(",")).toString());
            outStream.close();
            mzDb.close();
            float took = (float)((double)(System.currentTimeMillis() - start) / 1000.0);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringBuilder().append((Object)"extraction took: ").append((Object)BoxesRunTime.boxToFloat((float)took)).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)sp2);
    }

    public void createMgf() {
        block9: {
            block8: {
                MgfWriter writer;
                block7: {
                    BoxedUnit boxedUnit;
                    BoxedUnit boxedUnit2;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info(new StringBuilder().append((Object)"Creating MGF File for mzDB at: ").append((Object)MzDbProcessing$CreateMgfCommand$.MODULE$.mzdbFile()).toString());
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info(new StringBuilder().append((Object)"Precursor m/z values will be defined using the method: ").append((Object)MzDbProcessing$CreateMgfCommand$.MODULE$.precMzComputation()).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    writer = new MgfWriter(MzDbProcessing$CreateMgfCommand$.MODULE$.mzdbFile(), MzDbProcessing$CreateMgfCommand$.MODULE$.msLevel());
                    Option precCompEnum = Predef$.MODULE$.refArrayOps((Object[])PrecursorMzComputationEnum.values()).find((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(PrecursorMzComputationEnum x$18) {
                            String string = x$18.name();
                            String string2 = MzDbProcessing$CreateMgfCommand$.MODULE$.precMzComputation().toUpperCase();
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                    });
                    if (!precCompEnum.isDefined()) break block7;
                    writer.write(MzDbProcessing$CreateMgfCommand$.MODULE$.outputFile(), (PrecursorMzComputationEnum)precCompEnum.get(), MzDbProcessing$CreateMgfCommand$.MODULE$.mzTolPPM(), MzDbProcessing$CreateMgfCommand$.MODULE$.intensityCutoff(), MzDbProcessing$CreateMgfCommand$.MODULE$.exportProlineTitle());
                    break block8;
                }
                String string = MzDbProcessing$CreateMgfCommand$.MODULE$.precMzComputation();
                String string2 = "isolation_window_extracted";
                if (string != null ? !string.equals(string2) : string2 != null) break block9;
                IsolationWindowPrecursorExtractor precComputer = new IsolationWindowPrecursorExtractor(MzDbProcessing$CreateMgfCommand$.MODULE$.mzTolPPM());
                writer.write(MzDbProcessing$CreateMgfCommand$.MODULE$.outputFile(), (IPrecursorComputation)precComputer, MzDbProcessing$CreateMgfCommand$.MODULE$.intensityCutoff(), MzDbProcessing$CreateMgfCommand$.MODULE$.exportProlineTitle());
            }
            return;
        }
        throw new IllegalArgumentException("Can't create the MGF file, invalid precursor m/z computation method");
    }

    public final Commands$DetectedPeak$4$ fr$profi$mzdb$cli$Commands$$DetectedPeak$2(VolatileObjectRef DetectedPeak$module$1) {
        return DetectedPeak$module$1.elem == null ? this.fr$profi$mzdb$cli$Commands$$DetectedPeak$2$lzycompute(DetectedPeak$module$1) : (Commands$DetectedPeak$4$)((Object)DetectedPeak$module$1.elem);
    }

    private final float sumPeaks$1(Seq peaks) {
        return BoxesRunTime.unboxToFloat((Object)peaks.foldLeft((Object)BoxesRunTime.boxToFloat((float)0.0f), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final float apply(float s, Peak p) {
                return s + p.getIntensity();
            }
        }));
    }

    public final float fr$profi$mzdb$cli$Commands$$highestPeakIntensity$1(Seq peaks) {
        return ((Peak)((IterableLike)peaks.sortWith((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Peak a, Peak b) {
                return a.getIntensity() > b.getIntensity();
            }
        })).head()).getIntensity();
    }

    /*
     * WARNING - void declaration
     */
    private final String[] getMzdbList$1(String mzdbListFilePath$1) {
        void var2_2;
        BoxedUnit boxedUnit;
        String[] a = (String[])Source$.MODULE$.fromFile(mzdbListFilePath$1, Codec$.MODULE$.fallbackSystemCodec()).getLines().toArray(ClassTag$.MODULE$.apply(String.class));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Found #{} files to analyze", new Object[]{BoxesRunTime.boxToInteger((int)a.length)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private final Tuple3[] getPeptideList$1(File pepFile) {
        void var2_2;
        Tuple3[] mzList = (Tuple3[])Source$.MODULE$.fromFile(pepFile.getAbsolutePath(), Codec$.MODULE$.fallbackSystemCodec()).getLines().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final Tuple3<Object, Object, Object> apply(String l) {
                block8: {
                    Tuple2 tuple2;
                    block9: {
                        void var3_3;
                        block7: {
                            float rtmax;
                            Tuple3 returnVal;
                            String[] splitted;
                            block6: {
                                splitted = new StringOps(Predef$.MODULE$.augmentString("\\s")).r().split((CharSequence)l);
                                returnVal = null;
                                if (splitted.length != 1) break block6;
                                returnVal = new Tuple3((Object)BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(splitted[0])).toDouble()), (Object)BoxesRunTime.boxToFloat((float)0.0f), (Object)BoxesRunTime.boxToFloat((float)0.0f));
                                break block7;
                            }
                            if (splitted.length != 3) break block8;
                            double mz = new StringOps(Predef$.MODULE$.augmentString(splitted[0])).toDouble();
                            tuple2 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(splitted[1])).toFloat()), (Object)BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(splitted[2])).toFloat()));
                            if (tuple2 == null) break block9;
                            float rtmin = BoxesRunTime.unboxToFloat((Object)tuple2._1());
                            float rtmax2 = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)rtmin), (Object)BoxesRunTime.boxToFloat((float)rtmax2));
                            Tuple2 tuple23 = tuple22;
                            float rtmin2 = BoxesRunTime.unboxToFloat((Object)tuple23._1());
                            if (rtmin2 > (rtmax = BoxesRunTime.unboxToFloat((Object)tuple23._2()))) {
                                BoxedUnit boxedUnit;
                                if (Commands$.MODULE$.logger().underlying().isWarnEnabled()) {
                                    Commands$.MODULE$.logger().underlying().warn("rtmin is bigger than rtmax: switching both...");
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                float tmp = rtmin2;
                                rtmin2 = rtmax;
                                rtmax = tmp;
                            }
                            returnVal = new Tuple3((Object)BoxesRunTime.boxToDouble((double)mz), (Object)BoxesRunTime.boxToFloat((float)rtmin2), (Object)BoxesRunTime.boxToFloat((float)rtmax));
                        }
                        return var3_3;
                    }
                    throw new MatchError((Object)tuple2);
                }
                throw new Exception(new StringBuilder().append((Object)"can not parse correctly pepList file, line:").append((Object)l).toString());
            }
        }).toArray(ClassTag$.MODULE$.apply(Tuple3.class));
        return var2_2;
    }

    private final Tuple2[] extractXICs$1(MzDbReader mzDb, Tuple3[] mzList, float mzTolInPPM$1, String algo$1, VolatileObjectRef DetectedPeak$module$1) {
        block9: {
            Tuple3[] peakMatrix;
            block8: {
                BoxedUnit boxedUnit;
                block7: {
                    peakMatrix = (Tuple3[])Predef$.MODULE$.refArrayOps((Object[])mzList).map((Function1)new Serializable(mzTolInPPM$1, mzDb){
                        public static final long serialVersionUID = 0L;
                        private final float mzTolInPPM$1;
                        private final MzDbReader mzDb$1;

                        public final Tuple3<Object, Peak[], Tuple2<Object, Object>> apply(Tuple3<Object, Object, Object> x0$1) {
                            Tuple3<Object, Object, Object> tuple3 = x0$1;
                            if (tuple3 != null) {
                                double mz = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                                float rtmin = BoxesRunTime.unboxToFloat((Object)tuple3._2());
                                float rtmax = BoxesRunTime.unboxToFloat((Object)tuple3._3());
                                double mzTolInDa = (double)this.mzTolInPPM$1 * mz / 1000000.0;
                                Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(mz - mzTolInDa, mz + mzTolInDa);
                                if (sp2 != null) {
                                    BoxedUnit boxedUnit;
                                    Tuple2.mcDD.sp sp3;
                                    double minMz = sp2._1$mcD$sp();
                                    double maxMz = sp2._2$mcD$sp();
                                    Tuple2.mcDD.sp sp4 = sp3 = new Tuple2.mcDD.sp(minMz, maxMz);
                                    double minMz2 = sp4._1$mcD$sp();
                                    double maxMz2 = sp4._2$mcD$sp();
                                    Peak[] peaks = this.mzDb$1.getMsXicInMzRange(minMz2, maxMz2, XicMethod.MAX);
                                    if (Commands$.MODULE$.logger().underlying().isInfoEnabled()) {
                                        Commands$.MODULE$.logger().underlying().info("XIC for mass {} contains #{} peaks", new Object[]{BoxesRunTime.boxToDouble((double)mz), BoxesRunTime.boxToInteger((int)peaks.length)});
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)mz), (Object)peaks, (Object)new Tuple2((Object)BoxesRunTime.boxToFloat((float)rtmin), (Object)BoxesRunTime.boxToFloat((float)rtmax)));
                                    return tuple32;
                                }
                                throw new MatchError((Object)sp2);
                            }
                            throw new MatchError(tuple3);
                        }
                        {
                            this.mzTolInPPM$1 = mzTolInPPM$1;
                            this.mzDb$1 = mzDb$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
                    String string = algo$1;
                    String string2 = "basic";
                    if (string != null ? !string.equals(string2) : string2 != null) break block7;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("basic algorithm");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    break block8;
                }
                String string = algo$1;
                String string3 = "wavelet";
                if (string != null ? !string.equals(string3) : string3 != null) break block9;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("wavelet algorithm");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            return (Tuple2[])((ParIterableLike)Predef$.MODULE$.refArrayOps((Object[])peakMatrix).par().map((Function1)new Serializable(algo$1, DetectedPeak$module$1){
                public static final long serialVersionUID = 0L;
                private final String algo$1;
                private final VolatileObjectRef DetectedPeak$module$1;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Tuple2<Object, Option<Commands.DetectedPeak.3>> apply(Tuple3<Object, Peak[], Tuple2<Object, Object>> x0$2) {
                    Tuple2 intSum;
                    Tuple2 tuple2;
                    Tuple3<Object, Peak[], Tuple2<Object, Object>> tuple3 = x0$2;
                    if (tuple3 == null) throw new MatchError(tuple3);
                    double mz = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                    Peak[] peaks = (Peak[])tuple3._2();
                    Tuple2 tuple22 = (Tuple2)tuple3._3();
                    if (tuple22 == null) throw new MatchError(tuple3);
                    float rtmin = BoxesRunTime.unboxToFloat((Object)tuple22._1());
                    float rtmax = BoxesRunTime.unboxToFloat((Object)tuple22._2());
                    Tuple2<Object, Object>[] peakelIndexes = null;
                    String string = this.algo$1;
                    String string2 = "basic";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        BasicPeakelFinder basicPeakelFinder = new BasicPeakelFinder(BasicPeakelFinder$.MODULE$.$lessinit$greater$default$1(), BasicPeakelFinder$.MODULE$.$lessinit$greater$default$2());
                        peakelIndexes = basicPeakelFinder.findPeakelsIndices((Seq<Peak>)Predef$.MODULE$.wrapRefArray((Object[])peaks));
                    } else {
                        String string3 = this.algo$1;
                        String string4 = "wavelet";
                        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                            WaveletDetectorDuMethod wpf = new WaveletDetectorDuMethod((Seq<Peak>)Predef$.MODULE$.wrapRefArray((Object[])peaks));
                            wpf.ridgeFilteringParams().minSNR_$eq(0.0f);
                            peakelIndexes = wpf.findPeakelsIndexes();
                        }
                    }
                    Peak[][] peakels = rtmin == 0.0f && rtmax == 0.0f ? (Peak[][])Predef$.MODULE$.refArrayOps((Object[])peakelIndexes).map((Function1)new Serializable(this, peaks){
                        public static final long serialVersionUID = 0L;
                        public final Peak[] peaks$1;

                        public final Peak[] apply(Tuple2<Object, Object> peakelIdx) {
                            return (Peak[])Predef$.MODULE$.intArrayOps((int[])RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(peakelIdx._1$mcI$sp()), peakelIdx._2$mcI$sp()).toArray(ClassTag$.MODULE$.Int())).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$extractXICs$1$1$$anonfun$5 $outer;

                                public final Peak apply(int x$3) {
                                    return this.$outer.peaks$1[x$3];
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Peak.class)));
                        }
                        {
                            this.peaks$1 = peaks$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Peak.class)))) : (Peak[][])Predef$.MODULE$.refArrayOps((Object[])peakelIndexes).withFilter((Function1)new Serializable(this, peaks, rtmin, rtmax){
                        public static final long serialVersionUID = 0L;
                        private final Peak[] peaks$1;
                        private final float rtmin$1;
                        private final float rtmax$1;

                        public final boolean apply(Tuple2<Object, Object> x) {
                            return (double)this.peaks$1[x._1$mcI$sp()].getLcContext().getElutionTime() / 60.0 > (double)this.rtmin$1 && (double)this.peaks$1[x._2$mcI$sp()].getLcContext().getElutionTime() / 60.0 < (double)this.rtmax$1;
                        }
                        {
                            this.peaks$1 = peaks$1;
                            this.rtmin$1 = rtmin$1;
                            this.rtmax$1 = rtmax$1;
                        }
                    }).map((Function1)new Serializable(this, peaks){
                        public static final long serialVersionUID = 0L;
                        public final Peak[] peaks$1;

                        public final Peak[] apply(Tuple2<Object, Object> peakelIdx) {
                            return (Peak[])Predef$.MODULE$.intArrayOps((int[])RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(peakelIdx._1$mcI$sp()), peakelIdx._2$mcI$sp()).toArray(ClassTag$.MODULE$.Int())).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$extractXICs$1$1$$anonfun$7 $outer;

                                public final Peak apply(int x$4) {
                                    return this.$outer.peaks$1[x$4];
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Peak.class)));
                        }
                        {
                            this.peaks$1 = peaks$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Peak.class))));
                    Peak[][] sortedPeakels = (Peak[][])Predef$.MODULE$.refArrayOps((Object[])peakels).sortWith((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Peak[] a, Peak[] b) {
                            return Commands$.MODULE$.fr$profi$mzdb$cli$Commands$$highestPeakIntensity$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])a)) > Commands$.MODULE$.fr$profi$mzdb$cli$Commands$$highestPeakIntensity$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])b));
                        }
                    });
                    if (sortedPeakels.length > 0) {
                        Tuple2 tuple23;
                        Peak[] peaks2 = sortedPeakels[0];
                        Peak apex = (Peak)Predef$.MODULE$.refArrayOps((Object[])peaks2).reduce((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Peak apply(Peak a, Peak b) {
                                return a.getIntensity() > b.getIntensity() ? a : b;
                            }
                        });
                        int apexIdx = Predef$.MODULE$.refArrayOps((Object[])peaks2).indexOf((Object)apex);
                        Tuple2 tuple24 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])peaks2).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).partition((Function1)new anonfun$extractXICs$1$1$$anonfun$10(this, apexIdx));
                        if (tuple24 == null) throw new MatchError((Object)tuple24);
                        Tuple2[] leftPeaksWithIdx = (Tuple2[])tuple24._1();
                        Tuple2[] rightPeaksWithIdx = (Tuple2[])tuple24._2();
                        Tuple2 tuple25 = tuple23 = new Tuple2((Object)leftPeaksWithIdx, (Object)rightPeaksWithIdx);
                        Tuple2[] leftPeaksWithIdx2 = (Tuple2[])tuple25._1();
                        Tuple2[] rightPeaksWithIdx2 = (Tuple2[])tuple25._2();
                        Tuple2[] leftPeaksFiltered = this.keepPeaksWithIncreasingIntensity$1(leftPeaksWithIdx2);
                        Tuple2[] rightPeaksFiltered = this.keepPeaksWithIncreasingIntensity$1((Tuple2[])Predef$.MODULE$.refArrayOps((Object[])rightPeaksWithIdx2).reverse());
                        Peak[] smoothedPeaks = (Peak[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])leftPeaksFiltered).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])rightPeaksFiltered).reverse()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).withFilter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Tuple2<Peak, Object> check$ifrefutable$1) {
                                Tuple2<Peak, Object> tuple2 = check$ifrefutable$1;
                                boolean bl = tuple2 != null;
                                return bl;
                            }
                        }).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Peak apply(Tuple2<Peak, Object> x$6) {
                                Tuple2<Peak, Object> tuple2 = x$6;
                                if (tuple2 != null) {
                                    Peak p;
                                    Peak peak = p = (Peak)tuple2._1();
                                    return peak;
                                }
                                throw new MatchError(tuple2);
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Peak.class)));
                        double threshold = (double)apex.getIntensity() * 0.05;
                        Peak[] filteredPeaks = (Peak[])Predef$.MODULE$.refArrayOps((Object[])smoothedPeaks).filter((Function1)new Serializable(this, threshold){
                            public static final long serialVersionUID = 0L;
                            private final double threshold$1;

                            public final boolean apply(Peak p) {
                                return (double)p.getIntensity() > this.threshold$1;
                            }
                            {
                                this.threshold$1 = threshold$1;
                            }
                        });
                        PeakelBuilder qual$1 = new PeakelBuilder((Seq<Peak>)Predef$.MODULE$.wrapRefArray((Object[])filteredPeaks));
                        int x$19 = qual$1.result$default$1();
                        Peakel peakel = qual$1.result(x$19);
                        public class Fr_profi_mzdb_cli_Commands$DetectedPeak$3
                        implements Product,
                        Serializable {
                            private final double mz;
                            private final Peak apex;
                            private final float duration;
                            private final float area;
                            private float intensity;
                            private float time;
                            private volatile byte bitmap$0;

                            private float intensity$lzycompute() {
                                Fr_profi_mzdb_cli_Commands$DetectedPeak$3 var1_1 = this;
                                synchronized (var1_1) {
                                    if ((byte)(this.bitmap$0 & 1) == 0) {
                                        this.intensity = this.apex().getIntensity();
                                        this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                                    }
                                    return this.intensity;
                                }
                            }

                            private float time$lzycompute() {
                                Fr_profi_mzdb_cli_Commands$DetectedPeak$3 var1_1 = this;
                                synchronized (var1_1) {
                                    if ((byte)(this.bitmap$0 & 2) == 0) {
                                        this.time = this.apex().getLcContext().getElutionTime();
                                        this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                                    }
                                    return this.time;
                                }
                            }

                            public double mz() {
                                return this.mz;
                            }

                            public Peak apex() {
                                return this.apex;
                            }

                            public float duration() {
                                return this.duration;
                            }

                            public float area() {
                                return this.area;
                            }

                            public float intensity() {
                                return (byte)(this.bitmap$0 & 1) == 0 ? this.intensity$lzycompute() : this.intensity;
                            }

                            public float time() {
                                return (byte)(this.bitmap$0 & 2) == 0 ? this.time$lzycompute() : this.time;
                            }

                            public float getApexFullSpectrumIntensity(MzDbReader mzDb) {
                                Spectrum spectrum = mzDb.getSpectrum(this.apex().getLcContext().getSpectrumId());
                                return spectrum.getHeader().getTIC();
                            }

                            public Fr_profi_mzdb_cli_Commands$DetectedPeak$3 copy(double mz, Peak apex, float duration, float area) {
                                return new Fr_profi_mzdb_cli_Commands$DetectedPeak$3(mz, apex, duration, area);
                            }

                            public double copy$default$1() {
                                return this.mz();
                            }

                            public Peak copy$default$2() {
                                return this.apex();
                            }

                            public float copy$default$3() {
                                return this.duration();
                            }

                            public float copy$default$4() {
                                return this.area();
                            }

                            public String productPrefix() {
                                return "DetectedPeak";
                            }

                            public int productArity() {
                                return 4;
                            }

                            public Object productElement(int x$1) {
                                Object object;
                                int n = x$1;
                                switch (n) {
                                    default: {
                                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                                    }
                                    case 3: {
                                        object = BoxesRunTime.boxToFloat((float)this.area());
                                        break;
                                    }
                                    case 2: {
                                        object = BoxesRunTime.boxToFloat((float)this.duration());
                                        break;
                                    }
                                    case 1: {
                                        object = this.apex();
                                        break;
                                    }
                                    case 0: {
                                        object = BoxesRunTime.boxToDouble((double)this.mz());
                                    }
                                }
                                return object;
                            }

                            public Iterator<Object> productIterator() {
                                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
                            }

                            public boolean canEqual(Object x$1) {
                                return x$1 instanceof Fr_profi_mzdb_cli_Commands$DetectedPeak$3;
                            }

                            public int hashCode() {
                                int n = -889275714;
                                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.mz()));
                                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.apex()));
                                n = Statics.mix((int)n, (int)Statics.floatHash((float)this.duration()));
                                n = Statics.mix((int)n, (int)Statics.floatHash((float)this.area()));
                                return Statics.finalizeHash((int)n, (int)4);
                            }

                            public String toString() {
                                return ScalaRunTime$.MODULE$._toString((Product)this);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public boolean equals(Object x$1) {
                                if (this == x$1) return true;
                                Object object = x$1;
                                if (!(object instanceof Fr_profi_mzdb_cli_Commands$DetectedPeak$3)) return false;
                                boolean bl = true;
                                if (!bl) return false;
                                Fr_profi_mzdb_cli_Commands$DetectedPeak$3 var4_4 = (Fr_profi_mzdb_cli_Commands$DetectedPeak$3)x$1;
                                if (this.mz() != var4_4.mz()) return false;
                                Peak peak = this.apex();
                                Peak peak2 = var4_4.apex();
                                if (peak == null) {
                                    if (peak2 != null) {
                                        return false;
                                    }
                                } else if (!peak.equals(peak2)) return false;
                                if (this.duration() != var4_4.duration()) return false;
                                if (this.area() != var4_4.area()) return false;
                                if (!var4_4.canEqual(this)) return false;
                                return true;
                            }

                            public Fr_profi_mzdb_cli_Commands$DetectedPeak$3(double mz, Peak apex, float duration, float area) {
                                this.mz = mz;
                                this.apex = apex;
                                this.duration = duration;
                                this.area = area;
                                Product.class.$init$((Product)this);
                            }
                        }
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)mz)), (Object)new Some((Object)Commands$.MODULE$.fr$profi$mzdb$cli$Commands$$DetectedPeak$2(this.DetectedPeak$module$1).apply(peakel.getMz(), apex, peakel.calcDuration(), peakel.area())));
                        intSum = tuple2;
                        return intSum;
                    } else {
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)mz)), (Object)None$.MODULE$);
                    }
                    intSum = tuple2;
                    return intSum;
                }

                private final Tuple2[] keepPeaksWithIncreasingIntensity$1(Tuple2[] peaksWithIdx) {
                    FloatRef prevIntensity = FloatRef.create((float)0.0f);
                    return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])peaksWithIdx).filter((Function1)new Serializable(this, prevIntensity){
                        public static final long serialVersionUID = 0L;
                        private final FloatRef prevIntensity$1;

                        public final boolean apply(Tuple2<Peak, Object> x0$4) {
                            Tuple2<Peak, Object> tuple2 = x0$4;
                            if (tuple2 != null) {
                                Peak p = (Peak)tuple2._1();
                                float curIntensity = p.getIntensity();
                                boolean isHigher = curIntensity >= this.prevIntensity$1.elem;
                                this.prevIntensity$1.elem = curIntensity;
                                boolean bl = isHigher;
                                return bl;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.prevIntensity$1 = prevIntensity$1;
                        }
                    });
                }
                {
                    this.algo$1 = algo$1;
                    this.DetectedPeak$module$1 = DetectedPeak$module$1;
                }
            }, (CanBuildFrom)ParArray$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        }
        throw new Exception(new StringBuilder().append((Object)"Specified algorithm is not defined:").append((Object)algo$1).toString());
    }

    public final String[] fr$profi$mzdb$cli$Commands$$extractXICsForOneFile$1(String mzdbFilePath, Tuple3[] mzList, float mzTolInPPM$1, String algo$1, VolatileObjectRef DetectedPeak$module$1) {
        String[] stringArray;
        long start = System.currentTimeMillis();
        Object mzDb = null;
        try {
            try {
                BoxedUnit boxedUnit;
                MzDbReader mzDb2 = new MzDbReader(mzdbFilePath, true);
                ArrayBuffer xicsBuilder = new ArrayBuffer();
                Tuple2[] peptides = this.extractXICs$1(mzDb2, mzList, mzTolInPPM$1, algo$1, DetectedPeak$module$1);
                Predef$.MODULE$.refArrayOps((Object[])peptides).foreach((Function1)new Serializable(mzdbFilePath, mzDb2, xicsBuilder){
                    public static final long serialVersionUID = 0L;
                    private final String mzdbFilePath$1;
                    private final MzDbReader mzDb$2;
                    private final ArrayBuffer xicsBuilder$1;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final void apply(Tuple2<Object, Option<Commands.DetectedPeak.3>> pep) {
                        BoxedUnit boxedUnit;
                        double mz = pep._1$mcD$sp();
                        if (((Option)pep._2()).isDefined()) {
                            BoxedUnit boxedUnit2;
                            Tuple6 tuple6;
                            Fr_profi_mzdb_cli_Commands$DetectedPeak$3 peak = (Fr_profi_mzdb_cli_Commands$DetectedPeak$3)((Option)pep._2()).get();
                            Tuple6 tuple62 = new Tuple6((Object)BoxesRunTime.boxToDouble((double)peak.mz()), (Object)BoxesRunTime.boxToFloat((float)(peak.time() / (float)60)), (Object)BoxesRunTime.boxToFloat((float)(peak.duration() / (float)60)), (Object)BoxesRunTime.boxToFloat((float)peak.area()), (Object)BoxesRunTime.boxToFloat((float)peak.intensity()), (Object)BoxesRunTime.boxToFloat((float)peak.getApexFullSpectrumIntensity(this.mzDb$2)));
                            if (tuple62 == null) throw new MatchError((Object)tuple62);
                            double expMz = BoxesRunTime.unboxToDouble((Object)tuple62._1());
                            float time = BoxesRunTime.unboxToFloat((Object)tuple62._2());
                            float dur = BoxesRunTime.unboxToFloat((Object)tuple62._3());
                            float area = BoxesRunTime.unboxToFloat((Object)tuple62._4());
                            float f = BoxesRunTime.unboxToFloat((Object)tuple62._5());
                            float msSpectrumInt = BoxesRunTime.unboxToFloat((Object)tuple62._6());
                            Tuple6 tuple63 = tuple6 = new Tuple6((Object)BoxesRunTime.boxToDouble((double)expMz), (Object)BoxesRunTime.boxToFloat((float)time), (Object)BoxesRunTime.boxToFloat((float)dur), (Object)BoxesRunTime.boxToFloat((float)area), (Object)BoxesRunTime.boxToFloat((float)f), (Object)BoxesRunTime.boxToFloat((float)msSpectrumInt));
                            double expMz2 = BoxesRunTime.unboxToDouble((Object)tuple63._1());
                            float time2 = BoxesRunTime.unboxToFloat((Object)tuple63._2());
                            float dur2 = BoxesRunTime.unboxToFloat((Object)tuple63._3());
                            float area2 = BoxesRunTime.unboxToFloat((Object)tuple63._4());
                            int = BoxesRunTime.unboxToFloat((Object)tuple63._5());
                            float msSpectrumInt2 = BoxesRunTime.unboxToFloat((Object)tuple63._6());
                            this.xicsBuilder$1.$plus$eq((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.mzdbFilePath$1, BoxesRunTime.boxToDouble((double)mz), BoxesRunTime.boxToDouble((double)expMz2), BoxesRunTime.boxToFloat((float)time2), BoxesRunTime.boxToFloat((float)dur2), BoxesRunTime.boxToFloat((float)area2), BoxesRunTime.boxToFloat((float)int), BoxesRunTime.boxToFloat((float)msSpectrumInt2)})).mkString("\t"));
                            if (Commands$.MODULE$.logger().underlying().isInfoEnabled()) {
                                Commands$.MODULE$.logger().underlying().info(new StringBuilder().append((Object)"found peptide ion of intensity |").append((Object)BoxesRunTime.boxToFloat((float)int)).append((Object)"| and duration |").append((Object)BoxesRunTime.boxToFloat((float)dur2)).append((Object)"| at |").append((Object)BoxesRunTime.boxToFloat((float)time2)).append((Object)"|").toString());
                                boxedUnit2 = BoxedUnit.UNIT;
                                return;
                            } else {
                                boxedUnit2 = BoxedUnit.UNIT;
                            }
                            return;
                        } else if (Commands$.MODULE$.logger().underlying().isWarnEnabled()) {
                            Commands$.MODULE$.logger().underlying().warn(new StringBuilder().append((Object)"can't find peptide ion of m/z=").append((Object)BoxesRunTime.boxToDouble((double)mz)).toString());
                            boxedUnit = BoxedUnit.UNIT;
                            return;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    {
                        this.mzdbFilePath$1 = mzdbFilePath$1;
                        this.mzDb$2 = mzDb$2;
                        this.xicsBuilder$1 = xicsBuilder$1;
                    }
                });
                float took = (float)((double)(System.currentTimeMillis() - start) / 1000.0);
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringBuilder().append((Object)"extraction took: ").append((Object)BoxesRunTime.boxToFloat((float)took)).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                stringArray = (String[])xicsBuilder.toArray(ClassTag$.MODULE$.apply(String.class));
            }
            catch (Exception exception) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder().append((Object)"Extraction failed for file ").append((Object)mzdbFilePath).append((Object)" because: ").append((Object)exception.getMessage()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                stringArray = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
            }
        }
        finally {
            if (mzDb != null) {
                mzDb.close();
            }
        }
        return stringArray;
    }

    private final PutativeFeature[] getPutativeFeatures$1(String putativeFtsFile$1) {
        return (PutativeFeature[])Source$.MODULE$.fromFile(putativeFtsFile$1, Codec$.MODULE$.fallbackSystemCodec()).getLines().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final PutativeFeature apply(String l) {
                void var3_3;
                String[] splitted = new StringOps(Predef$.MODULE$.augmentString("\\s")).r().split((CharSequence)l);
                PutativeFeature pf = new PutativeFeature(Feature$.MODULE$.generateNewId(), new StringOps(Predef$.MODULE$.augmentString(splitted[0])).toDouble(), new StringOps(Predef$.MODULE$.augmentString(splitted[1])).toInt(), new StringOps(Predef$.MODULE$.augmentString(splitted[2])).toFloat(), 1);
                pf.isPredicted_$eq(true);
                return var3_3;
            }
        }).toArray(ClassTag$.MODULE$.apply(PutativeFeature.class));
    }

    private Commands$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

