/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.writer.mgf;

import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.algo.IsotopicPatternScorer$;
import fr.profi.mzdb.db.model.params.Precursor;
import fr.profi.mzdb.io.writer.mgf.DefaultPrecursorComputer;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.model.SpectrumSlice;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)4A!\u0001\u0002\u0001\u001f\t\t\u0013j]8mCRLwN\\,j]\u0012|w\u000f\u0015:fGV\u00148o\u001c:FqR\u0014\u0018m\u0019;pe*\u00111\u0001B\u0001\u0004[\u001e4'BA\u0003\u0007\u0003\u00199(/\u001b;fe*\u0011q\u0001C\u0001\u0003S>T!!\u0003\u0006\u0002\t5THM\u0019\u0006\u0003\u00171\tQ\u0001\u001d:pM&T\u0011!D\u0001\u0003MJ\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0019\t\u00164\u0017-\u001e7u!J,7-\u001e:t_J\u001cu.\u001c9vi\u0016\u0014\b\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\u00115THk\u001c7Q!6\u0003\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011QA\u00127pCRDQ!\b\u0001\u0005\u0002y\ta\u0001P5oSRtDCA\u0010!!\t\t\u0002\u0001C\u0003\u00169\u0001\u0007a\u0003C\u0005#\u0001\u0001\u0007\t\u0019!C\u0005G\u0005qA.Y:u!J,G-[2uS>tW#\u0001\u0013\u0011\t])s%L\u0005\u0003Ma\u0011a\u0001V;qY\u0016\u0014\u0004C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\t\u0003\u0015iw\u000eZ3m\u0013\ta\u0013F\u0001\bTa\u0016\u001cGO];n\u0011\u0016\fG-\u001a:\u0011\u00059\u0012T\"A\u0018\u000b\u0005)\u0002$BA\u0019\u000b\u0003\ti7/\u0003\u00024_\tIB\u000b[3pe\u0016$\u0018nY1m\u0013N|Go\u001c9f!\u0006$H/\u001a:o\u0011%)\u0004\u00011AA\u0002\u0013%a'\u0001\nmCN$\bK]3eS\u000e$\u0018n\u001c8`I\u0015\fHCA\u001c;!\t9\u0002(\u0003\u0002:1\t!QK\\5u\u0011\u001dYD'!AA\u0002\u0011\n1\u0001\u001f\u00132\u0011\u0019i\u0004\u0001)Q\u0005I\u0005yA.Y:u!J,G-[2uS>t\u0007\u0005C\u0003@\u0001\u0011\u0005\u0003)\u0001\bhKR\u0004&/Z2veN|'/\u0014>\u0015\u0007\u0005#%\n\u0005\u0002\u0018\u0005&\u00111\t\u0007\u0002\u0007\t>,(\r\\3\t\u000b\u0015s\u0004\u0019\u0001$\u0002\rI,\u0017\rZ3s!\t9\u0005*D\u0001\t\u0013\tI\u0005B\u0001\u0006Nu\u0012\u0013'+Z1eKJDQa\u0013 A\u0002\u001d\nab\u001d9fGR\u0014X/\u001c%fC\u0012,'\u000fC\u0003N\u0001\u0011%a*A\u000ehKR\u0014Um\u001d;Jg>$x\u000e]5d!\u0006$H/\u001a:o\u001b\u0006$8\r\u001b\u000b\u0006\u001fJ\u001bFK\u0016\t\u0004/Ak\u0013BA)\u0019\u0005\u0019y\u0005\u000f^5p]\")Q\t\u0014a\u0001\r\")1\n\u0014a\u0001O!)Q\u000b\u0014a\u0001\u0003\u00061\u0001O]3d\u001bjDQa\u0016'A\u0002Y\tA\u0001^5nK\")\u0011\f\u0001C!5\u0006\u0011r-\u001a;Qe\u0016\u001cWO]:pe\u000eC\u0017M]4f)\rYfl\u0018\t\u0003/qK!!\u0018\r\u0003\u0007%sG\u000fC\u0003F1\u0002\u0007a\tC\u0003L1\u0002\u0007q\u0005C\u0003b\u0001\u0011\u0005#-\u0001\u0007hKR\u0004\u0016M]1n\u001d\u0006lW\rF\u0001d!\t!wM\u0004\u0002\u0018K&\u0011a\rG\u0001\u0007!J,G-\u001a4\n\u0005!L'AB*ue&twM\u0003\u0002g1\u0001")
public class IsolationWindowPrecursorExtractor
extends DefaultPrecursorComputer {
    private final float mzTolPPM;
    private Tuple2<SpectrumHeader, TheoreticalIsotopePattern> lastPrediction;

    private Tuple2<SpectrumHeader, TheoreticalIsotopePattern> lastPrediction() {
        return this.lastPrediction;
    }

    private void lastPrediction_$eq(Tuple2<SpectrumHeader, TheoreticalIsotopePattern> x$1) {
        this.lastPrediction = x$1;
    }

    public double getPrecursorMz(MzDbReader reader, SpectrumHeader spectrumHeader) {
        double d;
        Option<TheoreticalIsotopePattern> bestPattern;
        double precMz;
        float time = spectrumHeader.getElutionTime();
        Precursor precursor = spectrumHeader.getPrecursor();
        Double altPrecMz = this.refinePrecMz(reader, precursor, precMz = precursor.parseFirstSelectedIonMz(), this.mzTolPPM, time, 5.0f);
        if (altPrecMz != null) {
            precMz = Predef$.MODULE$.Double2double(altPrecMz);
        }
        if ((bestPattern = this.getBestIsotopicPatternMatch(reader, spectrumHeader, precMz, time)).isDefined()) {
            this.lastPrediction_$eq((Tuple2<SpectrumHeader, TheoreticalIsotopePattern>)new Tuple2((Object)spectrumHeader, bestPattern.get()));
            if (package$.MODULE$.abs(precMz - ((TheoreticalIsotopePattern)bestPattern.get()).monoMz()) > 0.001) {
                this.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"scan ", " : change predicted precursorMz from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)spectrumHeader.getInitialId()), BoxesRunTime.boxToDouble((double)precMz), BoxesRunTime.boxToDouble((double)((TheoreticalIsotopePattern)bestPattern.get()).monoMz())})));
            }
            d = ((TheoreticalIsotopePattern)bestPattern.get()).monoMz();
        } else {
            this.logger.info("no prediction : returns precursorMz");
            d = precMz;
        }
        return d;
    }

    private Option<TheoreticalIsotopePattern> getBestIsotopicPatternMatch(MzDbReader reader, SpectrumHeader spectrumHeader, double precMz, float time) {
        None$ none$;
        SpectrumSlice[] slices = reader.getMsSpectrumSlices(precMz - (double)5, precMz + (double)5, time - 5.0f, time + 5.0f);
        if (Predef$.MODULE$.refArrayOps((Object[])slices).isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            SpectrumSlice slice = (SpectrumSlice)Predef$.MODULE$.refArrayOps((Object[])slices).minBy((Function1)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final float time$1;

                public final float apply(SpectrumSlice x) {
                    return Math.abs(x.getHeader().getElutionTime() - this.time$1);
                }
                {
                    this.time$1 = time$1;
                }
            }, (Ordering)Ordering.Float$.MODULE$);
            Tuple2<Object, TheoreticalIsotopePattern>[] putativePatterns = IsotopicPatternScorer$.MODULE$.calcIsotopicPatternHypotheses(slice.getData(), precMz, (double)this.mzTolPPM);
            none$ = new Some(((Tuple2)Predef$.MODULE$.refArrayOps((Object[])putativePatterns).head())._2());
        }
        return none$;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getPrecursorCharge(MzDbReader reader, SpectrumHeader spectrumHeader) {
        int n;
        int charge = spectrumHeader.getPrecursorCharge();
        if (charge > 0) {
            n = charge;
            return n;
        }
        if (this.lastPrediction() != null) {
            SpectrumHeader spectrumHeader2 = spectrumHeader;
            Object object = this.lastPrediction()._1();
            if (!(spectrumHeader2 != null ? !spectrumHeader2.equals(object) : object != null)) {
                if (charge != ((TheoreticalIsotopePattern)this.lastPrediction()._2()).charge()) {
                    this.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"scan ", " : change predicted charge from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)spectrumHeader.getInitialId()), BoxesRunTime.boxToInteger((int)charge), BoxesRunTime.boxToInteger((int)((TheoreticalIsotopePattern)this.lastPrediction()._2()).charge())})));
                }
                n = ((TheoreticalIsotopePattern)this.lastPrediction()._2()).charge();
                return n;
            }
        }
        float time = spectrumHeader.getElutionTime();
        double precMz = spectrumHeader.getPrecursorMz();
        Option<TheoreticalIsotopePattern> bestPattern = this.getBestIsotopicPatternMatch(reader, spectrumHeader, precMz, time);
        if (!bestPattern.isDefined()) {
            n = charge;
            return n;
        }
        if (charge != ((TheoreticalIsotopePattern)bestPattern.get()).charge()) {
            this.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"change predicted charge from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)charge), BoxesRunTime.boxToInteger((int)((TheoreticalIsotopePattern)bestPattern.get()).charge())})));
        }
        n = ((TheoreticalIsotopePattern)bestPattern.get()).charge();
        return n;
    }

    public String getParamName() {
        return "Proline refined precursor mz";
    }

    public IsolationWindowPrecursorExtractor(float mzTolPPM) {
        this.mzTolPPM = mzTolPPM;
        super(mzTolPPM);
    }
}

