/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.nbio.structure.ResidueRange;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.SubstructureIdentifier;
import org.biojava.nbio.structure.align.util.AtomCache;

public class BioAssemblyIdentifier
implements StructureIdentifier {
    private String pdbCode;
    private int biolNr;
    public static final Pattern BIO_NAME_PATTERN = Pattern.compile("^(?:BIO:)([0-9][a-z0-9]{3})(?::([0-9]+))?$", 2);

    public BioAssemblyIdentifier(String name) {
        Matcher match = BIO_NAME_PATTERN.matcher(name);
        if (!match.matches()) {
            throw new IllegalArgumentException("Invalid BIO identifier");
        }
        this.pdbCode = match.group(1);
        this.biolNr = match.group(2) != null ? Integer.parseInt(match.group(2)) : 1;
    }

    public BioAssemblyIdentifier(String pdbCode, int biolNr) {
        this.pdbCode = pdbCode;
        this.biolNr = biolNr;
    }

    @Override
    public String getIdentifier() {
        if (this.biolNr < 0) {
            return "BIO:" + this.pdbCode;
        }
        return String.format("BIO:%s:%d", this.pdbCode, this.biolNr);
    }

    public String toString() {
        return this.getIdentifier();
    }

    @Override
    public Structure loadStructure(AtomCache cache) throws StructureException, IOException {
        return cache.getBiologicalAssembly(this.pdbCode, this.biolNr);
    }

    @Override
    public SubstructureIdentifier toCanonical() throws StructureException {
        return new SubstructureIdentifier(this.pdbCode, new ArrayList<ResidueRange>());
    }

    @Override
    public Structure reduce(Structure input) throws StructureException {
        return input;
    }
}

