/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.Structure;

public class GroupIterator
implements Iterator<Group> {
    Structure structure;
    int current_model_pos;
    int current_chain_pos;
    int current_group_pos;

    public GroupIterator(Structure struct) {
        this.structure = struct;
        this.current_model_pos = 0;
        this.current_chain_pos = 0;
        this.current_group_pos = -1;
    }

    private Structure getStructure() {
        return this.structure;
    }

    private int getModelPos() {
        return this.current_model_pos;
    }

    private void setModelPos(int pos) {
        this.current_model_pos = pos;
    }

    private int getChainPos() {
        return this.current_chain_pos;
    }

    private void setChainPos(int pos) {
        this.current_chain_pos = pos;
    }

    private int getGroupPos() {
        return this.current_group_pos;
    }

    private void setGroupPos(int pos) {
        this.current_group_pos = pos;
    }

    public Object clone() {
        GroupIterator gr = new GroupIterator(this.getStructure());
        gr.setModelPos(this.getModelPos());
        gr.setChainPos(this.getChainPos());
        gr.setGroupPos(this.getGroupPos());
        return gr;
    }

    @Override
    public boolean hasNext() {
        return this.hasSubGroup(this.current_model_pos, this.current_chain_pos, this.current_group_pos + 1);
    }

    private boolean hasSubGroup(int tmp_model, int tmp_chain, int tmp_group) {
        if (tmp_model >= this.structure.nrModels()) {
            return false;
        }
        List<Chain> model = this.structure.getModel(tmp_model);
        if (tmp_chain >= model.size()) {
            return this.hasSubGroup(tmp_model + 1, 0, 0);
        }
        Chain chain = model.get(tmp_chain);
        return tmp_group < chain.getAtomLength() || this.hasSubGroup(tmp_model, tmp_chain + 1, 0);
    }

    public int getCurrentModel() {
        return this.current_model_pos;
    }

    public Chain getCurrentChain() {
        if (this.current_model_pos >= this.structure.nrModels()) {
            return null;
        }
        List<Chain> model = this.structure.getModel(this.current_model_pos);
        if (this.current_chain_pos >= model.size()) {
            return null;
        }
        return model.get(this.current_chain_pos);
    }

    @Override
    public Group next() throws NoSuchElementException {
        return this.getNextGroup(this.current_model_pos, this.current_chain_pos, this.current_group_pos + 1);
    }

    private Group getNextGroup(int tmp_model, int tmp_chain, int tmp_group) throws NoSuchElementException {
        if (tmp_model >= this.structure.nrModels()) {
            throw new NoSuchElementException("arrived at end of structure!");
        }
        List<Chain> model = this.structure.getModel(tmp_model);
        if (tmp_chain >= model.size()) {
            return this.getNextGroup(tmp_model + 1, 0, 0);
        }
        Chain chain = model.get(tmp_chain);
        if (tmp_group >= chain.getAtomLength()) {
            return this.getNextGroup(tmp_model, tmp_chain + 1, 0);
        }
        this.current_model_pos = tmp_model;
        this.current_chain_pos = tmp_chain;
        this.current_group_pos = tmp_group;
        return chain.getAtomGroup(this.current_group_pos);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot call remove() for GroupIterator");
    }
}

