/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.fatcat.calc;

import java.util.List;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.AFPTwister;
import org.biojava.nbio.structure.align.fatcat.calc.AFPCalculator;
import org.biojava.nbio.structure.align.fatcat.calc.AFPChainer;
import org.biojava.nbio.structure.align.fatcat.calc.AFPOptimizer;
import org.biojava.nbio.structure.align.fatcat.calc.AFPPostProcessor;
import org.biojava.nbio.structure.align.fatcat.calc.FatCatParameters;
import org.biojava.nbio.structure.align.fatcat.calc.SigEva;
import org.biojava.nbio.structure.align.model.AFP;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.util.AFPAlignmentDisplay;

public class FatCatAligner {
    public static final boolean debug = false;
    public static final boolean printTimeStamps = false;
    AFPChain afpChain;
    Group[] twistedGroups;

    public AFPChain getAfpChain() {
        return this.afpChain;
    }

    public Group[] getTwistedGroups() {
        return this.twistedGroups;
    }

    public void setTwistedGroups(Group[] twistedGroups) {
        this.twistedGroups = twistedGroups;
    }

    public void align(Atom[] ca1, Atom[] ca2, boolean doRigid, FatCatParameters params) throws StructureException {
        long tstart = System.currentTimeMillis();
        this.afpChain = new AFPChain("jFatCat");
        this.afpChain.setCa1Length(ca1.length);
        this.afpChain.setCa2Length(ca2.length);
        AFPCalculator.extractAFPChains(params, this.afpChain, ca1, ca2);
        long cend = System.currentTimeMillis();
        AFPCalculator.sortAfps(this.afpChain, ca1, ca2);
        this.twistedGroups = doRigid ? FatCatAligner.rChainAfp(params, this.afpChain, ca1, ca2) : FatCatAligner.chainAfp(params, this.afpChain, ca1, ca2);
        long end = System.currentTimeMillis();
        this.afpChain.setCalculationTime(end - tstart);
    }

    private static Group[] rChainAfp(FatCatParameters params, AFPChain afpChain, Atom[] ca1, Atom[] ca2) throws StructureException {
        params.setMaxTra(0);
        afpChain.setMaxTra(0);
        return FatCatAligner.chainAfp(params, afpChain, ca1, ca2);
    }

    private static Group[] chainAfp(FatCatParameters params, AFPChain afpChain, Atom[] ca1, Atom[] ca2) throws StructureException {
        Atom[] ca2clone = StructureTools.cloneAtomArray(ca2);
        List<AFP> afpSet = afpChain.getAfpSet();
        int afpNum = afpSet.size();
        if (afpNum < 1) {
            return new Group[0];
        }
        long bgtime = System.currentTimeMillis();
        AFPChainer.doChainAfp(params, afpChain, ca1, ca2);
        int afpChainLen = afpChain.getAfpChainLen();
        if (afpChainLen < 1) {
            afpChain.setShortAlign(true);
            return new Group[0];
        }
        long chaintime = System.currentTimeMillis();
        AFPPostProcessor.postProcess(params, afpChain, ca1, ca2);
        AFPOptimizer.optimizeAln(params, afpChain, ca1, ca2);
        AFPOptimizer.blockInfo(afpChain);
        AFPOptimizer.updateScore(params, afpChain);
        AFPAlignmentDisplay.getAlign(afpChain, ca1, ca2);
        Group[] twistedPDB = AFPTwister.twistPDB(afpChain, ca1, ca2clone);
        SigEva sig = new SigEva();
        double probability = sig.calSigAll(params, afpChain);
        afpChain.setProbability(probability);
        double normAlignScore = sig.calNS(params, afpChain);
        afpChain.setNormAlignScore(normAlignScore);
        return twistedPDB;
    }
}

