/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.pairwise;

import java.util.ArrayList;
import org.biojava.nbio.structure.align.helper.AligMatEl;
import org.biojava.nbio.structure.align.helper.GapArray;
import org.biojava.nbio.structure.align.helper.IndexPair;
import org.biojava.nbio.structure.align.pairwise.Alignable;

public class Gotoh {
    public static int ALIGFACTOR = 1000;
    Alignable a;
    int k;
    int openPen;
    int elgPen;
    int rowDim;
    int colDim;
    int openVal;
    int elgVal;
    AligMatEl currentCell;
    GapArray currentGap;

    public Gotoh(Alignable alignable) {
        this.a = alignable;
        this.align();
    }

    private void align() {
        int val;
        int k;
        this.rowDim = this.a.getRows() + 1;
        this.colDim = this.a.getCols() + 1;
        this.openPen = Math.round((float)ALIGFACTOR * this.a.getGapOpenCol());
        this.elgPen = Math.round((float)ALIGFACTOR * this.a.getGapExtCol());
        GapArray[] gapCol = new GapArray[this.colDim];
        GapArray[] gapRow = new GapArray[this.rowDim];
        for (int i = 0; i < this.colDim; ++i) {
            gapCol[i] = new GapArray();
        }
        for (int j = 0; j < this.rowDim; ++j) {
            gapRow[j] = new GapArray();
        }
        this.currentGap = new GapArray();
        AligMatEl[][] aligmat = this.a.getAligMat();
        int lastValue = aligmat[this.rowDim - 1][this.colDim - 1].getValue();
        aligmat[0][0].setValue(0);
        gapCol[0].setValue(0);
        gapCol[0].setIndex(0);
        gapRow[0].setValue(0);
        gapRow[0].setIndex(0);
        for (int j = 1; j < this.colDim; ++j) {
            aligmat[0][j].setValue(0);
            gapCol[j].setValue(-(this.openPen + this.elgPen));
            gapCol[j].setIndex(0);
        }
        for (int rowCounter = 1; rowCounter < this.rowDim; ++rowCounter) {
            aligmat[rowCounter][0].setValue(0);
            gapRow[rowCounter].setValue(-(this.openPen + this.elgPen));
            gapRow[rowCounter].setIndex(0);
            for (int colCounter = 1; colCounter < this.colDim; ++colCounter) {
                this.currentCell = aligmat[rowCounter][colCounter];
                this.currentCell.setValue(aligmat[rowCounter - 1][colCounter - 1].getValue() + this.currentCell.getValue());
                this.currentCell.setRow((short)(rowCounter - 1));
                this.currentCell.setCol((short)(colCounter - 1));
                this.openVal = aligmat[rowCounter - 1][colCounter].getValue() - (this.openPen + this.elgPen);
                this.elgVal = gapCol[colCounter].getValue() - this.elgPen;
                this.currentGap = new GapArray();
                if (this.openVal >= this.elgVal) {
                    this.currentGap.setValue(this.openVal);
                    this.currentGap.setIndex(rowCounter - 1);
                } else {
                    this.currentGap.setValue(this.elgVal);
                    this.currentGap.setIndex(gapCol[colCounter].index);
                }
                gapCol[colCounter] = this.currentGap;
                if (this.currentGap.getValue() > this.currentCell.getValue()) {
                    if (this.currentGap.getIndex() >= this.rowDim) {
                        System.err.println("col gap at" + rowCounter + " " + colCounter + " to " + this.currentGap.getIndex());
                    }
                    this.currentCell.setValue(this.currentGap.getValue());
                    this.currentCell.setRow((short)this.currentGap.getIndex());
                    this.currentCell.setCol((short)colCounter);
                }
                this.openVal = aligmat[rowCounter][colCounter - 1].getValue() - (this.openPen + this.elgPen);
                this.elgVal = gapRow[rowCounter].getValue() - this.elgPen;
                this.currentGap = new GapArray();
                if (this.openVal >= this.elgVal) {
                    this.currentGap.setValue(this.openVal);
                    this.currentGap.setIndex(colCounter - 1);
                } else {
                    this.currentGap.setValue(this.elgVal);
                    this.currentGap.setIndex(gapRow[rowCounter].getIndex());
                }
                gapRow[rowCounter] = this.currentGap;
                if (this.currentGap.getValue() > this.currentCell.getValue()) {
                    if (this.currentGap.getIndex() >= this.colDim) {
                        System.err.println("row gap at" + rowCounter + " " + colCounter + " to " + this.currentGap.getIndex());
                    }
                    this.currentCell.setValue(this.currentGap.getValue());
                    this.currentCell.setRow((short)rowCounter);
                    this.currentCell.setCol((short)this.currentGap.getIndex());
                }
                aligmat[rowCounter][colCounter] = this.currentCell;
            }
        }
        int rowCount = this.rowDim - 1;
        int colCount = this.colDim - 1;
        this.currentCell = aligmat[rowCount][colCount];
        this.currentCell.setValue(aligmat[rowCount - 1][colCount - 1].getValue() + lastValue);
        this.currentCell.setRow((short)(rowCount - 1));
        this.currentCell.setCol((short)(colCount - 1));
        for (k = 1; k <= rowCount; ++k) {
            val = aligmat[rowCount - k][colCount].getValue();
            if (val <= this.currentCell.getValue()) continue;
            this.currentCell.setValue(val);
            this.currentCell.setRow((short)(rowCount - k));
            this.currentCell.setCol((short)colCount);
        }
        for (k = 1; k <= colCount; ++k) {
            val = aligmat[rowCount][colCount - k].getValue();
            if (val <= this.currentCell.getValue()) continue;
            this.currentCell.setValue(val);
            this.currentCell.setRow((short)rowCount);
            this.currentCell.setCol((short)(colCount - k));
        }
        this.a.setScore((float)aligmat[this.rowDim - 1][this.colDim - 1].getValue() / (float)ALIGFACTOR);
        this.setPath();
    }

    private void setPath() {
        IndexPair[] backId = new IndexPair[this.a.getRows() + 1 + this.a.getCols() + 1];
        ArrayList<IndexPair> path = new ArrayList<IndexPair>();
        backId[0] = new IndexPair((short)this.a.getRows(), (short)this.a.getCols());
        int pathsize = 0;
        AligMatEl[][] aligmat = this.a.getAligMat();
        int n = 1;
        while (backId[n - 1].getRow() >= 1 && backId[n - 1].getCol() >= 1) {
            short x = backId[n - 1].getRow();
            short y = backId[n - 1].getCol();
            try {
                AligMatEl el = null;
                try {
                    el = aligmat[x][y];
                }
                catch (Exception e) {
                    e.printStackTrace();
                    for (int f = 0; f < n; ++f) {
                        System.out.println(backId[f]);
                    }
                }
                if (el == null) {
                    System.out.println("el = null! x:" + x + " y " + y);
                }
                backId[n] = el;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("x " + x);
                System.out.println("y " + y);
                System.out.println(backId[n - 2]);
                System.exit(0);
            }
            if (backId[n - 1].getRow() - backId[n].getRow() == 1 && backId[n - 1].getCol() - backId[n].getCol() == 1) {
                path.add(backId[n - 1]);
                ++pathsize;
            }
            ++n;
        }
        IndexPair[] newpath = new IndexPair[pathsize];
        for (int i = 0; i < pathsize; ++i) {
            IndexPair np;
            IndexPair o = (IndexPair)path.get(pathsize - 1 - i);
            newpath[i] = np = new IndexPair((short)(o.getRow() - 1), (short)(o.getCol() - 1));
        }
        this.a.setPath(newpath);
        this.a.setPathSize(pathsize);
    }
}

