/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.cath;

public enum CathCategory {
    Class,
    Architecture,
    Topolgy,
    Homology,
    SequenceFamily,
    OrthologousSequenceFamily,
    LikeSequenceFamily,
    IdenticalSequenceFamily,
    DomainCounter;

    static final String lut = "CATHSOLID";

    public static CathCategory fromString(String type) {
        if (type.equals("C")) {
            return Class;
        }
        if (type.equals("A")) {
            return Architecture;
        }
        if (type.equals("T")) {
            return Topolgy;
        }
        if (type.equals("H")) {
            return Homology;
        }
        if (type.equals("S")) {
            return SequenceFamily;
        }
        if (type.equals("O")) {
            return OrthologousSequenceFamily;
        }
        if (type.equals("L")) {
            return LikeSequenceFamily;
        }
        if (type.equals("I")) {
            return IdenticalSequenceFamily;
        }
        return DomainCounter;
    }

    public String toString() {
        switch (this) {
            case Class: {
                return "C";
            }
            case Architecture: {
                return "A";
            }
            case Topolgy: {
                return "T";
            }
            case Homology: {
                return "H";
            }
            case SequenceFamily: {
                return "S";
            }
            case OrthologousSequenceFamily: {
                return "O";
            }
            case LikeSequenceFamily: {
                return "L";
            }
            case IdenticalSequenceFamily: {
                return "I";
            }
        }
        return "D";
    }

    public static CathCategory fromCathCode(String code) {
        int count = 0;
        int idx = 0;
        while ((idx = code.indexOf(".", idx)) != -1) {
            ++count;
            ++idx;
        }
        return CathCategory.fromString(lut.substring(count, count + 1));
    }
}

