/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.io.FastaReader;
import org.biojava.nbio.core.sequence.io.template.SequenceCreatorInterface;
import org.biojava.nbio.core.sequence.io.template.SequenceHeaderParserInterface;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.io.StructureSequenceMatcher;

public class FastaStructureParser {
    private FastaReader<ProteinSequence, AminoAcidCompound> reader;
    private AtomCache cache;
    private String[] accessions;
    private ProteinSequence[] sequences;
    private Structure[] structures;
    private ResidueNumber[][] residues;

    public FastaStructureParser(InputStream is, SequenceHeaderParserInterface<ProteinSequence, AminoAcidCompound> headerParser, SequenceCreatorInterface<AminoAcidCompound> sequenceCreator, AtomCache cache) {
        this((FastaReader<ProteinSequence, AminoAcidCompound>)new FastaReader(is, headerParser, sequenceCreator), cache);
    }

    public FastaStructureParser(File file, SequenceHeaderParserInterface<ProteinSequence, AminoAcidCompound> headerParser, SequenceCreatorInterface<AminoAcidCompound> sequenceCreator, AtomCache cache) throws FileNotFoundException {
        this((FastaReader<ProteinSequence, AminoAcidCompound>)new FastaReader(file, headerParser, sequenceCreator), cache);
    }

    public FastaStructureParser(FastaReader<ProteinSequence, AminoAcidCompound> reader, AtomCache cache) {
        this.reader = reader;
        this.cache = cache;
        this.accessions = null;
        this.sequences = null;
        this.structures = null;
        this.residues = null;
    }

    public void process() throws IOException, StructureException {
        if (this.sequences == null) {
            LinkedHashMap sequenceMap = this.reader.process();
            this.sequences = sequenceMap.values().toArray(new ProteinSequence[0]);
            this.accessions = new String[this.sequences.length];
            this.structures = new Structure[this.sequences.length];
            this.residues = new ResidueNumber[this.sequences.length][];
            for (int i = 0; i < this.sequences.length; ++i) {
                this.accessions[i] = this.sequences[i].getAccession().getID();
                this.structures[i] = this.cache.getStructure(this.accessions[i]);
                this.residues[i] = StructureSequenceMatcher.matchSequenceToStructure(this.sequences[i], this.structures[i]);
                assert (this.residues[i].length == this.sequences[i].getLength());
            }
        }
    }

    public ProteinSequence[] getSequences() {
        return this.sequences;
    }

    public Structure[] getStructures() {
        return this.structures;
    }

    public ResidueNumber[][] getResidues() {
        return this.residues;
    }

    public String[] getAccessions() {
        return this.accessions;
    }
}

